/*
    Author: Maarten van Gelder, Groningen, Nederland
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Provide Graphical Functions to OriDraw and OriToPs
     First version dd.19850515   (Pascal)
     Converted to C   19950216
*/

/*extracth Local */

#define last_revision "19990701"
#define this_unit "OriLxtxt"
#define prog_version "unit"
#define mytracelevel 5
#define kar_width   10
#define kar_height  16

#if defined (__MSDOS__)
#include <conio.h>
#include <alloc.h>
#endif

/*extracth Global */

#include "orilproc.h"


/*extracth Vars */


/*extracth Local */

static boolean initialized=false;


/*extracth Functions */

FUNCTION void SetPenWidth(void)
{
   printf("SetPenWidth %3.2f ",penwidth);
}                                      /* SetPenWidth */


FUNCTION void ClearWindow(void)
{
   printf("ClearWindow ");
}                                      /* ClearWindow */


FUNCTION void DrawButtonsIfInX(int color_index,char *labelpar)
{
   if ((color_index==0) || (labelpar[0]==0)) color_index=0; /* So Turbo C wont complain */
}                                      /* DrawButtonsIfInX */


FUNCTION void StartDiagramGraphics(void)
{
   printf("=== StartDiagramGraphics %d %c\n",number,numberabc);
}                                      /* StartDiagramGraphics */


FUNCTION boolean KeyPressed(void)
{
#if defined (__MSDOS__)
   return kbhit();
#else
   return false;
#endif
}                                      /* KeyPressed */


FUNCTION char GetKey(void)
{
   char kar,kar1;

   kar1=0;
   do {
      kar=(char)toupper(getchar());
      if (kar1==0) kar1=kar;
   } while (kar!='\n');
   if (kar1=='Q') QuitSeen=true;
   return kar1;
}                                      /* GetKey */


FUNCTION void ResetTextModeAndColors(void)
{
   printf("ResetTextModeAndColors\n");
}                                      /* ResetTextModeAndColors */


FUNCTION void Beep(void)
{
#if defined(__MSDOS__)
   if (fastshow) {
      sound(420);
      delay(15);
   } else {
      sound(280);
      delay(50);
   }
   nosound();
#else
   printf("\007");
#endif
}                                      /* Beep */


static FUNCTION void ClearRectangle(int x1,int y1,int x2,int y2)
{
   if ((x1==0) && (y1==0) && (x2==0) && (y2==0)) x1=0; /* So Turbo C wont complain */
}                                      /* ClearRectangle */


static FUNCTION void DrawTextXY(int x,int y,char *text,boolean standard)
{
   if ((x==0) && (y==0) && standard) x=0; /* So Turbo C wont complain */
   printf("%s",text);
}                                      /* DrawTextXY */


FUNCTION void PrintString(char *fmt,...)
{
   va_list args;

/*lint -save -e737 */
   va_start(args,fmt);
/*lint -restore */
   (void)vprintf(fmt,args);
   printf("\n");
   va_end(args);
}                                      /* PrintString */


static FUNCTION void AskForContinue(char *prompt,boolean quitalso)
{
   if (quitalso) quitalso=true; /* So Turbo C wont complain */
   PrintString(prompt);
   Beep();
   GetKey();
}                                    /* AskForContinue */


#include "orilhelp.inc"


FUNCTION void InitializeOriLXxxx(int *argc,char *argv[])
{
   if (initialized) return;
   initialized=true;
   InitializeOriLProc(argc,argv);
   InitializeOriLHelp();
   CheckOriUpdate(last_revision);
   TRACE CheckMgSystem(this_unit,"InitializeOriLXxxx",true,mytracelevel,"Compiled at %s %s",__DATE__,__TIME__);
   maxscreenx=639;
   maxscreeny=400;
   extrafactor=1.0;
   xscale=1.0;
   yscale=1.0;
   fillcolor=2;
}                                      /* InitializeOriLXxxx */


FUNCTION void DumpStatus(void)
{
   FILE *dumpfile;

   CHECKINIT CheckMgSystem(this_unit,"DumpStatus",true,mytracelevel,NULL);
   dumpfile=DumpFileStart();
   fprintf(dumpfile,"   Number of points in polygon: %d\n",toppolypoints);
   fprintf(dumpfile,"\n");
   fclose(dumpfile);
}                                      /* DumpStatus */


static FUNCTION void AskNewNumber(void)
{
   TRACE CheckMgSystem(this_unit,"AskNewNumber",true,mytracelevel,NULL);
   diagramtoskipto=AskInt("Type number of diagram to skip to: ",0,0,999);
   if (diagramtoskipto==0) diagramtoskipto=number+1;
   if ((diagramtoskipto<=labs(number)) && (diagramtoskipto>-1)) again=true;
}                                      /* AskNewNumber */


FUNCTION void ShowHelp(void)
{
   ClearWindow();
   ShowOriDrawHelp(ori_program_name,"oridraw.hlp");
   StartDiagramGraphics();
}                                      /* ShowHelp */


FUNCTION void Interaction(boolean read)
{
   char kar;
   boolean doagain;

   diagramtoskipto= -1;
   doagain=! makepostscript || read;
   kar=' ';
   if (macroactive[0]==0) CopyStatus(&editstatus,&status); else CopyStatus(&editstatus,&globalstatus);
   while (doagain) {
      Beep();
      if (KeyPressed() || ! fastshow || read) kar=GetKey();
      if (kar==27) kar='Q';
      switch (kar) {
         case 'T': testmode=! testmode;        break;
         case 'P': (*markprocedure)();         break;
         case 'H': case '?': ShowHelp();       break;
          default: doagain=false;
      }
   }
   switch (kar) {
      case 'F': fastshow=true;           break;
      case 'N': fastshow=false;          break;
      case 'S': AskNewNumber();          break;
      case 'E': editfile=true;           break;
      case 'R': doagain=true;            break;
      case 'Q': finitobasta=true;        break;
       default: ;
   }
   if (finitobasta) {
      again=true;
      fastshow=false;
   }
   if (editfile || doagain) {
      again=true;
      if (fastshow) number=1;
      diagramtoskipto=abs(number);
   } else {
      if (! finitobasta) lasterror[0]=0;
   }
}                                      /* Interaction */


FUNCTION void ShowNumberInDiagram(void)
{
   if ((abs(number)<diagramtoskipto)) {
      printf("\r%2d < %2d  ",number,diagramtoskipto);
   } else {
      if (number>0) printf("\r%2d%c    ",number,numberabc);
   }
}                                      /* ShowNumberInDiagram */


static FUNCTION void ShowOriErrorMessage(char *txt)
{
   maxstring copy,temp;
   int i,posnr;

   InitString(temp,"",-1);
   sprintf(temp,"==>> Error in %s on line %d,  command: %c %c",status.filename,status.linenumber,status.kar,status.kar2);
   InitString(copy,status.line,-1);
   posnr=status.position;
   while (posnr>60) {
      DelChars(copy,0,20);
      posnr-=20;
   }
   if (strlen(copy)>76) copy[76]=0;
   printf("\n%s\n<%s>\n",temp,copy);
   for (i=0; i<posnr; i++) printf(" ");
   printf("^(%d)\n  >> %s\n",status.position,txt);
}                                      /* ShowOriErrorMessage */


static FUNCTION void ShowLastError(void)
{
   if (lasterror[0]!=0) ShowOriErrorMessage(lasterror);
}                                      /* ShowLastError */


FUNCTION void ShowError(char *fmt,...)
{
   va_list args;

/*lint -save -e737 */
   va_start(args,fmt);
/*lint -restore */
   CHECKINIT CheckMgSystem(this_unit,"ShowError",true,mytracelevel,fmt,args);
   (void)vsprintf(lasterror,fmt,args);
   ShowLastError();
   Interaction(true);
   va_end(args);
}                                      /* ShowError */


FUNCTION void SetFillColor(int color)
{
   if ((color<0) || (color>7)) {
      ShowError("FillColor must be in range 0..7");
      color=2;
   }
   if (color>=7) color+=2;
   if (color==0) color=15;
   fillcolor=color;
   printf("SetFillColor %d ",color);
}                                      /* SetFillColor */


FUNCTION void StartStopUnit(boolean start)
{
   CHECKINIT CheckMgSystem(this_unit,"StartStopUnit",initialized,mytracelevel,NULL);
   if (start==0) start=0; /* So Turbo C wont complain */
}                                    /* StartStopUnit */


static FUNCTION void DrawPolyLine(void)
{
   if (polypoints<2) ShowError("PolyLine with length %d",polypoints);
   printf("DrawPolyLine %d ",polypoints);
}                                      /* DrawPolyLine */


FUNCTION void DrawPolyPoints(int fillindex,boolean draw,boolean fill)
{
   CHECKINIT CheckMgSystem(this_unit,"DrawPolyPoints",true,mytracelevel,NULL);
   if (labs(number)>=diagramtoskipto) {
      if (polypoints<3) fill=false;
      if (fill) {
         if (fillindex>5) fillindex=5;
         if (fillindex<0) fillindex=0;
         printf("DrawPolyPoints filled ");
         if (draw) printf("and draw ");
      } else {
         DrawPolyLine();
      }
      if (symmetrical) printf("and in mirror ");
   }
   addtopoly=false;
   if (polypoints>toppolypoints) toppolypoints=polypoints;
   polypoints=0;
}                                      /* DrawPolyPoints */


FUNCTION void InitPoly(char *what)
{
   CHECKINIT CheckMgSystem(this_unit,"InitPoly",true,mytracelevel,NULL);
   if (addtopoly && (polypoints>0)) {
      ShowError("PolyLine not closed before drawing %s",what);
      DrawPolyPoints(0,true,false);
   }
   addtopoly=true;
   printf("InitPoly ");
}                                      /* InitPoly */


FUNCTION void ClosePoly(char *what)
{
   CHECKINIT CheckMgSystem(this_unit,"ClosePoly",true,mytracelevel,NULL);
   InitPoly(what);
   addtopoly=false;
   printf("ClosePoly ");
}                                      /* ClosePoly */


FUNCTION void PointToPoly(double x,double y,char what)
{
   int xi,yi;
   double xp,yp;
   boolean add;

   CHECKINIT CheckMgSystem(this_unit,"PointToPoly",true,mytracelevel,NULL);
   ConvertXY(x,y,&xi,&yi,&xp,&yp);
   CheckXyDraw(xp,yp);
   addtopoly=true;
   if (polypoints==0) {
      add=true;
   } else {
      add=false;
      if (xi!=(polypoint0+polypoints)->x) add=true;
      if (yi!=(polypoint0+polypoints)->y) add=true;
      if (polypoints>=max_poly) add=false;
   }
   if (add) {
      polypoints++;
      (polypoint0+polypoints)->x=xi;
      (polypoint0+polypoints)->y=yi;
      polypointw[polypoints]=what;
   }
}                                      /* PointToPoly */


FUNCTION void DrawLine(double x1,double y1,double x2,double y2)
{
   int xp1,xp2,yp1,yp2;
   double xps1,yps1,xps2,yps2;

   CHECKINIT CheckMgSystem(this_unit,"DrawLine",true,mytracelevel,NULL);
   if (labs(number)>=diagramtoskipto) {
      if (addtopoly) {
         PointToPoly(x1,y1,' ');
         PointToPoly(x2,y2,' ');
      } else {
         ConvertXY(x2,y2,&xp2,&yp2,&xps2,&yps2);
         ConvertXY(x1,y1,&xp1,&yp1,&xps1,&yps1);
         CheckXyDraw(xps2,yps2);
         CheckXyDraw(xps1,yps1);
         printf("DrawLine ");
      }
   }
}                                      /* DrawLine */


FUNCTION void DrawString(double x1,double y1,char *txt,boolean bold)
{
   int x,y,fsize;
   double xps,yps,tw,th,tm;

   if ((labs(number)>=diagramtoskipto) && (txt[0]!=0)) {
      fsize=Round(14/paperfactor);
      if (fsize<2) fsize=2;
      if (strlen(txt)>1) {
         tw=0;
         th=0;
      } else {
         tw=29/paperfactor;
         th=40/paperfactor;
      }
      ConvertXY(x1,y1,&x,&y,&xps,&yps);
      xps=xps-tw*0.5;
      yps=yps+th*0.5;
      printf("DrawString <%s> ",txt);
      if (symmetrical) printf("and in mirror ");
      CheckXyDraw(xps,yps);
      tm=0;
      tw=MeasureTextLength(&tm,txt);
      CheckXyDraw(xps+tw*39/paperfactor,yps-40/paperfactor);
   }
   if (bold) tm=0;    /* So Turbo C wont complain */
}                                      /* DrawString */


FUNCTION void NextHeaderLine(char *txt)
{
   papery=papery+50;
   diagram0->lines++;
   diagram0->textlen[diagram0->lines]=MeasureTextLength(&(diagram0->maxtextlen),txt);
}                                      /* NextHeaderLine */


FUNCTION void DrawBezierCurve(double x0,double y0,double x1,double y1,double x2,double y2,double x3,double y3,double dltd,boolean dotted)
{
   boolean filling;

   TRACE CheckMgSystem(this_unit,"DrawBezierCurve",true,mytracelevel,"%f %f  %f %f  %f %f  %f %f  %f %f  dltd=%f dotted=%d",x0,y0,x1,y1,x2,y2,x3,y3,dltd,dotted);
   filling=addtopoly;
   if (! filling && ! dotted) InitPoly("BezierCurve");
   if (! dotted) {
      PointToPoly(x0,y0,' ');
      PointToPoly(x1,y1,' ');
      PointToPoly(x2,y2,' ');
      PointToPoly(x3,y3,' ');
   }
   if (! filling && ! dotted) DrawPolyPoints(0,true,false);
   addtopoly=filling;
   printf("DrawBezierCurve ");
}                                    /* DrawBezierCurve */


FUNCTION void DrawFrame(void)
{
   printf("DrawFrame ");
}                                      /* DrawFrame */


FUNCTION void FormFeed(void)
{
   printpage++;
}                                      /* FormFeed */


FUNCTION void CloseDiagramSpecialToProgram(int dotsperline,int wide,int high)
{
   if ((dotsperline==0) || (wide==0) || (high==0)) wide=0; /* So Turbo C wont complain */
   printf("\nCloseDiagramSpecialToProgram nr=%d skipto=%d\n",number,diagramtoskipto);
}                                      /* CloseDiagramSpecialToProgram */


FUNCTION void DrawValleyFold(double x1,double y1,double x2,double y2,double dltd,double r)
{
   if ((dltd==0) || (r==0)) r=0; /* So Turbo C wont complain */
   printf("Valley:");
   DrawLine(x1,y1,x2,y2);
}                                      /* DrawValleyFold */


FUNCTION void DrawDottedLine(double x1,double y1,double x2,double y2,double dltd,double r)
{
   if ((dltd==0) || (r==0)) r=0; /* So Turbo C wont complain */
   printf("Dotted:");
   DrawLine(x1,y1,x2,y2);
}                                      /* DrawDottedLine */


FUNCTION void DrawMountainFold(double x1,double y1,double x2,double y2,double dltd,double r)
{
   if ((dltd==0) || (r==0)) r=0; /* So Turbo C wont complain */
   printf("Mountain:");
   DrawLine(x1,y1,x2,y2);
}                                      /* DrawMountainFold */


FUNCTION void ShowPages(void)
{
   int p,d;
   char kar;
   maxstring auth,auth1;

   CHECKINIT CheckMgSystem(this_unit,"ShowPages",true,mytracelevel,NULL);
   printf(" Model: %s\n",modelname);
   printf("  Date: %s\n",modeldate);
   InitString(auth,author,-1);
   InitString(auth1,"",-1);
   do {
      SplitString(auth1,-1,auth,-1,"/");
      printf("Author: %s\n",auth1);
   } while (!(auth[0]==0));
   for (p=1; p<=printpage; p++) {
      printf("Page %d of %d\n",p,printpage);
      for (d=1; d<=lastdiagram; d++) {
         if ((diagram0+d)->page==p) {
            printf("%3d%3d %4d %4d %4d %4d %3d\n",d,(diagram0+d)->page,(diagram0+d)->x,(diagram0+d)->y,
               (diagram0+d)->width,(diagram0+d)->heigth,(diagram0+d)->lines);
         }
      }
      printf("Continue? ");
      kar=GetKey();
      if (strchr("Q\003\032,\033",kar)!=NULL) p=printpage+1;
   }
}                                      /* ShowPages */


static FUNCTION boolean SpawnOk(char *cmd)
{
   double stime;
   int error;

   TRACE CheckMgSystem(this_unit,"SpawnOk",true,mytracelevel,NULL);
   FreeVariables();
#if defined(__MSDOS__)
   printf(" %ld core left\n",coreleft());
#endif
   printf("Command:<%s>\n",cmd);
   stime=HhMmSs();
   error=0;
   error=(int)system(cmd);
   if ((error!=0) || testmode) printf("Error=%d\n",error);
   stime=HhMmSs()-stime;
   if (testmode) printf("%5.2f seconds\n",stime);
   AllocateVariables();
   if ((error!=0) || (stime<2) || testmode) return false;
   return true;
}                                      /* SpawnOk */


FUNCTION void EditOriFile(void)
{
   maxstring ecmd,batfile;

   CHECKINIT CheckMgSystem(this_unit,"EditOriFile",true,mytracelevel,NULL);
   ShowLastError();
   InitString(ecmd,"",-1);
   InitString(batfile,"",-1);
   sprintf(batfile,"%soriedit.bat",programroot);
   if (! PathExist(batfile)) StringCopy(batfile,-1,"oriedit.bat",0);
   sprintf(ecmd,"%s %s %d",batfile,editstatus.filename,editstatus.linenumber);
   if (! SpawnOk(ecmd)) PressEnter();
   StartDiagramGraphics();
}                                      /* EditOriFile */


