/*
    Author: Maarten van Gelder, Groningen, Nederland
    E-mail: M.J.van.Gelder@rc.rug.nl

   Purpose: Include Help procedures for ORIDRAW program

     First version dd.19940815   (Pascal)
     Converted to C   19950215
*/

#define last_revision_help "19970620"
#define this_unit_help "OriLhelp_functions"
#define prog_version_help "incl"

typedef struct tl_record *textlinepointer;

typedef struct tl_record{
   maxstring text;
   textlinepointer next;
} textlinerecord;


static boolean help_initialized=false;
static textlinerecord *first_choice=NULL;
static int last_choice=0;
static int lines_shown=0;
static max_lines=22;
static max_in_menu=19;
static int menu_base=0;
static maxstring local_header;
static maxstring help_file_name;


static FUNCTION void InitializeOriLHelp(void)
{
   if (help_initialized) return;
   help_initialized=true;
   CheckOriUpdate(last_revision_help);
   InitString(local_header,"???",-1);
   InitString(help_file_name,"???",-1);
   if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"InitializeOriLHelp",true,mytracelevel,"Compiled at %s %s",__DATE__,__TIME__);
}                                      /* InitializeOriLHelp */


static FUNCTION void AddChoice(char *line)
{
   textlinerecord *aidh,*aid1,*extra;

   if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"AddChoice",true,mytracelevel,line);
   extra=(textlinerecord *)malloc(sizeof(textlinerecord));
   InitString(extra->text,line,-1);
   extra->next=NULL;
   aidh=first_choice;
   aid1=NULL;
   while (aidh!=NULL) {
      aid1=aidh;
      aidh=aidh->next;
   }
   if (first_choice==NULL) {
      first_choice=extra;
   } else {
      aid1->next=extra;
   }
   last_choice++;
}                                      /* AddChoice */


static FUNCTION void ShowHeader(void)
{
   ClearWindow();
   PrintString("Help file is: %s",help_file_name);
   PrintString("Help info:    %s",local_header);
   PrintString("---------------------------------------------------------------------------------");
   lines_shown=3;
}                                      /* ShowHeader */


static FUNCTION void W(char *txt)
{
   if (lines_shown>=max_lines) {
      if (! QuitSeen) {
         AskForContinue("Continue ...",true);
         ShowHeader();
      }
   }
   if (! QuitSeen) {
      lines_shown++;
      PrintString("%s",txt);
   }
}                                      /* W */


static FUNCTION void ShowOriDrawHelpPart(FILE *helpfile,char *header)
{
   maxstring line,head;
   boolean ready,doit,firstline;
   int blanklines,i;

   if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"ShowOriDrawHelpPart",true,mytracelevel,header);
   InitString(line,"",-1);
   InitString(head,"",-1);
   ready=false;
   doit=false;
   blanklines= -10;
   StringCopy(local_header,-1,header,0);
   StripBlanks(local_header);
   ShowHeader();
   (void)rewind(helpfile);
   firstline=true;
   QuitSeen=false;
   while (! ready && (ReadLn(helpfile,line,-1)!=EOF)) {
      if (firstline) InsertString("*** ",line,0,-1);
      firstline=false;
      SubString(head,-1,line,0,4,-1);
      if (Equal(head,"*** ")) {
         if (doit) {
            ready=true;
         } else {
            DelChars(line,0,4);
            StripBlanks(line);
            if (Equal(line,local_header)) doit=true;
         }
      } else {
         if (doit) {
            if ((int)strlen(line)>80) line[80]=0;
            for (i=(int)strlen(line)-1; i>=0; i--) {
               if (! isprint(line[i])) line[i]=' ';
            }
            StripTrailing(line);
            if (line[0]==0) {
               blanklines++;
            } else {
               for (i=1; i<=blanklines; i++) W("");
               blanklines=0;
               W(line);
            }
         }
      }
      if (QuitSeen) ready=true;
   }
   if ((! doit && ! ready) || (lines_shown==0)) {
      sprintf(line,"  >>>>>>   No help available for  <%s>",local_header);
      W(line);
   }
   if (! QuitSeen) {
      while (lines_shown<22) W("");
      AskForContinue("Continue ...",false);
   }
}                                      /* ShowOriDrawHelpPart */


static FUNCTION void HelpFileError(char *filename)
{
   if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"HelpFileError",true,mytracelevel,NULL);
   Beep();
   PrintString("Help-file %s is not available ...",filename);
   AskForContinue("Continue ...",false);
}                                      /* HelpFileError */


static FUNCTION void AskNextChoice(char *answer,int what_now)
{
   char kar;
   int pos,pl;
   maxstring prompt;

   if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"AskNextChoice",true,mytracelevel,NULL);
   InitString(prompt,"",-1);
   DrawButtonsIfInX(7,"Quit,Next");
   sprintf(prompt,"Type your choice (+ or - to shift display; 0 to exit) [%d]: ",what_now);
   pl=strlen(prompt);
   DrawTextXY(0,maxscreeny,prompt,true);
   answer[0]=0;
   pos=0;
   do {
      answer[pos]='_';
      answer[pos+1]=0;
      ClearRectangle(pl*kar_width,maxscreeny+kar_height,(pl+11)*kar_width,maxscreeny-kar_height-1);
      DrawTextXY(0,pl*kar_width,answer,true);
      kar=GetKey();
      if (kar=='N') {
         pos=0;
      } else if (strchr("+-",kar)!=NULL) {
         pos=1;
         answer[0]=kar;
      } else if ((kar==8) && (pos>0)) {
         pos--;
      } else if (isdigit(kar) && (pos<6)) {
         pos++;
         answer[pos-1]=kar;
      } else {
         if (strchr("\003\033\n\r",kar)==NULL) Beep();
      }
   } while (strchr("QX\003\033\n\rN+-",kar)==NULL);
   answer[pos]=0;
   if (strchr("QX\003\033",kar)!=NULL) StringCopy(answer,10,"0",0);
}                                      /* AskNextChoice */


static FUNCTION int HelpMenu(int what_now,char *which)
{
   int i,code;
   boolean ok;
   textlinepointer aid;
   string10 answer;

   if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"HelpMenu",true,mytracelevel,NULL);
   InitString(answer,"",10);
   ok=false;
   while (! ok) {
      ShowHeader();
      aid=first_choice;
      for (i=1; (i<=menu_base+max_in_menu) && (aid!=NULL); i++) {
         if (i>=menu_base) {
            PrintString("%5d  %s",i,aid->text);
         }
         aid=aid->next;
      }
      PrintString("");
      AskNextChoice(answer,what_now);
      if (answer[0]==0) {
         ok=true;
      } else if (isdigit(answer[0])) {
         what_now=(int)LongFromString(answer,&code);
         ok=(code==0);
         if (what_now>last_choice) {
            ok=false;
            what_now=1;
         }
      } else if (strchr("+-",answer[0])!=NULL) {
         if (answer[0]=='+') menu_base+=max_in_menu; else menu_base-=max_in_menu;
         if (menu_base>last_choice-max_in_menu) menu_base=last_choice-max_in_menu;
         if (menu_base<0) menu_base=0;
      }
   }
   aid=first_choice;
   for (i=1; i<what_now; i++) aid=aid->next;
   StringCopy(which,-1,aid->text,-1);
   return what_now;
}                                      /* HelpMenu */


static FUNCTION void ShowOriDrawHelp(char *header,char *filename)
{
   FILE * helpfile;
   maxstring line,which,head;
   int what_now;
   textlinepointer aid;

   if (! help_initialized || (mytracelevel<=tracelevel)) CheckMgSystem(this_unit,"ShowOriDrawHelp",help_initialized,mytracelevel,NULL);
   max_lines=((maxscreeny+1)/kar_height)-2;
   max_in_menu=max_lines-2;
   InitString(line,"",-1);
   InitString(which,"",-1);
   InitString(head,"",-1);
   StringCopy(help_file_name,-1,filename,0);
   if (! PathExist(help_file_name)) {
      sprintf(help_file_name,"%s%s",programroot,filename);
#if defined(__VAXVMS__)
      MakeVaxPath(help_file_name);
#endif
   }
   if (! PathExist(help_file_name)) {
      HelpFileError(help_file_name);
      return;
   }
   helpfile=fopen(help_file_name,"r");
   last_choice=0;
   while (ReadLn(helpfile,line,-1)!=EOF) {
      if (last_choice==0) InsertString("*** ",line,0,-1);
      SubString(head,-1,line,0,4,-1);
      if ((last_choice<100) && (Equal(head,"*** "))) {
         DelChars(line,0,4);
         StripBlanks(line);
         AddChoice(line);
      }
   }
   what_now=last_choice;
   while (what_now>0) {
      what_now++;
      if (what_now>last_choice) what_now=1;
      if (mytracelevel<=tracelevel) CheckMgSystem(this_unit,"ShowOriDrawHelp",true,mytracelevel,"local_header=<%s>, header=<%s>",local_header,header);
      StringCopy(local_header,-1,header,0);
      what_now=HelpMenu(what_now,which);
      if (what_now>0) ShowOriDrawHelpPart(helpfile,which);
   }
   fclose(helpfile);
   while (first_choice!=NULL) {
      aid=first_choice;
      first_choice=first_choice->next;
      free(aid);
   }
}                                      /* ShowOriDrawHelp */


