/*
      File: ORILFILE.h
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Supply input procedures for ORITOPS and ORIDRAW program sources
     First version dd.19940815   (Pascal)
     Converted to C   19950216
     Last revision   see file ORILFILE.c
*/

#if ! defined(_ORILFILE_)
#define _ORILFILE_


/* Definitions: */
/*GenMake off */
#include "orilxxxx.h"
/*GenMake on */
#include "../clib/mgifdef.h"


extern char macroparam;


/* Functions: */
/* FUNCTION */ void InitializeOriLFile(int *argc,char *argv[]);
/* FUNCTION */ boolean EofData(textfile *filerecord);
/* FUNCTION */ boolean EndOfLine(textfile *filerecord);
/* FUNCTION */ void SkipChar(textfile *filerecord);
/* FUNCTION */ char ReadChar(textfile *filerecord,boolean iskar2);
/* FUNCTION */ void SkipBlanks(textfile *filerecord);
/* FUNCTION */ void ReadItem(textfile *filerecord,char *txt);
/* FUNCTION */ double ReadDouble(textfile *filerecord);
/* FUNCTION */ void CheckMaxCoordinate(char which,double *c);
/* FUNCTION */ void ReadPoint(textfile *filerecord,double *px,double *py);
/* FUNCTION */ void ReadDouble3(textfile *filerecord,double *r1,double *r2,double *r3);
/* FUNCTION */ void ReadDouble4(textfile *filerecord,double *r1,double *r2,double *r3,double *r4);
/* FUNCTION */ void ReadDouble5(textfile *filerecord,double *r1,double *r2,double *r3,double *r4,double *r5);
/* FUNCTION */ void ReadDouble6(textfile *filerecord,double *r1,double *r2,double *r3,double *r4,double *r5,double *r6);
/* FUNCTION */ void ReadDouble8(textfile *filerecord,double *r1,double *r2,double *r3,double *r4,double *r5,double *r6,double *r7,double *r8);
/* FUNCTION */ int ReadInteger(textfile *filerecord);
/* FUNCTION */ char NextChar(textfile *filerecord);
/* FUNCTION */ void SkipLine(textfile *filerecord);
/* FUNCTION */ void ReadLine(textfile *filerecord,char *txt);
/* FUNCTION */ void ShowIfError(void);
/* FUNCTION */ void IfDirectiveCheck(textfile *filerecord);
/* FUNCTION */ void ResetDataStatus(textfile *filerecord,char *fname,boolean filealso,boolean linenumberalso);

#endif
