/*
      File: ORILXINT.h
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Provide Graphical Functions to OriDraw and OriToPs
     First version dd.19850515   (Pascal)
     Converted to C   19950216
     Last revision   see file ORILXINT.c
*/

#if ! defined(_ORILXINT_)
#define _ORILXINT_


/* Definitions: */
#include "orilproc.h"


/* Functions: */
/* FUNCTION */ void SetPenWidth(void);
/* FUNCTION */ void ClearWindow(void);
/* FUNCTION */ void DrawButtonsIfInX(int color_index,char *labelpar);
/* FUNCTION */ void StartDiagramGraphics(void);
/* FUNCTION */ boolean KeyPressed(void);
/* FUNCTION */ char GetKey(void);
/* FUNCTION */ void ResetTextModeAndColors(void);
/* FUNCTION */ void Beep(void);
/* FUNCTION */ void PrintString(char *fmt,...);
/* FUNCTION */ void InitializeOriLXxxx(int *argc,char *argv[]);
/* FUNCTION */ void DumpStatus(void);
/* FUNCTION */ void ShowHelp(void);
/* FUNCTION */ void Interaction(boolean read);
/* FUNCTION */ void ShowNumberInDiagram(void);
/* FUNCTION */ void ShowError(char *fmt,...);
/* FUNCTION */ void SetFillColor(int color);
/* FUNCTION */ void StartStopUnit(boolean start);
/* FUNCTION */ void DrawPolyPoints(int fillindex,boolean draw,boolean fill);
/* FUNCTION */ void InitPoly(char *what);
/* FUNCTION */ void ClosePoly(char *what);
/* FUNCTION */ void PointToPoly(double x,double y,char what);
/* FUNCTION */ void DrawLine(double x1,double y1,double x2,double y2);
/* FUNCTION */ void DrawString(double x1,double y1,char *txt,boolean bold);
/* FUNCTION */ void NextHeaderLine(char *txt);
/* FUNCTION */ void DrawBezierCurve(double x0,double y0,double x1,double y1,double x2,double y2,double x3,double y3,double dltd,boolean dotted);
/* FUNCTION */ void DrawFrame(void);
/* FUNCTION */ void FormFeed(void);
/* FUNCTION */ void CloseDiagramSpecialToProgram(int dotsperline,int wide,int high);
/* FUNCTION */ void DrawValleyFold(double x1,double y1,double x2,double y2,double dltd,double r);
/* FUNCTION */ void DrawDottedLine(double x1,double y1,double x2,double y2,double dltd,double r);
/* FUNCTION */ void DrawMountainFold(double x1,double y1,double x2,double y2,double dltd,double r);
/* FUNCTION */ void ShowPages(void);
/* FUNCTION */ void EditOriFile(void);

#endif
