/*
      File: ORILPROC.h
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Supply various procedures for ORITOPS and ORIDRAW program sources
     First version dd.19940815   (Pascal)
     Converted to C   19950215
     Last revision   see file ORILPROC.c
*/

#if ! defined(_ORILPROC_)
#define _ORILPROC_


/* Definitions: */
#include "../clib/mgprogio.h"
#include "../clib/mgifdef.h"


#define blankcomma " ,"
#define curvature_minimum  0.005
#define digits "0123456789-"
#define illegal " not permitted"
#define max_diagram       100
#define max_poly         2000
#define max_text           30
#define max_unit           10
#define nearly_two          1.99999
#define paper_max_x      2230
#define paper_max_y      3200


typedef struct tf_record *textfile_pointer;

typedef struct tf_record{
   maxstring filename,line;
   FILE * disk;
   int position,linenumber;
   boolean finished;
   textfile_pointer previous;
} textfile;

typedef struct{
   double x,y;
   boolean defined;
} defpointrecord;

typedef struct{
   maxstring filename,line;
   char kar,kar2;
   int position,linenumber;
} statusrecord;

typedef struct{
   short x,y;
} polypointrecord;

typedef char polypointtype[max_poly+1];

typedef struct{
   double xx,yx,zx,xy,yy,zy;
} projectionrecord;

typedef double textlenbuffer[max_text+1];

typedef struct{
   int page,x,y,width,heigth,lines;
   double xdmin,xdmax,ydmin,ydmax,pfactor,maxtextlen;
   string10 numbertext;
   textlenbuffer textlen;
} diagramrecord;

typedef struct us_record *unitstatus_pointer;

typedef struct us_record{
   boolean defined,symmetrical;
   double marginx,marginy,deltax,deltay,objectx,objecty,rmirror;
   double extrafactor,xyfactor,globalalfa,cosalfa,sinalfa;
   int fillcolor,imirror2,imirror2ps,imirror20ps;
   defpointrecord defpointA[27];
   projectionrecord projection;
} unitstatusrecord;

typedef double karlengthbuffer[129];

typedef boolean byteset[max_diagram+1];

typedef void procempty(void);

enum papertype {a4,a5};


extern boolean again,editfile,finitobasta,fastshow,makepostscript;
extern boolean symmetrical,addtopoly,threedimensional;
extern boolean firstdiagram,dumpatend,autopos,withframe;
extern byteset doubledef,numbers;
extern char numberabc,textlanguage;
extern double deltad,marginx,marginy,deltax,deltay,objectx,objecty,rmirror;
extern double penwidth,penwidthdefault,penwidthfactor,paperfactor,diagramheigth,xdrawmin,xdrawmax,ydrawmin,ydrawmax;
extern double saturation,extrafactor,lastpoint_x,lastpoint_y;
extern double xscale,yscale,xyfactor,globalalfa,cosalfa,sinalfa,fixpos,pidiv180,pi,pitimes2,pidiv2;
extern enum papertype paper;
extern int fillcolor,paperyatstart,imirror2,maxscreenx,maxscreeny,toppslines,toppslinestrlength;
extern int imirror2ps,imirror20ps,toptextlinestrlength,includelevel,diagramtoskipto,dumpnumber;
extern int lastdiagram,lastline,number,polypoints,toppolypoints,printpage,paperx,papery,paperplus;
extern karlengthbuffer karlength;
extern string20 dumpfilename,ori_program_version,ori_program_date,ori_program_name;
extern maxstring *textline0,copyright,author,modelname,modeldate,lasterror,macroactive,programroot,dataroot;
extern procempty *markprocedure;
extern defpointrecord *defpointA;
extern diagramrecord *diagram0;
extern maxstring startifkey;
extern projectionrecord projection;
extern statusrecord editstatus,globalstatus,status;
extern textfile globaldisk;
extern polypointrecord *polypoint0;
extern polypointtype polypointw;
extern unitstatus_pointer unitstatus[max_unit+1];


/* Functions: */
/* FUNCTION */ void AllocateVariables(void);
/* FUNCTION */ void FreeVariables(void);
/* FUNCTION */ textfile *AllocateTextFile(void);
/* FUNCTION */ void FreeTextFile(textfile *it);
/* FUNCTION */ void CopyStatus(statusrecord *dest,statusrecord *from);
/* FUNCTION */ void GetRootFrom(char *root,char *from);
/* FUNCTION */ void DeleteFile(char *fname);
/* FUNCTION */ void CheckOriUpdate(char *last_rev);
/* FUNCTION */ void InitializeOriLProc(int *argc,char *argv[]);
/* FUNCTION */ void NormalProjection(void);
/* FUNCTION */ double MeasureTextLength(double *maxtextlen,char *txt);
/* FUNCTION */ double Distance(double x1,double y1,double x2,double y2);
/* FUNCTION */ double BezierCurveLength(double x0,double y0,double x1,double y1,double x2,double y2,double x3,double y3);
/* FUNCTION */ void CheckXyDraw(double x,double y);
/* FUNCTION */ void ConvertXY(double x,double y,int *xp,int *yp,double *xps,double *yps);
/* FUNCTION */ void ConvertBZ(double x,double y,double *xps,double *yps);
/* FUNCTION */ void ConvertRM(double r,double x,double y,double *rps,double *xps,double *yps);
/* FUNCTION */ void CheckBorderPoint(double x,double y);
/* FUNCTION */ void SetFactor(double factor);
/* FUNCTION */ void SetAngle(double angle);
/* FUNCTION */ void UnitStatusSave(int u,boolean defpar);
/* FUNCTION */ void UnitStatusRestore(int u);
/* FUNCTION */ FILE *DumpFileStart(void);

#endif
