/*
      File: ORILPOST.h
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Supply PostScript procedures for ORITOPS
     First version dd.19940815   (Pascal)
     Converted to C   19950220
     Last revision   see file ORILPOST.c
*/

#if ! defined(_ORILPOST_)
#define _ORILPOST_


/* Definitions: */
#include "orilproc.h"


/* Functions: */
/* FUNCTION */ void InitializeOriLPost(int *argc,char *argv[]);
/* FUNCTION */ void PsWriteString(double x,double y,char *txt_value,boolean bold);
/* FUNCTION */ void PsWriteHeader(double x,double y,char *txt_value);
/* FUNCTION */ void PsSetPenWidth(void);
/* FUNCTION */ void PsStartDiagramGraphics(void);
/* FUNCTION */ void PsWriteLine(double x1,double y1,double x2,double y2);
/* FUNCTION */ void PsWriteDashLine(double x1,double y1,double x2,double y2,double d1,double d2,double d3,double d4);
/* FUNCTION */ void PsWritePolyPoints(int fillindex,boolean draw,boolean fill);
/* FUNCTION */ void PsWriteBezier(double x0,double y0,double x1,double y1,double x2,double y2,double x3,double y3,double d1,double d2);
/* FUNCTION */ void PsSetFillColor(int color);
/* FUNCTION */ void PsWriteInitPage(int pagenr);
/* FUNCTION */ void PsOpenFile(char *orifilename);
/* FUNCTION */ void PsCloseDiagram(int dotsperline,int wide,int high);
/* FUNCTION */ void PsCloseFile(void);
/* FUNCTION */ void PsRemoveFile(void);

#endif
