/*
      File: ORILDRAW.h
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Supply graphical procedures for ORITOPS and ORIDRAW program sources
     First version dd.19940815   (Pascal)
     Converted to C   19950216
     Last revision   see file ORILDRAW.c
*/

#if ! defined(_ORILDRAW_)
#define _ORILDRAW_


/* Definitions: */
/*GenMake off */
#include "orilxxxx.h"
/*GenMake on */


/* Functions: */
/* FUNCTION */ void InitializeOriLDraw(int *argc,char *argv[]);
/* FUNCTION */ void PointCrossLines(double *x,double *y,double x2,double y2,double x3,double y3,double x4,double y4);
/* FUNCTION */ void PointBisectrice(double *x,double *y,double x1,double y1,double x2,double y2);
/* FUNCTION */ void PointMirrorInLine(double *x,double *y,double x1,double y1,double x2,double y2);
/* FUNCTION */ void PointTurn(double *x,double *y,double angle);
/* FUNCTION */ void PointPlus(double *x,double *y,double dx,double dy);
/* FUNCTION */ void PointTimes(double *x,double *y,double factor);
/* FUNCTION */ void DrawBezierCurveInStyle(double x0,double y0,double x1,double y1,double x2,double y2,double x3,double y3,char kar2);
/* FUNCTION */ void DrawArrowHead(double xa,double ya,double xe,double ye,double alfa,double dltd,char arrowstyle);
/* FUNCTION */ void DrawArcArrowInStyle(double x1,double y1,double x2,double y2,double k,double dltd,char *options);
/* FUNCTION */ void DrawEllips(double x0,double y0,double xr,double yr,double angle);
/* FUNCTION */ void DrawRepeatArrow(double x1,double y1,double xp,double yp,char kar2,char *txt);
/* FUNCTION */ void DrawZigZagFold(double x1,double y1,double x2,double y2,char kar2);
/* FUNCTION */ void DrawRollOverFold(double x1,double y1,double x2,double y2);
/* FUNCTION */ void DrawAnEye(double x1,double y1,double x2,double y2);
/* FUNCTION */ void DrawTurnOver(void);
/* FUNCTION */ void DrawEnlarge(void);
/* FUNCTION */ void DrawUnfold(double k);
/* FUNCTION */ void DrawFoldInsideOut(void);
/* FUNCTION */ void DrawRotate(double k);
/* FUNCTION */ void DrawLineInStyle(double x1,double y1,double x2,double y2,char kar2);
/* FUNCTION */ void ShowStatistics(void);

#endif
