/*
      File: ORILCMND.h
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Supply command procedures for ORITOPS and ORIDRAW program sources
     First version dd.19940815   (Pascal)
     Converted to C   19950216
     Last revision   see file ORILCMND.c
*/

#if ! defined(_ORILCMND_)
#define _ORILCMND_


/* Definitions: */
#include "orildraw.h"
#include "orilfile.h"


/* Functions: */
/* FUNCTION */ void MarkAllPoints(void);
/* FUNCTION */ void InitializeOriLCmnd(int *argc,char *argv[]);
/* FUNCTION */ void FillCommand(textfile *disk);
/* FUNCTION */ void SymbolCommand(textfile *disk);
/* FUNCTION */ void CoordinateSystemCommand(textfile *disk);
/* FUNCTION */ void DoPointCommand(char kar,char kar2,boolean relative,double x,double y,double x2,double y2,double x3,double y3,double x4,double y4,double z,double dx,double dy);
/* FUNCTION */ void PointCommand(textfile *disk);
/* FUNCTION */ void ArcArrowCommand(textfile *disk);
/* FUNCTION */ void EllipsCommand(textfile *disk);
/* FUNCTION */ void BezierCurveCommand(textfile *disk);
/* FUNCTION */ void RectangleCommand(textfile *disk);
/* FUNCTION */ void PolyLine(textfile *disk);
/* FUNCTION */ void SetWithFrame(textfile *disk);
/* FUNCTION */ void PaperLayoutCommand(textfile *disk);
/* FUNCTION */ void SkipComment(textfile *disk);
/* FUNCTION */ void TextCommand(textfile *disk);
/* FUNCTION */ void UnitCommand(textfile *disk);
/* FUNCTION */ void SkipToDiagram(textfile *ifile,char *iname);
/* FUNCTION */ void ResetDefaults(boolean all);
/* FUNCTION */ void TestCommand(textfile *disk);

#endif
