/*
    Author: Maarten van Gelder, Groningen, Nederland
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Shows diagrams from Origami directives on screen
            See ORIDRAW.DOC for full documentation
     First version dd.19850515   (Pascal)
     Converted to C   19950220
*/

#define last_revision "19990331"
#define this_unit "OriDraw"
#define prog_version "prog"
#define mytracelevel 1


#include "orilglbl.h"
#include "orilxint.h"

#if defined(__MSDOS__)
#include <dos.h>
#else
#include <signal.h>
#endif


FUNCTION void InitializeOridraw(int *argc,char *argv[])
{
   InitString(ori_program_name,this_unit,20);
   InitString(ori_program_date,last_revision,20);
   InitializeOriLGlbl(argc,argv);
   TRACE CheckMgSystem(this_unit,"InitializeOriDraw",true,mytracelevel,NULL);
   StringCopy(dumpfilename,20,"oridraw_.dmp",0);
   ProgramHeader(stdout);
}                                      /* InitializeOridraw */


FUNCTION void StartOriDraw(void)
{
   TRACE CheckMgSystem(this_unit,"StartOriDraw",true,mytracelevel,NULL);
   if (! PathExist(globaldisk.filename)) StringCat(globaldisk.filename,-1,".ori",0);
   if (! PathExist(globaldisk.filename)) {
      printf("\aFile <%s> doesn\'t exist ...\a\n",globaldisk.filename);
      if (AskIf("Create file",true)) CreateNewFile(); else exit(1);
   }
}                                      /* StartOriDraw */


FUNCTION void StartDataFile(void)
{
   int i;
   char kar;

   TRACE CheckMgSystem(this_unit,"StartDataFile",true,mytracelevel,NULL);
   if (! StartGlobalDataFileOk()) {
      PrintString("");
      PrintString("Press:");
      PrintString("   q <Enter>      to quit and UpGrade the file separately");
      PrintString("   <Enter>        to Edit the .ORI file");
      Beep();
      PrintString("");
      kar=GetKey();
      if (strchr("\003\033qQxX",kar)!=NULL) exit(1);
      editfile=true;
      again=true;
      StringCopy(editstatus.filename,-1,globaldisk.filename,-1);
      editstatus.linenumber=1;
   }
   paperyatstart=40;
   for (i=0; i<(int)strlen(author); i++) {
      if (author[i]=='/') paperyatstart=paperyatstart+50;
   }
   papery=paperyatstart;
}                                      /* StartDataFile */


FUNCTION void Restart(void)
{
   int i;

   TRACE CheckMgSystem(this_unit,"Restart",true,mytracelevel,NULL);
   i=0;
   printf("\r%70s\r","");
   do {
      if (i>0) {
         if (i==1) printf("Try to open file %s again .",globaldisk.filename); else printf(".");
         fflush(stdout);
         sleep(1);
      }
      globaldisk.disk=fopen(globaldisk.filename,"r");
      i++;
   } while ((i<=10) && (globaldisk.disk==NULL));
   if (globaldisk.disk==NULL) AbortBecause("Couldn't open file within 10 retries");
   if (i>1) printf(" Ok");
   ResetDefaults(true);
   lasterror[0]=0;
   StartDiagramGraphics();
   again=false;
   editfile=false;
   StartDataFile();
   CopyStatus(&globalstatus,&status);
   SetFillColor(2);
}                                      /* Restart */


FUNCTION void CloseDatafile(void)
{
   TRACE CheckMgSystem(this_unit,"CloseDatafile",true,mytracelevel,NULL);
   if (! again) NextDiagram(&globaldisk,false);
   fclose(globaldisk.disk);
}                                      /* CloseDatafile */


/*OriDoc ClosingAction
.PAGE Closing action
After drawing the last diagram some information is shown. Then you are
asked to give the next action. You may select one of:

   H   Help: show help information
   E   Edit .ORI file
   Q   Quit ORIDRAW
   R   Repeat the model
   S   Show pages (nn)

ORIDRAW can show you the layout of the diagrams on the printerpages as it
will be generated by ORITOPS.
*/


FUNCTION void AskClosingAction(void)
{
   char kar;

   TRACE CheckMgSystem(this_unit,"AskClosingAction",true,mytracelevel,NULL);
   do {
      ClearWindow();
      DrawButtonsIfInX(4,"Quit,Repeat,Edit,ShowPag,Help");
      PrintString(ProgramHeaderString());
      PrintString("");
      ShowStatistics();
      PrintString("");
      PrintString("Make a choice from one of these actions:");
      PrintString("");
      PrintString("   H   Help: show help information");
      PrintString("   E   Edit %s",globaldisk.filename);
      PrintString("   Q   Quit OriDraw");
      PrintString("   R   Repeat model");
      PrintString("   S   Show pages (%d)",printpage);
      PrintString("");
      PrintString("What do you want? ");
      kar=GetKey();
      switch (kar) {
         case 'H': ShowHelp();          break;
         case 'E': EditOriFile();       break;
         case 'R': again=true;          break;
         case 'Q': finitobasta=true;    break;
         case 'S': ShowPages();         break;
         case 'D': DumpStatus();        break;
         case 27: finitobasta=true;     break;
         case -1: finitobasta=true;     break;
         default: Beep();
      }
   } while (! finitobasta && ! again);
}                                      /* AskClosingAction */


FUNCTION void ExitProcedure(void)
{
   TRACE CheckMgSystem(this_unit,"ExitProcedure",true,mytracelevel,NULL);
   ResetTextModeAndColors();
   DeleteMacroFiles();
   if (dumpatend) DumpStatus();
   ProgramTrailer(stdout);
}                                      /* ExitProcedure */


FUNCTION int /* OriDraw */ main(int argc,char *argv[])
{
   InitializeOridraw(&argc,argv);
   ScanProgramParameters(argc,argv);
   StartOriDraw();
   do {
      Restart();
      if (! finitobasta && ! again) InterpretCommands(&globaldisk);
      CloseDatafile();
      if (editfile && (editstatus.linenumber>0)) EditOriFile();
      if (! finitobasta && ! again) {
         AskClosingAction();
         diagramtoskipto= -1;
      }
      if (finitobasta) printf("\n  Finito Basta\n");
   } while (! finitobasta);
   ExitProcedure();
   return 0;
}
