/*
      File: MGPROGIO.h
    Author: Maarten van Gelder,  KVI / RuG,  Groningen,  Nederland
   Purpose: Provide basic functions for my C programs
     First version dd.19900913
     Last revision   see file MGPROGIO.c
*/

#if ! defined(_MGPROGIO_)
#define _MGPROGIO_


/* Definitions: */
#if defined(__VMS__)
#pragma nostandard
#endif

#include <ctype.h>
#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include <errno.h>
#include <limits.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <math.h>
#include <float.h>

#if defined(__MSDOS__)
#include <dos.h>
#endif

#if defined(__VMS__)
#include <starlet.h>
#include <stsdef.h>
#include <jpidef.h>
#include <clidef.h>
#include <lib$routines.h>
#include <ssdef.h>
#include <lnmdef.h>
#include <prvdef.h>
#include <descrip.h>
#define DSC_DESCR_S struct dsc$descriptor_s
#endif


#define FUNCTION /* */
#define CHECKINIT      if (( mytracelevel <= tracelevel ) || ! initialized )
#define TRACE          if (  mytracelevel <= tracelevel )


#define maxstringlength 255
#define extra_string_bytes 5
#define extra_string "\0MVG\0"
typedef char maxstring[maxstringlength+extra_string_bytes];

typedef char string10[10+extra_string_bytes];
typedef char string12[12+extra_string_bytes];
typedef char string20[20+extra_string_bytes];
typedef char string30[30+extra_string_bytes];
typedef char string40[40+extra_string_bytes];
typedef char string50[50+extra_string_bytes];
typedef char string60[60+extra_string_bytes];
typedef char string70[70+extra_string_bytes];
typedef char string80[80+extra_string_bytes];
typedef char string90[90+extra_string_bytes];
typedef char string100[100+extra_string_bytes];
typedef char string110[110+extra_string_bytes];
typedef char string120[120+extra_string_bytes];
typedef char string128[128+extra_string_bytes];

#define boolean int
#define false 0
#define true  1

#if defined(__MSDOS__)
#define slash_char    '\\'
#define slash_str     "\\"
#define dereference   "..\\"
#else
#define slash_char    '/'
#define slash_str     "/"
#define dereference   "../"
#endif

#define Ctrl_A           1
#define Ctrl_B           2
#define Ctrl_C           3
#define Ctrl_D           4
#define Ctrl_E           5
#define Ctrl_F           6
#define Ctrl_G           7
#define Ctrl_H           8
#define Ctrl_I           9
#define Ctrl_J          10
#define Ctrl_K          11
#define Ctrl_L          12
#define Ctrl_M          13
#define Ctrl_N          14
#define Ctrl_O          15
#define Ctrl_P          16
#define Ctrl_Q          17
#define Ctrl_R          18
#define Ctrl_S          19
#define Ctrl_T          20
#define Ctrl_U          21
#define Ctrl_V          22
#define Ctrl_W          23
#define Ctrl_X          24
#define Ctrl_Y          25
#define Ctrl_Z          26
#define Esc_Key         27

#define Page_Up        -71
#define Page_Down      -72
#define Up_Arrow       -73
#define Down_Arrow     -74
#define Left_Arrow     -75
#define Right_Arrow    -76
#define Home_Key       -77
#define End_Key        -78
#define Del_Key        -79
#define Ins_Key        -80
#define Del_Back       -81

#define GFI_ABSENT      -1
#define GFI_DIR         -2

#if defined(__VMS__)
#define MG_RETURN_CODE_OK   1
#else
#define MG_RETURN_CODE_OK   0
#endif

#define longnamefile "00long.nam"


extern string20 global_program_name,global_program_date,global_program_version,Hexal;
extern boolean QuitSeen,testmode,checkstrings,mgprogio_test,in_batch,dontchecknonascii;
extern int tracelevel;
extern char bell_char;


/* Functions: */
/* FUNCTION */ void ShowErrorMVaList(char *fmt,va_list args);
/* FUNCTION */ void ShowErrorMessage(char *fmt,...);
/* FUNCTION */ void AbortBecause(char *fmt,...);
/* FUNCTION */ void CheckMgSystem(char *libname,char *procname,boolean initialized,int requestlevel,char *fmt,...);
/* FUNCTION */ void CheckNonAscii(boolean doit);
/* FUNCTION */ void StringCheck(char *str,char *where,int maxchars);
/* FUNCTION */ void StringCopy(char *dest,int maxdest,char *from,int maxfrom);
/* FUNCTION */ void InitString(char *txt,char *info,int max);
/* FUNCTION */ void StringCat(char *dest,int maxdest,char *from,int maxfrom);
#if ! defined(_lint)
#if defined(strcpy)
#undef strcpy
#endif
#if defined(strncpy)
#undef strncpy
#endif
#if defined(strcat)
#undef strcat
#endif
#if defined(strncat)
#undef strncat
#endif
#define strcpy StringCopy
#define strncpy StringCopy
#define strcat StringCat
#define strncat StringCat
#endif
#define Equal(str1,str2)   (strcmp(str1,str2)==0)
#define HeadOf(str1,str2)   (strncmp(str1,str2,strlen(str2))==0)
/* FUNCTION */ char *AllocString(int max);
/* FUNCTION */ void UpString(char *str);
/* FUNCTION */ void LowString(char *str);
/* FUNCTION */ void GetSymbol(char *answer,char *name);
/* FUNCTION */ void InitializeMgProgIo(char *p_name,char *p_date,char *p_version,int *argc,char *argv[]);
/* FUNCTION */ void CheckUpdate(char *p_date);
/* FUNCTION */ void DelChars(char *str,int start,int count);
/* FUNCTION */ void InsertString(char *extra,char *dest,int start,int maxdest);
/* FUNCTION */ void StripTrailing(char *str);
/* FUNCTION */ void StripBlanks(char *str);
/* FUNCTION */ void StripMultipleBlanks(char *str);
/* FUNCTION */ void SubString(char *dest,int maxdest,char *from,int start,int count,int maxfrom);
/* FUNCTION */ void SplitString(char *head,int maxhead,char *tail,int maxtail,char *split_on);
/* FUNCTION */ void SplitStringRight(char *head,int maxhead,char *tail,int maxtail,char *split_on);
/* FUNCTION */ void StandardizeDate(char *date,boolean punctuated);
/* FUNCTION */ void FormatDateTime(char *datime,time_t tv);
/* FUNCTION */ void DateTime(char *datime);
/* FUNCTION */ double HhMmSs(void);
/* FUNCTION */ void MonthName(char *name,int month,int max);
/* FUNCTION */ int MonthNumber(char *monthname);
/* FUNCTION */ void LongToString(char *txt,long number,int width);
/* FUNCTION */ void DoubleToString(char *txt,double number,int width,int fraction);
/* FUNCTION */ double DoubleFromString(char *txt,int *code);
/* FUNCTION */ long LongFromString(char *txt,int *code);
/* FUNCTION */ int IntFromPar(char *txt,int deflt);
/* FUNCTION */ int Round(double real);
/* FUNCTION */ int ReadLn(FILE *inputfile,char *line,int max);
/* FUNCTION */ char *ProgramHeaderString(void);
/* FUNCTION */ void ProgramHeader(FILE *fp);
/* FUNCTION */ void ProgramTrailer(FILE *fp);
/* FUNCTION */ boolean AskIf(char *txt,int deflt);
/* FUNCTION */ int AskInt(char *prompt,int dflt,int min,int max);
/* FUNCTION */ void PressEnter(void);
/* FUNCTION */ void GetUserName(char *user_name);
/* FUNCTION */ void FormatSlashes(char *text,char slash);
/* FUNCTION */ void GetDirOption(char *root,char *keyword_par,char *option);
/* FUNCTION */ void LongNameToDos(char *longname_par,char *dosname);
/* FUNCTION */ void DosNameToLong(char *dosname_par,char *longname);
/* FUNCTION */ void DosFileNameToLong(char *dospath,char *dosname_par,char *longname);
/* FUNCTION */ void MakeLongNameFiles(char *data_root,char *par,boolean show_cmd);
/* FUNCTION */ int PathExist(char *name);
/* FUNCTION */ void DereferencePath(char *path);
/* FUNCTION */ void FSearch(char *my_path,char *fname,char *path_found);
/* FUNCTION */ void MakeVaxPath(char *path);
/* FUNCTION */ void VaxPathToUnix(char *path);
/* FUNCTION */ FILE *OpenFile(char *name,char *how,boolean abortonerror);
/* FUNCTION */ void VaxErrorMessage(char *txt,int error);
/* FUNCTION */ long GetFileInfo(char *fname_par,char *modtime);
/* FUNCTION */ char *CdUpString(int level);
/* FUNCTION */ void ConvertItem(char *line,char *old_txt,char *new_txt);

#endif
