/*
      File: MGIFDEF.h
    Author: Maarten van Gelder,  KVI / RuG,  Groningen,  Nederland
   Purpose: Provide 'IF' and 'DEF' functions for my C programs
     First version dd.19940815   (Pascal)
     Converted to C   19950215
     Copied at        19961214   (from OrilProc.C)
     Last revision   see file MGIFDEF.c
*/

#if ! defined(_MGIFDEF_)
#define _MGIFDEF_


/* Definitions: */
#include "../clib/mgprogio.h"


#define IFDEF_OK          0
#define IFDEF_UNKNOWN     1
#define IFDEF_ACTIVE      2
#define IFDEF_INACTIVE    3
#define IFDEF_NO_KEYWORD  4
#define IFDEF_TOO_MANY    5
#define IFDEF_TOO_DEEP    6
#define IFDEF_ELSES       7


/* Functions: */
/* FUNCTION */ void FormatErrorMessage(int error,char *fmt,...);
/* FUNCTION */ char *IfDefErrorMessage(void);
/* FUNCTION */ char *IfDefKeyString(void);
/* FUNCTION */ boolean IfDefReset(boolean close);
/* FUNCTION */ void InitializeMgIfDef(void);
/* FUNCTION */ boolean IfDefDirectiveCheck(char *line_par);
/* FUNCTION */ boolean IfDefSaysYes(void);
/* FUNCTION */ boolean IfDefAddKeys(char *line_par);
/* FUNCTION */ boolean IfDefDeleteKeys(char *line_par);

#endif
