/*
      File: mgifdef.c
    Author: Maarten van Gelder,  KVI / RuG,  Groningen,  Nederland
   Purpose: Provide 'IF' and 'DEF' functions for my C programs
     First version dd.19940815   (Pascal)
     Converted to C   19950215
     Copied at        19961214   (from OrilProc.C)
*/

/*extracth Local */

#define last_revision "19981119"
#define this_unit "MgIfDef"
#define prog_version "unit"
#define mytracelevel     7
#define max_if_level    10
#define max_key_string_length 528

/*extracth Global */


#include "../clib/mgprogio.h"


#define IFDEF_OK          0
#define IFDEF_UNKNOWN     1
#define IFDEF_ACTIVE      2
#define IFDEF_INACTIVE    3
#define IFDEF_NO_KEYWORD  4
#define IFDEF_TOO_MANY    5
#define IFDEF_TOO_DEEP    6
#define IFDEF_ELSES       7


/*extracth Local */

typedef char keystring[max_key_string_length+extra_string_bytes];

static boolean initialized=false,else_active=false;
static int if_level=-1,correct=IFDEF_OK;
static boolean if_is_true[max_if_level+2];
static keystring ifkeys;
static maxstring message;


/*extracth Functions */

FUNCTION void FormatErrorMessage(int error,char *fmt,...)
{
   va_list args;

/*lint -save -e737 */
   va_start(args,fmt);
/*lint -restore */
   vsprintf(message,fmt,args);
   correct=error;
   va_end(args);
}                                      /* FormatErrorMessage */


FUNCTION char *IfDefErrorMessage(void)
{
   CHECKINIT CheckMgSystem(this_unit,"IfDefErrorMessage",initialized,mytracelevel,NULL);
   return message;
}                                    /* IfDefErrorMessage */


FUNCTION char *IfDefKeyString(void)
{
   CHECKINIT CheckMgSystem(this_unit,"IfDefKeyString",initialized,mytracelevel,NULL);
   return ifkeys;
}                                    /* IfDefKeyString */


FUNCTION boolean IfDefReset(boolean close)
{
   CHECKINIT CheckMgSystem(this_unit,"IfDefReset",initialized,mytracelevel,NULL);
   correct=IFDEF_OK;
   InitString(message,"",-1);
   if (if_level>0) FormatErrorMessage(IFDEF_ACTIVE,"IF still active on %sIfDef",close?"Close":"Reset");
   if_level=0;
   InitString(ifkeys," ",max_key_string_length);
   if_is_true[0]=true;
   if_is_true[max_if_level+1]=true;
   return correct;
}                                    /* IfDefReset */


FUNCTION void InitializeMgIfDef(void)
{
   if (initialized) return;
   initialized=true;
   CheckUpdate(last_revision);
   TRACE CheckMgSystem(this_unit,"InitializeMgIfDef",true,mytracelevel,"Compiled at %s %s",__DATE__,__TIME__);
   IfDefReset(false);
}                                      /* InitializeMgIfDef */


static FUNCTION void MakeBKeyB(char *keyword,char *bkeyb)
{
   TRACE CheckMgSystem(this_unit,"MakeBKeyB",true,mytracelevel,"<%s>",keyword);
   InitString(bkeyb,"",30);
   StripBlanks(keyword);
   sprintf(bkeyb," %s ",keyword);
}                                    /* MakeBKeyB */


static FUNCTION void SplitKeyword(char *keyword,char *line,int max)
{
   TRACE CheckMgSystem(this_unit,"SplitKeyword",true,mytracelevel,"%s max=%d",line,max);
   InitString(keyword,"",20);
   SplitString(keyword,20,line,max," ");
   UpString(keyword);
   if (keyword[0]==0) FormatErrorMessage(IFDEF_NO_KEYWORD,"No keyword found");
}                                    /* SplitKeyword */


static FUNCTION void AddKeyword(char *keyword)
{
   string30 bkeyb;

   CHECKINIT CheckMgSystem(this_unit,"AddKeyword",initialized,mytracelevel,keyword);
   MakeBKeyB(keyword,bkeyb);
   if ((keyword[0]!=0) && (strstr(ifkeys,bkeyb)==NULL)) {
      if (strlen(ifkeys)+strlen(bkeyb)>=max_key_string_length) {
         FormatErrorMessage(IFDEF_TOO_MANY,"Active keyword list too long: can't add keyword (%s)",keyword);
      } else {
         StringCat(ifkeys,max_key_string_length,keyword,20);
         StringCat(ifkeys,max_key_string_length," ",0);
      }
   }
}                                      /* AddKeyword */


static FUNCTION void DeleteKeyword(char *keyword)
{
   string30 bkeyb;
   char *p;

   TRACE CheckMgSystem(this_unit,"DeleteKeyword",initialized,mytracelevel,keyword);
   MakeBKeyB(keyword,bkeyb);
   p=strstr(ifkeys,bkeyb);
   if (p!=NULL) DelChars(ifkeys,(int)(p-ifkeys),strlen(bkeyb)-1);
}                                      /* DeleteKeyword */


static FUNCTION boolean IfKeyPresent(char *keyword)
{
   string30 bkeyb;

   TRACE CheckMgSystem(this_unit,"IfKeyPresent",initialized,mytracelevel,keyword);
   MakeBKeyB(keyword,bkeyb);
   return (strstr(ifkeys,bkeyb)!=NULL);
}                                      /* IfKeyPresent */


static FUNCTION void IfKeyPlus(char *line,int max)
{
   string20 keyword;

   TRACE CheckMgSystem(this_unit,"IfKeyPlus",initialized,mytracelevel,"%s max=%d",line,max);
   SplitKeyword(keyword,line,max);
   if (if_is_true[if_level]) AddKeyword(keyword);
}                                      /* IfKeyPlus */


static FUNCTION void IfKeyNot(char *line,int max)
{
   string20 keyword;

   TRACE CheckMgSystem(this_unit,"IfKeyNot",initialized,mytracelevel,"%s max=%d",line,max);
   SplitKeyword(keyword,line,max);
   if (if_is_true[if_level]) {
      if (IfKeyPresent( keyword)) DeleteKeyword(keyword); else AddKeyword(keyword);
   }
}                                      /* IfKeyNot */


static FUNCTION void IfKeyCopy(char *line,int max)
{
   string20 keyfrom,keyto;

   TRACE CheckMgSystem(this_unit,"IfKeyCopy",initialized,mytracelevel,"%s max=%d",line,max);
   SplitKeyword(keyfrom,line,max);
   SplitKeyword(keyto,line,max);
   if (if_is_true[if_level]) {
      if (IfKeyPresent(keyfrom)) AddKeyword(keyto); else DeleteKeyword(keyto);
   }
}                                      /* IfKeyCopy */


static FUNCTION void IfKeyMinus(char *line,int max)
{
   string20 keyword;

   TRACE CheckMgSystem(this_unit,"IfKeyMinus",initialized,mytracelevel,"%s max=%d",line,max);
   SplitKeyword(keyword,line,max);
   if (if_is_true[if_level]) DeleteKeyword(keyword);
}                                      /* IfKeyMinus */


static FUNCTION void IfKeyCheck(char *line,int max,boolean par)
{
   maxstring keyword;

   TRACE CheckMgSystem(this_unit,"IfKeyCheck",initialized,mytracelevel,"line=<%s> par=%d",line,par);
   SplitKeyword(keyword,line,max);
   if_level++;
   if (if_level>max_if_level) {
      FormatErrorMessage(IFDEF_TOO_DEEP,"Maximum nest level for IF is %d",max_if_level);
   } else {
      if_is_true[if_level]=(IfKeyPresent(keyword)==par) && if_is_true[if_level-1];
   }
   else_active=false;
}                                      /* IfKeyCheck */


static FUNCTION void IfKeyElse(void)
{
   TRACE CheckMgSystem(this_unit,"IfKeyElse",initialized,mytracelevel,NULL);
   if (if_level==0) {
      FormatErrorMessage(IFDEF_INACTIVE,"IF not (yet) active on ELSE");
      if_is_true[if_level]=true;
   } else if (else_active) {
      FormatErrorMessage(IFDEF_ELSES,"Second ELSE for same IF");
   } else {
      if_is_true[if_level]=(! if_is_true[if_level]) && if_is_true[if_level-1];
      else_active=true;
   }
}                                      /* IfKeyElse */


static FUNCTION void IfKeyEnd(void)
{
   TRACE CheckMgSystem(this_unit,"IfKeyEnd",initialized,mytracelevel,NULL);
   if (if_level==0) FormatErrorMessage(IFDEF_INACTIVE,"IF not (yet) active on ENDIF"); else if_level--;
   else_active=false;
}                                      /* IfKeyEnd */


FUNCTION boolean IfDefDirectiveCheck(char *line_par)
{
   maxstring key;
   char *line;
   int len;

   CHECKINIT CheckMgSystem(this_unit,"IfDefDirectiveCheck",initialized,mytracelevel,line_par);
   InitString(message,"",-1);
   InitString(key,"",-1);
   len=strlen(line_par)+1;
   line=AllocString(len);
   InitString(line,line_par,len);
   correct=IFDEF_OK;
   SplitString(key,-1,line,len," ");
   UpString(key);
   if (Equal(key,"COPY"))   IfKeyCopy(line,len);             else
   if (Equal(key,"DEFINE")) IfKeyPlus(line,len);             else
   if (Equal(key,"DEF"))    IfKeyPlus(line,len);             else
   if (Equal(key,"IF"))     IfKeyCheck(line,len,true);       else
   if (Equal(key,"IFDEF"))  IfKeyCheck(line,len,true);       else
   if (Equal(key,"IFNOT"))  IfKeyCheck(line,len,false);      else
   if (Equal(key,"IFNDEF")) IfKeyCheck(line,len,false);      else
   if (Equal(key,"ELSE"))   IfKeyElse();                     else
   if (Equal(key,"ENDIF"))  IfKeyEnd();                      else
   if (Equal(key,"IFEND"))  IfKeyEnd();                      else
   if (Equal(key,"NOT"))    IfKeyNot(line,len);              else
   if (Equal(key,"UNDEF"))  IfKeyMinus(line,len);            else
   {
      FormatErrorMessage(IFDEF_UNKNOWN,"Directive not permitted: %s",key);
   }
   if_is_true[0]=true;
   free(line);
   return correct;
}                                      /* IfDefDirectiveCheck */


FUNCTION boolean IfDefSaysYes(void)
{
   CHECKINIT CheckMgSystem(this_unit,"IfDefSaysYes",initialized,mytracelevel,"%d",if_is_true[if_level]);
   return if_is_true[if_level];
}                                    /* IfDefSaysYes */


FUNCTION boolean IfDefAddKeys(char *line_par)
{
   string20 keyword;
   char *line;
   int len;

   CHECKINIT CheckMgSystem(this_unit,"IfDefAddKeys",initialized,mytracelevel,line_par);
   correct=IFDEF_OK;
   InitString(message,"",-1);
   len=strlen(line_par)+1;
   line=AllocString(len);
   InitString(line,line_par,len);
   while (line[0]!=0) {
      SplitKeyword(keyword,line,len);
      AddKeyword(keyword);
   }
   free(line);
   return correct;
}                                    /* IfDefAddKeys */


FUNCTION boolean IfDefDeleteKeys(char *line_par)
{
   string20 keyword;
   char *line;
   int len;

   CHECKINIT CheckMgSystem(this_unit,"IfDefDeleteKeys",initialized,mytracelevel,line_par);
   correct=IFDEF_OK;
   InitString(message,"",-1);
   len=strlen(line_par)+1;
   line=AllocString(len);
   InitString(line,line_par,len);
   while (line[0]!=0) {
      SplitKeyword(keyword,line,len);
      DeleteKeyword(keyword);
   }
   free(line);
   return correct;
}                                    /* IfDefDeleteKeys */


