<?xml version="1.0" encoding="UTF-8"?>
<!--<!DOCTYPE xsl:stylesheet [
		<!~~ width of list symbol in 'cm' ~~>
        <!ENTITY list-label-width "0.5">
]>-->
<!--

    OpenOffice.org - a multi-platform office productivity suite
 
    $RCSfile: body.xsl,v $
 
    $Revision: 1.7 $
 
    last change: $Author: rt $ $Date: 2005/09/08 22:08:14 $
 
    The Contents of this file are made available subject to
    the terms of GNU Lesser General Public License Version 2.1.
 
 
      GNU Lesser General Public License Version 2.1
      =============================================
      Copyright 2005 by Sun Microsystems, Inc.
      901 San Antonio Road, Palo Alto, CA 94303, USA
 
      This library is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License version 2.1, as published by the Free Software Foundation.
 
      This library is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
 
      You should have received a copy of the GNU Lesser General Public
      License along with this library; if not, write to the Free Software
      Foundation, Inc., 59 Temple Place, Suite 330, Boston,
      MA  02111-1307  USA
 
-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:office="http://openoffice.org/2000/office"
		xmlns:style="http://openoffice.org/2000/style"
		xmlns:text="http://openoffice.org/2000/text"
		xmlns:table="http://openoffice.org/2000/table"
		xmlns:draw="http://openoffice.org/2000/drawing"
		xmlns:fo="http://www.w3.org/1999/XSL/Format"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:number="http://openoffice.org/2000/datastyle"
		xmlns:svg="http://www.w3.org/2000/svg"
		xmlns:chart="http://openoffice.org/2000/chart"
		xmlns:dr3d="http://openoffice.org/2000/dr3d"
		xmlns:math="http://www.w3.org/1998/Math/MathML"
		xmlns:form="http://openoffice.org/2000/form"
		xmlns:script="http://openoffice.org/2000/script"
		xmlns:dc="http://purl.org/dc/elements/1.1/"
		xmlns:meta="http://openoffice.org/2000/meta"
		xmlns:config="http://openoffice.org/2001/config"
		xmlns:help="http://openoffice.org/2000/help"
		exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help"
		xmlns="http://www.w3.org/1999/xhtml">


	<!--+++++ INCLUDED XSL MODULES +++++-->

	<!-- helper collection, to convert measures (e.g. inch to pixel using DPI (dots per inch) parameter)-->
	<xsl:import  href="../../common/measure_conversion.xsl" />

	<!-- common office body element handling -->
	<xsl:import  href="../common/body.xsl" />

	<!-- common table handling -->
	<xsl:import  href="../common/table/table.xsl" />

	<!-- xhtml table handling -->
	<xsl:include  href="table.xsl" />

	<!-- OPTIONAL - MASTER DOCUMENT handling
	by default disabled in conjunction with following paramter 'masterDocument' set to 'false()' -->
	<xsl:include  href="master_document.xsl" />

	<!-- Useful in case of 'style:map', conditional formatting, where a style references to another -->
	<xsl:key name="styles" match="/*/office:styles/style:style | /*/office:automatic-styles/style:style" use="@style:name" />


	<!-- ************ -->
	<!-- *** body *** -->
	<!-- ************ -->

	<xsl:template name="create-body">
		<xsl:param name="globalData" />

		<!-- multiple backgroundimages for different page styles (never used in html) -->
		<xsl:variable name="backgroundImage" select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/style:background-image" />
		<!-- approximation as attribute belongs to a page style, which won't work in XHTML -->
		<xsl:variable name="writingMode" select="/office:document/office:automatic-styles/style:page-master/style:properties/@style:writing-mode" />
		<xsl:element name="body">
			<!-- direction of text flow -->
			<xsl:if test="$writingMode">
				<xsl:choose>
					<xsl:when test="contains($writingMode, 'lr')">
						<xsl:attribute name="dir">ltr</xsl:attribute>
					</xsl:when>
					<xsl:when test="contains($writingMode, 'rl')">
						<xsl:attribute name="dir">rtl</xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</xsl:if>

			<!-- background image -->
			<xsl:if test="$backgroundImage/@xlink:href">
				<xsl:attribute name="style">
					<xsl:text>background-image:url(</xsl:text>
					<xsl:call-template name="create-href">
						<xsl:with-param name="href" select="$backgroundImage/@xlink:href" />
					</xsl:call-template>
					<xsl:text>);</xsl:text>

					<xsl:if test="$backgroundImage/@style:repeat">
						<xsl:choose>
							<xsl:when test="$backgroundImage/@style:repeat = 'no-repeat'">
								<xsl:text>background-repeat:no-repeat;</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>background-repeat:repeat;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<xsl:if test="$backgroundImage/@style:position">
						<xsl:text>background-position:</xsl:text>
						<xsl:value-of  select="$backgroundImage/@style:position" />
						<xsl:text>;</xsl:text>
					</xsl:if>
				</xsl:attribute>
			</xsl:if>

			<!-- processing the content of the xml file -->
			<xsl:apply-templates select="/*/office:body">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>



	<xsl:template match="office:body">
		<xsl:param name="globalData" />

		<!-- not using of 'apply-styles-and-content' as the content table information migth have been added to 'globalData' variable -->
		<xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name | @table:style-name"><!-- | @presentation:style-name -->
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>


		<!-- Usability feature, a link to the content table above all level 1 header -->
		<xsl:if test="$masterDocumentEnabled">
			<xsl:call-template  name="add-child-document-usability-links" />
		</xsl:if>

		<xsl:choose>
			<!--If the input document is a master document and embed child documents (links) the transformation of the children will be started as well.
				This is necessary as child documents do not know anything about their embedding into a master document. Headings of childs
				always start to count by zero instead of continously numbering.
				For this, the heading numbers of the current document (as a sequence of a master document) is dependent
				of the number of heading of the same level in preceding documents.
				In case of multiple children, for usability reasons some linking is gonna be offered and the URLs of the content-table,
				preceding and following file have to be given for the transformation.
				-->
			<xsl:when test="$masterDocumentEnabled">
				<xsl:choose>
					<xsl:when test="/*/@office:class='text-global' and /*/office:body/text:section/text:section-source/@xlink:href">
						<!-- the children will be called later with a modified 'globalData' variable -->
						<xsl:call-template name="transform-global-document-and-children">
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates>
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>

		<!-- Usability feature, a link to the content-table above of all level-1 header -->
		<xsl:if test="$masterDocumentEnabled">
			<xsl:call-template  name="add-child-document-usability-links" />
		</xsl:if>
	</xsl:template>

	<!-- ******************************* -->
	<!-- *** User Field Declarations *** -->
	<!-- ******************************* -->

	<xsl:key name="user-field-decl" match="/*/office:body/text:user-field-decls/text:user-field-decl" use="@text:name" />

	<xsl:template match="text:user-field-get">
		<xsl:param name="globalData" />

		<xsl:value-of select="key('user-field-decl', @text:name)/@text:string-value" />
	</xsl:template>


	<!-- *************** -->
	<!-- *** Textbox *** -->
	<!-- *************** -->

	<xsl:template match="draw:text-box">
		<xsl:param name="globalData" />

		<xsl:element name="div">
			<xsl:if test="@svg:height | @svg:width">
				<xsl:attribute name="style">
					<xsl:choose>
						<xsl:when test="not(@svg:width)">
							<xsl:call-template  name="svg:height" />
						</xsl:when>
						<xsl:when test="not(@svg:height)">
							<xsl:call-template  name="svg:width" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template  name="svg:height" />
							<xsl:call-template  name="svg:width" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@draw:name">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:apply-templates>

			<xsl:call-template name="apply-styles-and-content">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

	<!-- inline style helper for the 'div' boxes -->
	<xsl:template name="svg:height">
		<xsl:text>height: </xsl:text>
		<xsl:choose>
			<!-- changing the distance measure: inch to in -->
			<xsl:when test="contains(@svg:height, 'inch')">
				<xsl:value-of  select="substring-before(@svg:height, 'ch')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of  select="@svg:height" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>; </xsl:text>
	</xsl:template>

	<!-- inline style helper for the 'div' boxes -->
	<xsl:template name="svg:width">
		<xsl:text>width: </xsl:text>
		<xsl:choose>
			<!-- changing the distance measure: inch to in -->
			<xsl:when test="contains(@svg:width, 'inch')">
				<xsl:value-of  select="substring-before(@svg:width, 'ch')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of  select="@svg:width" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>; </xsl:text>
	</xsl:template>



	<!-- ****************** -->
	<!-- *** Paragraphs *** -->
	<!-- ****************** -->

	<xsl:template match="text:p | draw:page">
		<xsl:param name="globalData" />
		<!-- 1) A draw:text-box my include paragraphs (text:p) itself and in HTML a 'p' can only have inline documents (no other 'p' as children'),
				a 'div' will be given out instead.
			 2) A images are embedded in a paragraph, but are in CSS not able to express a horizontal alignment for themself (text:align is only valid for block elements).
				A surrounding 'div' element taking over the image style solves that problem, but is invalid as child of a paragraph
		-->
		<xsl:choose>
			<xsl:when test="draw:text-box or draw:image">
				<xsl:element name="div">
					<xsl:call-template name="apply-styles-and-content">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="p">
					<!-- empty paragraph tags does not provoke an carridge return,
						therefore an non breakable space (&nbsp) have been inserted.-->
					<xsl:choose>
						<xsl:when test="*">
							<xsl:call-template name="apply-styles-and-content">
								<xsl:with-param name="globalData" select="$globalData" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="apply-styles-and-content">
								<xsl:with-param name="globalData" select="$globalData" />
							</xsl:call-template>
							<xsl:text>&#160;</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- ***************** -->
	<!-- *** Text Span *** -->
	<!-- ***************** -->

	<xsl:template match="text:span">
		<xsl:param name="globalData" />

		<xsl:element name="span">
			<xsl:call-template name="apply-styles-and-content">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:element>
	</xsl:template>



	<!-- **************** -->
	<!-- *** Headings *** -->
	<!-- **************** -->

	<xsl:template match="text:h">
		<xsl:param name="globalData" />

		<!-- no creation of empty headings (without text content)   -->
		<xsl:if test="text()">
			<xsl:choose>
				<xsl:when test="$masterDocumentEnabled">
					<xsl:choose>
						<xsl:when test="$childDocumentExist and $javaEnabled">
							<!-- no embedding the orginal header, as an explicit anchor might be already set -->
							<xsl:call-template name="create-heading">
								<xsl:with-param name="globalData" select="$globalData" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
						<!-- The URL linking of an table-of-content is due to a bug (cp. bug id# 102311) not mapped as URL in the XML.
							 Linking of the table-of-content can therefore only be archieved by a work-around in HTML -->
							<xsl:call-template name="create-heading">
								<xsl:with-param name="globalData" select="$globalData" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
				<!-- The URL linking of an table-of-content is due to a bug (cp. bug id# 102311) not mapped as URL in the XML.
					 Linking of the table-of-content can therefore only be archieved by a work-around in HTML -->
					<xsl:call-template name="create-heading">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!-- default matching for header elements -->
	<xsl:template name="create-heading">
		<xsl:param name="globalData" />

		<xsl:choose>
			<!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
			<xsl:when test="$outputType = 'CSS_HEADER'">

				<xsl:variable  name="headertyp" select="concat('h', @text:level)" />
					<xsl:element name="{$headertyp}">
					<!-- outline style 'text:min-label-width' is interpreted as a CSS 'margin-left' attribute
					NOTE: Should be handled as CSS style in style header -->
					<xsl:variable  name="min-label" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/style:properties/@text:min-label-width" />
					<xsl:if test="$min-label">
						<xsl:attribute name="style">
							<xsl:text>margin-left:</xsl:text>
							<xsl:call-template name="convert2cm">
								<xsl:with-param name="value" select="$min-label" />
							</xsl:call-template>
							<xsl:text>cm;</xsl:text>
						</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="class">
						<xsl:value-of  select="translate(@text:style-name, '. %()/\+', '')" />
					</xsl:attribute>

					<!-- Every heading element will get an unique anchor for its file, from its hiearchy level and name:
						 For example:  The heading title 'My favorite heading' might get <a name="1_2_2_My_favorite_heading" /> -->
					<!-- creating an anchor for referencing the heading (e.g. from content table) -->
					<xsl:call-template name="create-heading-anchor">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>

					<!-- writing out a heading number if desired.-->
					<!-- if a corresponding 'text:outline-style' exist or is not empty -->
					<xsl:if test="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@style:num-format != ''">
						<xsl:choose>
							<!-- for the creation of the global documents (developers guide) -->
							<xsl:when test="$childDocumentExist and $javaEnabled">
								<!-- NOTE: This call is dependent on java helper!! -->
								<xsl:call-template name="get-heading-number">
									<xsl:with-param name="precedingChapterLevel1" select="$precedingChapterLevel1" />
									<xsl:with-param name="globalData" select="$globalData" />
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
									<xsl:call-template name="write-heading-number">
										<xsl:with-param name="globalData" select="$globalData" />
									</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>

					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>
			<!--+++++ HTML 4.0 INLINED WAY  +++++-->
			<xsl:when test="$outputType = 'CSS_INLINED'">
				<xsl:variable  name="headertyp" select="concat('h', @text:level)" />
				<xsl:element name="{$headertyp}">

					<xsl:attribute name="style">
						<!-- NOTE: is this adding of a workaround for the end of flow attributes still necessary? Why not used in CSS? (check HistoryHouse) -->
						<xsl:text>clear:both; </xsl:text>
						<xsl:value-of  select="$globalData/all-styles/style[@style:name = current()/@text:style-name]/final-properties" />
					</xsl:attribute>

					<!-- writing out a heading number if desired.
						 If a corresponding 'text:outline-style' exist or is not empty -->
					<xsl:if test="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@style:num-format != ''">
						<xsl:call-template name="write-heading-number">
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:call-template>
					</xsl:if>

					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>
		</xsl:choose>
	</xsl:template>


	<!-- creating an anchor for referencing the heading -->
	<xsl:template name="create-heading-anchor">
		<xsl:param name="globalData" />

		<xsl:choose>
			<xsl:when test="$masterDocumentEnabled">
				 <xsl:if test="$childDocumentExist and $javaEnabled">
					<!-- Every heading element will get an unique anchor for its file, from its hiearchy level and name:
						 For example:  The heading title 'My favorite heading' might get <a name="1_2_2_My_favorite_heading" /> -->
					<!-- necessary as anchor for the content table -->
					<xsl:call-template name="create-content-table-anchor">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
			<!-- The URL linking of an table-of-content is due to a bug (cp. bug id# 102311) not mapped as URL in the XML.
				 Linking of the table-of-content can therefore only be archieved by a work-around in HTML -->
				<xsl:call-template name="create-default-heading-anchor">
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- default matching for header elements -->
	<xsl:template name="create-default-heading-anchor">
		<xsl:variable name="title"><xsl:apply-templates mode="concatenate" /></xsl:variable>
		<xsl:element namespace="{$namespace}" name="a">
			<xsl:attribute name="name">
				<xsl:call-template name="encode-string">
				<!-- the space has to be normalized,
					otherwise an illegal argument exception will be thrown for XT-->
					<xsl:with-param name="textToBeEncoded" select="normalize-space(string($title))" />
				</xsl:call-template>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<xsl:template name="write-heading-number">
		<xsl:param name="globalData" />

		<xsl:choose>
			<xsl:when test="$childDocumentExist and $javaEnabled and ($outputType = 'CSS_HEADER')">
				<!-- A heading no in a child document, which is referenced by a master document,
					is part of a whole sequence of documents.
					Therefore the starting heading no is dependent of the headers,
					which occured in preceding documents.
					NOTE: This call is dependent on java helper! -->
				<xsl:call-template name="get-heading-number">
					<xsl:with-param name="precedingChapterLevel1" select="$precedingChapterLevel1" />
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- By default heading start with '1', the parameter 'textStartValue' will only be set, if the attribute @text:start-value exist -->
				<xsl:choose>
					<xsl:when test="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@text:start-value">
						<xsl:call-template name="calc-heading-number">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="textLevel" select="@text:level" />
							<xsl:with-param name="textStartValue" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@text:start-value" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="calc-heading-number">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="textLevel" select="@text:level" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
	Find the correct heading no, which is the sum of 'text:start-value'
	and preceding siblings of 'text:h' with the same 'text:level' (until a text:level with lower value is found).
	If the 'text:start-value is not set the default value of '1' has to be taken.
	If a heading number is found (e.g. text:level='3') all heading numbers
	for the higher levels have to be written out -->
	<xsl:template name="calc-heading-number">
		<xsl:param name="globalData" />
		<xsl:param name="textLevel" /><!-- text level of the heading -->
		<xsl:param name="iTextLevel" select="1" /><!-- iterator, counts from 1 to the text level of the heading -->
		<xsl:param name="textStartValue" select="1" /><!-- text level to start with, default is '1' -->

		<xsl:choose>
			<!-- iText levels counts up from '1' to textLevel
				Which means writing a heading number from left to right -->
			<xsl:when test="$iTextLevel &lt; $textLevel">

			<!-- Write preceding heading numbers -->
				<xsl:variable name="numberDigit">
					<xsl:call-template name="calc-heading-digit">
						<xsl:with-param name="value" select="0" />
						<xsl:with-param name="currentTextLevel" select="$iTextLevel" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="numberSuffix" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = ($textLevel)]/@style:num-suffix" />
				<xsl:variable name="numberFormat" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@style:num-format" />
				<xsl:number value="$numberDigit" format="{$numberFormat}{$numberSuffix}"/>
				<xsl:choose>
					<xsl:when test="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = ($iTextLevel + 1)]/@text:start-value">
						<xsl:call-template name="calc-heading-number">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="textLevel" select="$textLevel" />
							<xsl:with-param name="iTextLevel" select="$iTextLevel + 1" />
							<xsl:with-param name="textStartValue" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = ($iTextLevel + 1)]/@text:start-value" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="calc-heading-number">
							<xsl:with-param name="globalData" select="$globalData" />
							<xsl:with-param name="textLevel" select="$textLevel" />
							<xsl:with-param name="iTextLevel" select="$iTextLevel + 1" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- Write preceding heading numbers -->
				<xsl:variable name="numberDigit">
					<xsl:call-template name="calc-heading-digit">
						<xsl:with-param name="value" select="$textStartValue" />
						<xsl:with-param name="currentTextLevel" select="$iTextLevel" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="numberSuffix" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = ($textLevel)]/@style:num-suffix" />
				<xsl:variable name="numberFormat" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@style:num-format" />
				<xsl:number value="$numberDigit" format="{$numberFormat}{$numberSuffix}"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="calc-heading-digit">
		<xsl:param name="value" />
		<xsl:param name="currentTextLevel" />
		<xsl:param name="i" select="1" />

		<xsl:variable name="precedingTextLevel" select="preceding-sibling::text:h[$i]/@text:level" />
		<xsl:choose>
			<xsl:when test="$currentTextLevel = $precedingTextLevel">
				<xsl:call-template name="calc-heading-digit">
					<xsl:with-param name="value" select="$value + 1" />
					<xsl:with-param name="currentTextLevel" select="$currentTextLevel" />
					<xsl:with-param name="i" select="$i + 1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$currentTextLevel &lt; $precedingTextLevel">
				<xsl:call-template name="calc-heading-digit">
					<xsl:with-param name="value" select="$value" />
					<xsl:with-param name="currentTextLevel" select="$currentTextLevel" />
					<xsl:with-param name="i" select="$i + 1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Neglect Annotations -->
	<xsl:template match="office:annotation" mode="concatenate" />

    <!-- Match text:placeholder child nodes (e.g. text) -->
    <xsl:template match="text:placeholder">
        <xsl:param name="globalData" />

        <xsl:call-template name="apply-styles-and-content">
            <xsl:with-param name="globalData" select="$globalData" />
        </xsl:call-template>
    </xsl:template>

	<!-- ************* -->
	<!-- *** Link  *** -->
	<!-- ************* -->

	<xsl:template match="text:a | draw:a">
		<xsl:param name="globalData" />

		<xsl:call-template name="create-common-anchor-link">
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:call-template>
	</xsl:template>


	<xsl:template name="create-common-anchor-link">
		<xsl:param name="globalData" />

		<xsl:element name="a">
			<xsl:attribute name="href">
				<xsl:call-template name="create-href">
					<xsl:with-param name="href" select="@xlink:href" />
				</xsl:call-template>
			</xsl:attribute>
			<!--<xsl:attribute name="class">ContentLink</xsl:attribute>-->
			<xsl:call-template name="apply-styles-and-content">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>
		</xsl:element>
	</xsl:template>



	<!-- ******************* -->
	<!-- *** Image Link  *** -->
	<!-- ******************* -->

	<!-- currently suggesting that all draw:object-ole elements are images -->
	<xsl:template match="draw:image | draw:object-ole">
		<xsl:param name="globalData" />

		<xsl:choose>
			<xsl:when test="parent::text:p or parent::text:span or parent::text:h or parent::draw:a or parent::text:a or text:ruby-base">
				<!-- XHTML does not allow the mapped elements to contain paragraphs -->
				<xsl:call-template name="create-image-element">
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- images are embedded in a paragraph, but are in CSS not able to express a horizontal alignment for themself.
					A 'div' element taking over the image style would solve that problem, but is invalid as child of a paragraph -->
				<xsl:element name="p">
					<xsl:apply-templates select="@draw:style-name">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>

					<xsl:call-template name="create-image-element">
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:call-template>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="create-image-element">
		<xsl:param name="globalData" />

		<xsl:element name="img">
			<xsl:if test="@svg:width">
				<xsl:attribute name="width">
					<xsl:call-template name="convert2px">
						<xsl:with-param name="value" select="@svg:width" />
					</xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@svg:height">
				<xsl:attribute name="height">
					<xsl:call-template name="convert2px">
						<xsl:with-param name="value" select="@svg:height" />
					</xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="alt">
				<xsl:choose>
					<xsl:when test="svg:desc">
						<xsl:value-of  select="svg:desc" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:message>
	Accessibility Warning:
		 No alternate text ('svg:desc' element) set for
		 image '<xsl:value-of  select="@xlink:href" />'!</xsl:message>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<xsl:attribute name="src">
				<xsl:call-template name="create-href">
					<xsl:with-param name="href" select="@xlink:href" />
				</xsl:call-template>
			</xsl:attribute>

			<!-- style interpretation only, as no subelements are allowed for img in XHTML -->
			<xsl:apply-templates select="@draw:style-name">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>

	<!-- ************ -->
	<!-- *** list *** -->
	<!-- ************ -->
    <!--
		Some things have to be considered to create XHTML lists with a similar view as in the Office:

		A)
		One significant difference between XHTML and Office List elements is that an list element without text but only child lists
		would not shown a list symbol in the Office, but do in XHTML.

        Workaround:
			- Contiguous 'text:ordered-list', 'text:unordered-list' elements will be taken as a single list
			- A XHTML list element ('ol, 'ul' or 'li') will only be created if the OpenOffice.org XML elements 'text:ordered-list', 'text:unordered-list' or
			'text:list-item' elements have a child different to them.

		B)
		In OASIS Open Document XML (OOo2.0) only one element exists for list items, during a mapping to OOo XML
        it is always mapped to a 'text:ordered-list' list element, even with it is a unordered list.

        Workaround:
			- XHTML element 'ol', 'ul' will not be choosen upon 'text:ordered-list' or 'text:unordered-list' element,
			but on the list style type.

		C)
		An Office Lists may be spread over the whole document. Linked by their style and text:continue-numbering='true'.
		Futhermore it can have any provided character as List label.
		Workaround:
			- comlete list emulation without XHTML list elements (currently neglected)
    -->
	<xsl:key name="listStyles" match="/office:document/office:styles/text:list-style | /office:document/office:automatic-styles/text:list-style" use="@style:name"/>

    <xsl:template match="text:unordered-list | text:ordered-list">
		<xsl:param name="globalData" />
		<xsl:param name="listLevel" select="1" />
		<xsl:param name="listStyleName" select="@text:style-name" />
		<!-- The left margin is in XHTML messured till the beginning of the text in the Office to the beginning of the list symbol (label)
			a left-margin of 0 hides all list symbol. This assumption of an indent make them visible
			Note: 	instead of 0.5, which is the width of list symbol in 'cm', the constant &list-label-width; should be used,
					but problems occure with Xalan 2.4.1 used in JRE 1.4 -->
		<xsl:param name="listIndentTotalBefore" select="-0.5" />

	    <!-- get the list style, with the same 'text:style-name' and same 'text:level' -->
	    <xsl:variable name="listLevelStyle" select="key('listStyles', $listStyleName)/*[@text:level = number($listLevel)]" />
	    <xsl:variable name="listType">
		    <xsl:choose>
			    <!-- ordered list -->
			    <xsl:when test="name($listLevelStyle) = 'text:list-level-style-number'">
					<xsl:text>ol</xsl:text>
				</xsl:when>
			    <!-- unordered list -->
			    <xsl:otherwise>
					<xsl:text>ul</xsl:text>
				</xsl:otherwise>
		    </xsl:choose>
	    </xsl:variable>
		<xsl:variable name="isEmptyList" select="not(*[name() = 'text:list-item'
													or name() = 'text:list-header']/*[
														not(name() = 'text:list-item') and
														not(name() = 'text:list-header') and
														not(name() = 'text:ordered-list') and
														not(name() = 'text:unordered-list')])" />
		<xsl:variable name="listMargin">
			<xsl:variable name="minLabelWidth">
				<xsl:choose>
					<xsl:when test="$listLevelStyle/style:properties/@text:min-label-width">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="$listLevelStyle/style:properties/@text:min-label-width" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="minLabelDistance">
				<xsl:choose>
					<xsl:when test="$listLevelStyle/style:properties/@text:min-label-distance">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="$listLevelStyle/style:properties/@text:min-label-distance" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$minLabelDistance &gt; $minLabelWidth">
					<xsl:value-of select="$minLabelDistance"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$minLabelWidth"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="listIndent">
			<xsl:choose>
				<xsl:when test="$listLevelStyle/style:properties/@text:space-before">
					<xsl:call-template name="convert2cm">
						<xsl:with-param name="value" select="$listLevelStyle/style:properties/@text:space-before" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	    <xsl:element name="{$listType}">
		    <xsl:call-template name="create-list-style-attribute">
		 		<!-- the list is empty, if it just contains further lists. No element exist, than one of the three list elements -->
				<xsl:with-param name="isEmptyList" select="$isEmptyList" />
				<xsl:with-param name="listLevelStyle" select="$listLevelStyle" />
				<xsl:with-param name="listIndent" select="$listIndent - $listIndentTotalBefore" />
				<xsl:with-param name="listIndentTotalBefore" select="$listIndentTotalBefore" />
		    </xsl:call-template>
		    <xsl:apply-templates>
				<xsl:with-param name="globalData" select="$globalData" />
				<xsl:with-param name="isEmptyList" select="$isEmptyList" />
				<xsl:with-param name="listIndent" select="$listIndent - $listIndentTotalBefore" />
				<xsl:with-param name="listIndentTotalBefore" select="$listIndentTotalBefore" />
				<xsl:with-param name="listLevel" select="$listLevel" />
				<xsl:with-param name="listLevelStyle" select="$listLevelStyle" />
				<xsl:with-param name="listMargin" select="$listMargin" />
				<xsl:with-param name="listStyleName" select="$listStyleName" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>

	<xsl:template name="create-list-style-attribute">
		<xsl:param name="listLevelStyle" />
		<xsl:param name="isEmptyList" />
		<xsl:param name="listIndent" />

		<xsl:if test="$isEmptyList or $listIndent or $listLevelStyle/@style:num-format">
			<xsl:attribute name="style">
				<!-- rounding the indent to 4 digits -->
				<xsl:if test="$listIndent">margin-left:<xsl:value-of select="round($listIndent * 4) div 4" />cm;</xsl:if>
				<xsl:choose>
					<xsl:when test="$listLevelStyle/@style:num-format or $isEmptyList">
						<xsl:text>list-style-type:</xsl:text>
						<xsl:choose>
						<xsl:when test="$isEmptyList">none</xsl:when>
						<xsl:when test="$listLevelStyle/@style:num-format = '1'">
							<xsl:text>decimal</xsl:text>
						</xsl:when>
						<xsl:when test="$listLevelStyle/@style:num-format = 'I'">
							<xsl:text>upper-roman</xsl:text>
						</xsl:when>
						<xsl:when test="$listLevelStyle/@style:num-format = 'i'">
							<xsl:text>lower-roman</xsl:text>
						</xsl:when>
						<xsl:when test="$listLevelStyle/@style:num-format = 'A'">
							<xsl:text>upper-alpha</xsl:text>
						</xsl:when>
						<xsl:when test="$listLevelStyle/@style:num-format = 'a'">
							<xsl:text>lower-alpha</xsl:text>
						</xsl:when>
						</xsl:choose>
						<xsl:text>; </xsl:text>
					</xsl:when>
				</xsl:choose>
			</xsl:attribute>
		</xsl:if>
   </xsl:template>


	<!-- ****************** -->
	<!-- *** list item  *** -->
	<!-- ****************** -->
<!--
	Left margin of the complete list:
	The space between left page and the list symbol (left-margin) is in the Office implemented by
	the sum of three values:
		1) 'text:space-before', which is part of the 'text:list-style' element.
		2) 'margin:left' from the style of the first child (e.g. paragraph).
		3) 'fo:text-indent' the indent of the first line of some child (e.g. paragraph) (currently neglected)


	Different left-margin behaviors between Office and XHTML:

	a) margin in XHTML is messured till the beginning of the text in the Office
		till the label.
		As workaround the assumed list label width is added/subtracted.

	b) margin in XHTML of li, ol, ul elements is cumulative, in the Office absolute
		As workaround the earlier level value is substracted from the new given.

	c) In the Office the 'margin-left' of the first list child element (e.g. paragraph) is added
		as space BEFORE the list label.	In XHTML it would only result in an indent of
		the first paragraph after the list label.
		As workaround the list-item receives a margin-left from the first child with style

	Possible list children:
	<!ELEMENT text:list-item (text:p|text:h|text:ordered-list|text:unordered-list)+>

	In the Office the indent after the list label before the text depends on two attributes:
		- 'text:min-label-width': the distance between list label and all text of the list item.
		- 'text:min-label-distance': the distance between list label and text of the first line.
		As workaround the first child gets the higher margin of both as margin-left style.
-->
	<xsl:template match="text:list-item | text:list-header">
		<xsl:param name="isEmptyList" />
		<xsl:param name="globalData" />
		<xsl:param name="listIndent" />
		<xsl:param name="listIndentTotalBefore" />
		<xsl:param name="listLevel" />
		<xsl:param name="listLevelStyle" />
		<xsl:param name="listMargin" />
		<xsl:param name="listStyleName" />


		<xsl:variable name="firstElementStyleName" select="descendant::*[@text:style-name][1]/@text:style-name" />
		<xsl:variable name="firstElementStyles" select="$globalData/all-styles/style[@style:name = $firstElementStyleName]/final-properties" />
		<xsl:variable name="firstElementMargin">
			<xsl:choose>
				<xsl:when test="contains($firstElementStyles, 'margin-left:')">
					<xsl:call-template name="convert2cm">
						<xsl:with-param name="value" select="normalize-space(substring-before(substring-after($firstElementStyles, 'margin-left:'), ';'))" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:element name="li">
			<!-- The left-margin of the first list child is being added to the whole list left-margin -->
			<xsl:call-template name="create-list-style">
				<xsl:with-param name="globalData" select="$globalData" />
				<xsl:with-param name="listLevelStyle" select="$listLevelStyle" />
				<xsl:with-param name="marginInCentimeter" select="$firstElementMargin" />
				<xsl:with-param name="styleName" select="$firstElementStyleName" />
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$isEmptyList">
					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
						<xsl:with-param name="listIndentTotalBefore" select="$listIndent + $firstElementMargin + $listIndentTotalBefore" />
						<xsl:with-param name="listLevel" select="$listLevel + 1" />
						<xsl:with-param name="listStyleName" select="$listStyleName" />
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates mode="first-element-margin-adaption" select="*">
						<xsl:with-param name="globalData" select="$globalData" />
						<xsl:with-param name="listIndentTotalBefore" select="$listIndent + $firstElementMargin + $listIndentTotalBefore" />
						<xsl:with-param name="marginInCentimeter" select="$listMargin" />
						<xsl:with-param name="listLevel" select="$listLevel + 1" />
						<xsl:with-param name="listStyleName" select="$listStyleName" />
					</xsl:apply-templates><!--
					<xsl:apply-templates select="*[position() &gt; 1]">
						<xsl:with-param name="globalData" select="$globalData" />
						<xsl:with-param name="listIndentTotalBefore" select="$listIndent + $firstElementMargin + $listIndentTotalBefore" />
						<xsl:with-param name="listLevel" select="$listLevel + 1" />
						<xsl:with-param name="listStyleName" select="$listStyleName" />
					</xsl:apply-templates> -->
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>

	<xsl:template match="text:p" mode="first-element-margin-adaption">
		<xsl:param name="globalData" />
		<xsl:param name="marginInCentimeter" />

		<xsl:element name="p">
			<!-- empty paragraph tags does not provoke an carridge return,
				therefore an non breakable space (&nbsp) have been inserted.-->
			<xsl:choose>
				<xsl:when test="*">
					<xsl:call-template name="create-list-style">
						<xsl:with-param name="globalData" select="$globalData" />
						<!-- Note: 	instead of 0.5, which is the width of list symbol in 'cm', the constant &list-label-width; should be used,
									but problems occure with Xalan 2.4.1 used in JRE 1.4 -->
						<xsl:with-param name="marginInCentimeter" select="$marginInCentimeter - 0.5" />
						<xsl:with-param name="styleName"  select="@text:style-name" />
					</xsl:call-template>
					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="create-list-style">
						<xsl:with-param name="globalData" select="$globalData" />
						<!-- Note: 	instead of 0.5, which is the width of list symbol in 'cm', the constant &list-label-width; should be used,
									but problems occure with Xalan 2.4.1 used in JRE 1.4 -->
						<xsl:with-param name="marginInCentimeter" select="$marginInCentimeter - 0.5" />
						<xsl:with-param name="styleName"  select="@text:style-name" />
					</xsl:call-template>
					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
					<xsl:text>&#160;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>


	<!-- Neglecting the left margin behavior for headings for now -->
	<xsl:template match="text:h" mode="first-element-margin-adaption">
		<xsl:param name="globalData" />

		<xsl:apply-templates select="self::*">
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>
	</xsl:template>


	<xsl:template match="*" mode="first-element-margin-adaption">
		<xsl:param name="globalData" />
		<xsl:param name="listIndentTotalBefore" />
		<xsl:param name="listLevel" />
		<xsl:param name="listStyleName" />

		<xsl:apply-templates select="self::*">
			<xsl:with-param name="globalData" select="$globalData" />
			<xsl:with-param name="listIndentTotalBefore" select="$listIndentTotalBefore" />
			<xsl:with-param name="listLevel" select="$listLevel" />
			<xsl:with-param name="listStyleName" select="$listStyleName" />
		</xsl:apply-templates>
	</xsl:template>


	<xsl:template match="text()" mode="first-element-margin-adaption">
		<xsl:value-of select="." />
	</xsl:template>


	<xsl:template name="create-list-style">
		<xsl:param name="globalData" />
		<xsl:param name="marginInCentimeter" />
		<xsl:param name="styleName" />

		<xsl:if test="$styleName">
			<xsl:attribute name="class">
				<xsl:value-of select="translate($styleName, '. %()/\+', '')" />
			</xsl:attribute>
		</xsl:if>
		<xsl:attribute name="style">
			<xsl:text>margin-left:</xsl:text>
			<xsl:choose>
				<xsl:when test="$marginInCentimeter">
					<xsl:value-of select="round($marginInCentimeter * 4) div 4"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>0</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>cm;</xsl:text>
		</xsl:attribute>
	</xsl:template>



	<!-- ********************************************** -->
	<!-- *** Text Section (contains: draw:text-box) *** -->
	<!-- ********************************************** -->

	<xsl:template match="text:section">
		<xsl:param name="globalData" />

		<xsl:if test="not(contains(@text:display, 'none'))">
			<xsl:choose>
				<!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
				<xsl:when test="$outputType = 'CSS_HEADER'">
					<xsl:element name="div">
						<xsl:call-template name="apply-styles-and-content">
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:call-template>
					</xsl:element>
				</xsl:when>
				<!--+++++ HTML 4.0 INLINED WAY  +++++-->
				<xsl:when test="$outputType = 'CSS_INLINED'">
					<xsl:element name="div">
						<xsl:call-template name="apply-styles-and-content">
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:call-template>
					</xsl:element>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>


	<!-- Hidden text dependend on Office variables:
		 The text is not shown, if condition is 'true'.
		 Implemented solely for conditons as '<VARIABLE>==0' or '<VARIABLE>==1'
	-->
	<xsl:key match="text:variable-set" name="varSet" use="@text:name" />
	<xsl:template match="text:hidden-text">
		<xsl:param name="globalData" />

		<xsl:variable name="varName" select="substring-before(@text:condition, '==')" />
		<xsl:variable name="varValue" select="substring-after(@text:condition, '==')" />
		<xsl:choose>
			<xsl:when test="key('varSet', $varName)/@text:value != $varValue">
				<xsl:value-of select="@text:string-value" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:comment><xsl:value-of select="$varName" />
				<xsl:value-of select="@text:string-value" />
				<xsl:value-of select="$varName" /></xsl:comment>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- date & time field -->
	<xsl:template match="text:date | text:time">
		<xsl:param name="globalData" />

		<xsl:call-template name="apply-styles-and-content">
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:call-template>
	</xsl:template>


	<xsl:template match="@text:style-name | @draw:style-name | @draw:text-style-name | @table:style-name"><!-- | @presentation:style-name-->
		<xsl:param name="globalData" />

		<xsl:choose>
			<!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
			<xsl:when test="$outputType = 'CSS_HEADER'">
				<xsl:attribute name="class">
					<xsl:value-of  select="translate(., '. %()/\+', '')" />
				</xsl:attribute>
			</xsl:when>

			<!--+++++ HTML 4.0 INLINED WAY  +++++-->
			<xsl:when test="$outputType = 'CSS_INLINED'">
				<xsl:attribute name="style">
					<xsl:value-of  select="$globalData/all-styles/style[@style:name = current()]/final-properties" />
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
