/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Node;
import writer2latex.office.OfficeStyle;
import writer2latex.util.Misc;

public class OfficeStyleFamily {
    private Hashtable styles = new Hashtable();
    private Class styleClass;
    private OfficeStyle defaultStyle = null;

    public OfficeStyleFamily(Class clazz) {
        this.styleClass = clazz;
    }

    public void setDefaultStyle(OfficeStyle officeStyle) {
        this.defaultStyle = officeStyle;
    }

    public OfficeStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public OfficeStyle getStyle(String string) {
        if (string == null) {
            return null;
        }
        return (OfficeStyle)this.styles.get(string);
    }

    public Enumeration getStylesEnumeration() {
        return this.styles.elements();
    }

    public void loadStyleFromDOM(Node node, boolean bl) {
        String string = Misc.getAttribute(node, "style:name");
        if (string != null) {
            try {
                OfficeStyle officeStyle = (OfficeStyle)this.styleClass.newInstance();
                officeStyle.sName = string;
                officeStyle.family = this;
                officeStyle.bAutomatic = bl;
                officeStyle.loadStyleFromDOM(node);
                this.styles.put(string, officeStyle);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

