/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleMap;
import writer2latex.latex.style.TableFormatter;
import writer2latex.office.TableGridModel;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class BlockConverter
extends ConverterHelper {
    public BlockConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
    }

    public void traverseBlockText(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        Object object;
        StyleMap styleMap = this.config.getParBlockStyleMap();
        String string = null;
        if (element.hasChildNodes()) {
            object = element.getChildNodes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string3 = element2.getTagName();
                this.palette.getInfo().addDebugInfo(element2, laTeXDocumentPortion);
                if (string3.equals("text:p")) {
                    String string4;
                    string2 = element2.getAttribute("text:style-name");
                    if (string != null && !styleMap.isNext(string, string2)) {
                        string4 = styleMap.getAfter(string);
                        if (string4.length() > 0) {
                            laTeXDocumentPortion.append(string4).nl();
                        }
                        string = null;
                    }
                    if (string == null && styleMap.contains(string2) && (string4 = styleMap.getBefore(string = string2)).length() > 0) {
                        laTeXDocumentPortion.append(string4).nl();
                    }
                } else if (string != null) {
                    string2 = styleMap.getAfter(string);
                    if (string2.length() > 0) {
                        laTeXDocumentPortion.append(string2).nl();
                    }
                    string = null;
                }
                if (string3.equals("text:p")) {
                    this.handleParagraph(element2, laTeXDocumentPortion, context, i == n - 1);
                    continue;
                }
                if (string3.equals("text:h")) {
                    this.handleHeading(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:unordered-list")) {
                    this.handleList(element2, laTeXDocumentPortion, context, false);
                    continue;
                }
                if (string3.equals("text:ordered-list")) {
                    this.handleList(element2, laTeXDocumentPortion, context, true);
                    continue;
                }
                if (string3.equals("table:table")) {
                    this.handleTable(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("table:sub-table")) {
                    this.handleTable(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:section")) {
                    this.handleSection(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.startsWith("draw:")) {
                    this.palette.getDrawCv().handleDrawElement(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:table-of-content")) {
                    this.palette.getIndexCv().handleTOC(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:illustration-index")) {
                    this.palette.getIndexCv().handleLOF(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:table-index")) {
                    this.palette.getIndexCv().handleLOT(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:object-index")) {
                    this.palette.getIndexCv().handleObjectIndex(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:user-index")) {
                    this.palette.getIndexCv().handleUserIndex(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:alphabetical-index")) {
                    this.palette.getIndexCv().handleAlphabeticalIndex(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (string3.equals("text:bibliography")) {
                    this.palette.getIndexCv().handleBibliography(element2, laTeXDocumentPortion, context);
                    continue;
                }
                if (!string3.equals("text:sequence_decls")) continue;
            }
        }
        if (string != null) {
            object = styleMap.getAfter(string);
            if (((String)object).length() > 0) {
                laTeXDocumentPortion.append((String)object).nl();
            }
            string = null;
        }
    }

    public void handleSection(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        this.palette.getFieldCv().addTarget(element, "|region", laTeXDocumentPortion);
        String string = element.getAttribute("text:style-name");
        BeforeAfter beforeAfter = new BeforeAfter();
        Context context2 = (Context)context.clone();
        this.palette.getSectionSc().applySectionStyle(string, beforeAfter, context2);
        if (beforeAfter.getBefore().length() > 0) {
            laTeXDocumentPortion.append(beforeAfter.getBefore()).nl();
        }
        this.traverseBlockText(element, laTeXDocumentPortion, context2);
        if (beforeAfter.getAfter().length() > 0) {
            laTeXDocumentPortion.append(beforeAfter.getAfter()).nl();
        }
    }

    public void handleTable(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        TableGridModel tableGridModel = new TableGridModel(element);
        Context context2 = (Context)context.clone();
        context2.setInTable(true);
        boolean bl = this.config.formatting() >= 3;
        TableFormatter tableFormatter = this.palette.getTableSc().getTableFormatter(tableGridModel, !context2.isInMulticols(), bl);
        if (!tableFormatter.isSubtable()) {
            this.palette.getFieldCv().addTarget(element, "|table", laTeXDocumentPortion);
        }
        BeforeAfter beforeAfter = new BeforeAfter();
        tableFormatter.applyTableStyle(beforeAfter);
        laTeXDocumentPortion.append(beforeAfter.getBefore()).nl();
        if (bl || !tableFormatter.isLongtable()) {
            context2.setNoFootnotes(true);
        }
        int n = tableGridModel.getRowCount();
        int n2 = tableGridModel.getColCount();
        boolean bl2 = false;
        laTeXDocumentPortion.append(tableFormatter.getInterrowMaterial(0)).nl();
        for (int i = 0; i < n; ++i) {
            int n3;
            if (tableFormatter.isLongtable()) {
                if (i == 0 && tableGridModel.getRow(i).isHeader()) {
                    bl2 = true;
                    if (!bl) {
                        context2.setNoFootnotes(true);
                    }
                } else if (bl2 && !tableGridModel.getRow(i).isHeader()) {
                    bl2 = false;
                    if (!bl) {
                        context2.setNoFootnotes(false);
                    }
                    this.palette.getNoteCv().flushFootnotes(laTeXDocumentPortion, context);
                    laTeXDocumentPortion.append("\\endhead").nl();
                }
            }
            for (int j = 0; j < n2; j += n3) {
                Element element2 = (Element)tableGridModel.getCell(i, j);
                if ("table:table-cell".equals(element2.getNodeName())) {
                    BeforeAfter beforeAfter2 = new BeforeAfter();
                    tableFormatter.applyCellStyle(i, j, beforeAfter2);
                    laTeXDocumentPortion.append(beforeAfter2.getBefore());
                    this.traverseBlockText(element2, laTeXDocumentPortion, context2);
                    laTeXDocumentPortion.append(beforeAfter2.getAfter());
                }
                if (j + (n3 = Misc.getPosInteger(element2.getAttribute("table:number-columns-spanned"), 1)) >= n2) continue;
                laTeXDocumentPortion.append("&").nl();
            }
            laTeXDocumentPortion.append("\\\\").append(tableFormatter.getInterrowMaterial(i + 1)).nl();
        }
        laTeXDocumentPortion.append(beforeAfter.getAfter()).nl();
        if (bl || !tableFormatter.isLongtable()) {
            this.palette.getNoteCv().flushFootnotes(laTeXDocumentPortion, context);
        }
    }

    public void handleList(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context, boolean bl) {
        Context context2 = (Context)context.clone();
        context2.incListLevel();
        if (context2.isIgnoreLists() || this.listContainsHeadings(element)) {
            context2.setIgnoreLists(true);
            this.traverseList(element, laTeXDocumentPortion, context2);
            return;
        }
        if (context2.getListStyleName() == null) {
            context2.setListStyleName(element.getAttribute("text:style-name"));
        }
        BeforeAfter beforeAfter = new BeforeAfter();
        this.palette.getListSc().applyListStyle(context2.getListStyleName(), context2.getListLevel(), bl, "true".equals(element.getAttribute("text:continue-numbering")), beforeAfter);
        if (beforeAfter.getBefore().length() > 0) {
            laTeXDocumentPortion.append(beforeAfter.getBefore()).nl();
        }
        this.traverseList(element, laTeXDocumentPortion, context2);
        if (beforeAfter.getAfter().length() > 0) {
            laTeXDocumentPortion.append(beforeAfter.getAfter()).nl();
        }
    }

    private void traverseList(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string = node.getNodeName();
                this.palette.getInfo().addDebugInfo((Element)node, laTeXDocumentPortion);
                if (string.equals("text:list-item")) {
                    this.handleListItem((Element)node, laTeXDocumentPortion, context);
                }
                if (!string.equals("text:list-header")) continue;
                this.handleListItem((Element)node, laTeXDocumentPortion, context);
            }
        }
    }

    private void handleListItem(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (context.isIgnoreLists()) {
            this.traverseBlockText(element, laTeXDocumentPortion, context);
            return;
        }
        BeforeAfter beforeAfter = new BeforeAfter();
        this.palette.getListSc().applyListItemStyle(context.getListStyleName(), context.getListLevel(), element.getNodeName().equals("text:list-header"), "true".equals(element.getAttribute("text:restart-numbering")), Misc.getPosInteger(element.getAttribute("text:start-value"), 1) - 1, beforeAfter);
        if (beforeAfter.getBefore().length() > 0) {
            laTeXDocumentPortion.append(beforeAfter.getBefore());
            if (this.config.formatting() >= 3) {
                laTeXDocumentPortion.nl();
            }
        }
        this.traverseBlockText(element, laTeXDocumentPortion, context);
        if (beforeAfter.getAfter().length() > 0) {
            laTeXDocumentPortion.append(beforeAfter.getAfter()).nl();
        }
    }

    private boolean listContainsHeadings(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:list-item") && this.listItemContainsHeadings(node2)) {
                    return true;
                }
                if (!string.equals("text:list-header") || !this.listItemContainsHeadings(node2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean listItemContainsHeadings(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:h")) {
                    return true;
                }
                if (string.equals("text:ordered-list") && this.listContainsHeadings(node2)) {
                    return true;
                }
                if (!string.equals("text:unordered-list") || !this.listContainsHeadings(node2)) continue;
                return true;
            }
        }
        return false;
    }

    public void handleHeading(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        int n = Misc.getPosInteger(element.getAttribute("text:level"), 1);
        HeadingMap headingMap = this.config.getHeadingMap();
        String string = element.getAttribute("text:style-name");
        if (n <= headingMap.getMaxLevel()) {
            this.palette.getI18n().pushSpecialTable(this.palette.getParSc().getFontName(string));
            BeforeAfter beforeAfter = new BeforeAfter();
            BeforeAfter beforeAfter2 = new BeforeAfter();
            Context context2 = (Context)context.clone();
            this.palette.getParSc().applyHardHeadingStyle(n, string, beforeAfter, beforeAfter2, context2);
            laTeXDocumentPortion.append(beforeAfter.getBefore());
            laTeXDocumentPortion.append("\\" + headingMap.getName(n));
            if (beforeAfter2.getBefore().length() > 0 || this.containsElements(element)) {
                laTeXDocumentPortion.append("[");
                this.palette.getInlineCv().traversePlainInlineText(element, laTeXDocumentPortion, context2);
                laTeXDocumentPortion.append("]");
            }
            laTeXDocumentPortion.append("{").append(beforeAfter2.getBefore());
            this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context2, false);
            laTeXDocumentPortion.append(beforeAfter2.getAfter()).append("}").nl();
            laTeXDocumentPortion.append(beforeAfter.getAfter());
            this.palette.getDrawCv().flushFloatingFrames(laTeXDocumentPortion, context2);
            this.palette.getI18n().popSpecialTable();
        } else {
            this.handleParagraph(element, laTeXDocumentPortion, context, false);
        }
    }

    private boolean containsElements(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().startsWith("text:reference-mark")) continue;
            return true;
        }
        return false;
    }

    public void handleParagraph(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context, boolean bl) {
        if (!element.hasChildNodes()) {
            if (!this.config.ignoreEmptyParagraphs()) {
                laTeXDocumentPortion.nl().append("\\bigskip").nl();
                if (!bl) {
                    laTeXDocumentPortion.nl();
                }
            }
            return;
        }
        String string = element.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getParSc().getFontName(string));
        BeforeAfter beforeAfter = new BeforeAfter();
        Context context2 = (Context)context.clone();
        this.palette.getParSc().applyParStyle(string, beforeAfter, context2);
        laTeXDocumentPortion.append(beforeAfter.getBefore());
        if (context2.isVerbatim()) {
            this.palette.getInlineCv().traverseVerbatimInlineText(element, laTeXDocumentPortion, context2, false);
        } else {
            this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context2, false);
        }
        laTeXDocumentPortion.append(beforeAfter.getAfter());
        if (!bl && !context2.isVerbatim()) {
            laTeXDocumentPortion.nl();
        }
        this.palette.getDrawCv().flushFloatingFrames(laTeXDocumentPortion, context2);
        this.palette.getI18n().popSpecialTable();
    }
}

