/*************************************************************************
 *
 *  Authors:
 *  Pasi Ryhänen, 2002/05/23
 *  Harri Pitkänen (hatapitk@cc.jyu.fi), 2005
 *
 *  The Contents of this file are made available subject to the terms of
 *  GNU Lesser General Public License Version 2.1
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA  02110-1301, USA
 *
 ************************************************************************/

#ifndef _COMMONFI_HXX_
#define _COMMONFI_HXX_

#ifndef _TM_OPENOFFICE_HXX
#include "tm_openoffice.hxx"
#endif

namespace soikko {

typedef struct {
  bool init_done;
  void *handle;
  version_func_type   * version_func;
  init_func_type      * init_func;
  open_func_type      * open_func;
  openhyph_func_type  * openhyph_func;
  terminate_func_type * terminate_func;
  hyphenate_func_type * hyphenate_func;
  check_func_type     * check_func;
  suggest_func_type   * suggest_func;
  encoding_func_type  * encoding_func;
  option_func_type    * option_func;
} tm_dl_t;

int load_dl  (const char *dl_name, tm_dl_t *dl);
int close_dl (tm_dl_t *dl);

}

#endif

