#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif 

/* Spool Usenet news articles to fidonet. Currently there is no news-system
   in fido, it's done by software after and before mail-slots. Echomail
   is most popular one, and this program does about the same thing:
   it sends news-articles as fido-mail containing suitable information
   for echomail. Echomail relies on normal fido-mail, we send news thru
   rfmail, because this mechanism requires nothing different from normal
   mail.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "fnews.h"
#include "nodelist.h"
#include "configs.h"
     
extern void exit();
extern void perror();

ngcmp(ng1, ng2)
     newsgroup_t *ng1, *ng2;
{
  return strcmp(ng1->ng, ng2->ng);
}

/* Get header field. Rewind header file and scan forward until we find
   desired field. Not effective, but... Return NULL if field not found. */

char *
get_field(field, hdr)
     char *field;
     FILE *hdr;
{
  static char buffer[BUFLEN];
  int conditional = FALSE;
  char *p;

  if (*field == '?')
    {
      conditional = TRUE;
      for (p = field; *p = *(p + 1); p++);
    }
  
  (void) rewind(hdr);
  while (fgets(buffer, BUFLEN, hdr))
    if (!strncmp(field, buffer, strlen(field))) 
      {
	if (conditional)
	  {
	    /* Note: <= is ok, because there is one blank after header which
	       wouldn't be included in Fidonet message header */
	    if (!strncmp(field, "Subject:", 8))
	      if (strlen(buffer + 8) <= 72) return NULL;
	    if (!strncmp(field, "From:", 5))
	      if (strlen(buffer + 5) <= 36) return NULL;
	    if (!strncmp(field, "Reply-To:", 9))
	      if (strlen(buffer + 9) <= 36) return NULL;
	    if (!strncmp(field, "To:", 3))
	      if (strlen(buffer + 3) <= 36) return NULL;
	  }
	    
        buffer[strlen(buffer) - 1] = 0;
        return buffer + strlen(field);
      }

  return (char *) NULL;
}

/* Open stream which is associated with fido-mailers starndard input.
   We could use also popen(3S), but it invokes also sh(1) which slows
   down opening and gets more memory. This routine exists if something
   goes wrong, because this is quite essential part of program and
   we can not continue without mailer. */

FILE *
open_mailer(to)
     char *to;
{
  FILE *fp;
  int fd[2];
  char mailer[128];

  debug(20, "Target %s", to);
  
  (void) sprintf(mailer, "%s/rfmail", config.libdir);
  
  /* create pipe */
  if (pipe(fd) == -1)
    {
      perror("rfnews: pipe");
      exit(EX_OSERR);
    }
  
  switch (fork())
    {
    case -1:
      perror("rfnews: fork failed");
      exit(EX_OSERR);
    case 0:
      (void) close(0);
      /* duplicate pipe and close now unused fd's */
      if (dup(fd[0]) == 0)
        {
          (void) close(fd[0]);
          (void) close(fd[1]);
          (void) execlp(mailer, "rfmail", "-p", to, (char *) NULL);
          perror(mailer);
        }
      else
        perror("rfnews: dup");
      exit(EX_OK);
    default:
      (void) close(fd[0]);
      /* open the other end of pipe as buffered */
      if ((fp = fdopen(fd[1], "w")) == NULL)
        {
          perror("rfnews: fdopen");
          exit(EX_OSERR);
        }
    }
  return fp;
}

/* Save news header for future processing and return file pointer to it. */

FILE *
save_hdr()
{
  char buffer[BUFLEN];
  FILE *hdr = tmpfile();
  
  while (fgets(buffer, BUFLEN, stdin) && *buffer != '\n')
    (void) fputs(buffer, hdr);
  return hdr;
}

/* Try to get area for some of the newsgroups in newsgroup list. Method
   is not very sophisticated, but it should work. */

char *
get_area(groups)
     char *groups;
{
  char buffer[BUFLEN];
  char *gr;
  newsgroup_t ng, *ngp;
  
  debug(2, "Checking grouplist '%s'", groups);
  
  (void) strcpy(buffer, groups);
  /* get group by group from newsgroup-list */
  for (gr = strtok(buffer, " ,"); gr; gr = strtok((char *) NULL, " ,"))
    {
      (void) strcpy(ng.ng, gr);
      if (ngp = (newsgroup_t *) bsearch( (char *) &ng, (char *) config.ng,
					 (unsigned) config.newsgroups,
					 sizeof(newsgroup_t), ngcmp))
	{
	  debug(3, "Match, return area '%s'", ngp->echo);
	  return ngp->echo;
	}
    }

  debug(3, "No match");

  log("No area found for any group in '%s'", groups);
  return (char *) NULL;
}

/* Do actual processing of article. This will copy article, get newsgoroups
   and save them and then send all rest of article. */

/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  FILE *rfmail, *hdr;
  char buffer[BUFLEN];
  int c, lastnet, count;
  char *cp, *errorstr;

  get_configuration();

  /* Sort newsgroups according to newsgroup name for easier searching */
  
  qsort( (char *) config.ng, (unsigned) config.newsgroups,
	sizeof(newsgroup_t), ngcmp);
  
  /* get options */
  while ((c = getopt(argc, argv, "v")) != EOF)
    switch (c)
      {
      case 'v':
        verbose++;
        break;
      default:
        (void) fprintf(stderr, "Usage: %s [-v]\n", *argv);
        exit(EX_USAGE);
      }

  /* try to update nodelist-index */
  if (errorstr = update_index())
    {
      if (*errorstr == '$')
        log("$Cannot update nodelist-index: %s", errorstr + 1);
      else
        log("Cannot update nodelist-index: %s", errorstr);
      exit(EX_OSERR);
    }
  
  /* open rfmail to send news */
  rfmail = open_mailer(sprintfs("All@%s", internode(config.echofeed)));
  
  /* save news header */
  hdr = save_hdr();
  
  /* try to get area to which this article is going */
  if (cp = get_field("Newsgroups: ", hdr))
    if (cp = get_area(cp))
      {
	(void) fprintf(rfmail, "AREA:%s\n", cp);
	debug(2, "send area %s", cp);
      }
    else
      {
        log("Unable to get area");
#ifdef JUNK_AREA
        (void) fprintf(rfmail, "AREA:\n", JUNK_AREA);
        log("Sending article to area %s", JUNK_AREA);
#else
        exit(EX_DATAERR);
#endif
      }
  else
    {
      log("Missing Newsgroups: line in article");
      exit(EX_DATAERR);
    }
  
  /* now send news header */
  for (count = 0; count < config.headers; count++)
    if (cp = get_field(config.header[count], hdr))
      (void) fprintf(rfmail,"%s%s\n", buffer, cp);

  (void) putc('\n', rfmail);
  
  /* send rest of the article */
  while (fgets(buffer, BUFLEN, stdin))
    (void) fputs(buffer, rfmail);
  
  /* send last information */
  (void) fprintf(rfmail, "--- %s\n", PROGRAMNAME);
  (void) fprintf(rfmail, " * Origin: %s (%s)\n", config.origin,
		 ascnode(config.mynode));
  
  lastnet = config.seenby[0].net;
  (void) fprintf(rfmail, "SEEN-BY: %s", netnode(config.seenby[0]));
  for (count = 1; count < config.seenbys; count++) {
    if (config.seenby[count].net != lastnet) {
      (void) fprintf(rfmail, " %s", netnode(config.seenby[count]));
      lastnet = config.seenby[count].net;
    } else {
      (void) fprintf(rfmail, " %d", config.seenby[count].node);
    }
  }
  (void) fprintf(rfmail, " \n");

  (void) fprintf(rfmail, "\001PATH: %d/%d \n",
		 config.mynode.net, config.mynode.node);
  
  /* I think that that was all... */
  (void) fclose(rfmail);
  (void) wait((int *) NULL);
  
  exit(EX_OK);
  /* NOTREACHED */
}
