#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Read mail from standard input and put it into spool-directory.
   Usually this program is executed by our rmail, but it can be
   excuted manually or put as external fidomailer. If our rmail is
   not used (or some other modified rmail), mail from other UUCP
   node can not be sent to fidonet, because (normally) the other
   node sends mail in this site by using rmail.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/types.h>
#include <time.h>
#include <varargs.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "nodelist.h"
#include "configs.h"
     
extern struct passwd *getpwuid();
extern char *mktemp();
extern int getopt();
extern char *optarg;
extern int optind;
extern void exit();
extern char *spoolfile(), *basename();
extern char *regex();
extern time_t time();
extern FILE *popen();
extern int errno;
extern char *sys_errlist[];

/* non-private mail */
bool public = False;

/* News-article */
int newsmode = FALSE;

/* version of rfmail */
char *version = "%I%";

/* Our net/node information */
Node this;

/* Extract address from Reply-To or From field. Possible formats are:
   - Full Name <address>
   - address (Full Name)
   - address */

void
get_address(field, address)
     char *field, *address;
{
  register char *cp, *np;
  
  /* strip possible newline */
  if (cp = strchr(field, '\n'))
    *cp = 0;
  
  if ((cp = strchr(field, '(')) && strchr(cp + 1, ')'))
    {
      /* format is 'address (full name)' */
      for (np = field; np < cp - 1; np++)
        *address++ = *np;
      *address = 0;
    }
  else
    if ((cp = strchr(field, '<')) && (np = strchr(cp + 1, '>')))
      {
        /* format is 'full name <address>' */
        while (cp < np)
          *address++ = *cp++;
        *address = 0;
      }
    else
      /* line contains only address */
      (void) strcpy(address, field);
}

/* Get return address from mail. Extract it from Reply-To: or From: fields. */

void
get_return_address(mail, address)
     FILE *mail;
     char *address;
{
  char buffer[BUFSIZ];
  
  *address = 0;
  
  /* check is there is Reply-To: field */
  (void) rewind(mail);
  while (fgets(buffer, BUFSIZ, mail) && *buffer != '\n')
    if (!strncmp(buffer, "Reply-To: ", 10))
      {
        get_address(buffer + 10, address);
        return;
      }
  
  /* no Reply-To:, check for From: */
  (void) rewind(mail);
  while (fgets(buffer, BUFSIZ, mail) && *buffer != '\n')
    if (!strncmp(buffer, "From: ", 6))
      {
        get_address(buffer + 6, address);
        return;
      }
  
  /* not found, send it to uucp */
  (void) strcpy(address, "uucp");
}

/* Send mail back to sender. If Reply-To: of From:-field is present,
   we'll use address specified in that, otherwise we will not return
   mail (it also should be able to parse From_ fields). First argument
   is file containing this mail, others are for vprintf(3S) to be used
   as transcript. */

/* VARARGS */
void
sendback(va_alist)
     va_dcl
{
  va_list args;
  FILE *mail;
  FILE *mailer;
  char *fmt, buffer[BUFSIZ];
  char to[128];

  va_start(args);
  mail = va_arg(args, FILE *);
  fmt = va_arg(args, char *);
  
  if (config.return_failed_mail) {
    get_return_address(mail, to);
    log("Mail failed, return to %s", to);
  
    /* generate shell command and open it */
    (void) sprintf(buffer, "exec %s %s", config.rmail, to);
    if (mailer = popen(buffer, "w"))
      {
	/* print correct header for mailer */
	(void) fprintf(mailer, "From %d!MAILER-DAEMON %s remote from %d\n",
		       this.node, date("%a %h %d %T 19%y", (long *) 0),
		       this.net);
	(void) fprintf(mailer, "Received: by %s (%s/%s)\n",
		       internode(this), PROGRAMNAME, this.name);
	(void) fprintf(mailer, "\tid AA%05d; %s\n", getpid(),
		       date("%a, %d %h %y %T %o (%z)", (long *) 0));
	(void) fprintf(mailer, "Date: %s\n", date("%a, %d %h %y %T %o",
						  (long *) 0));
	(void) fprintf(mailer, "From: FidoNet Mail <%s@%s>\n",
		       "MAILER-DAEMON", internode(this));
	(void) fprintf(mailer, "Subject: Returned mail: %s\n",
		       "Unable to deliver mail to FidoNet");
	(void) fprintf(mailer, "Message-Id: <%s.AA%05d@%s>\n",
		       date("%y%m%q%H%M", (long *) 0), getpid(),
		       internode(this));
	(void) fprintf(mailer, "To: %s\n", to);
	(void) fprintf(mailer, "\n");
	(void) fprintf(mailer,
		       "  ----- Transcript of session follows -----\n");
	(void) vfprintf(mailer, fmt, args);
	(void) fprintf(mailer, "\n\n");
	(void) fprintf(mailer, "  ----- Unsent message follows -----\n");
	
	/* now copy the message to mailer */
	(void) rewind(mail);
	while (fgets(buffer, BUFSIZ, mail))
	  (void) fputs(buffer, mailer);
	
	/* mail is now sent, close mailer */
	(void) pclose(mailer);
      }
    else
      log("$Unable to invoke mailer for returned mail");
  } else { /* if not return failed mail */
    /* get dummy mail-file pointer */
    mail = va_arg(args, FILE*);
    fmt = va_arg(args, char *);
    
    /* just print error to stderr, sendmail will return mail to sender
       due to non-zero exit code. */
    (void) vfprintf(stderr, fmt, args);
  } /* not RETURN_FAILED_MAIL */
  
  va_end(args);
}

/* Check that net/node exists and mail can be send to there (ie. it
   is not down or in hold). Also be will replace name with sysop's name,
   if mail is for sysop (note that alias will override this sysop-name).
   Mail will be send back to sender, if this checking fails. */

int
valid_netnode(name, node, mail)
     char *name;
     Node node;
     FILE *mail;
{
  Node *entry;
  
  if (entry = node_entry(node))
    switch (entry->type)
      {
      case HOLD:
        /* node is in hold */
        sendback(mail, "Node %s is in hold", ascnode(node));
        return EX_NOHOST;
      case DOWN:
        /* node is down */
        sendback(mail, "Node %s is currently down", ascnode(node));
        return EX_NOHOST;
      default:
        /* everything was fine */
        if (!strcmp(name, "sysop") || !strcmp(name, "Sysop"))
          (void) strcpy(name, entry->sysop);
        return EX_OK;
      }
  
  /* we didn't find node */
  sendback(mail, "Node %s does not exist", ascnode(node));
  return EX_NOHOST;
}

/* Return sender of mail. Figure it out from From: field or from
   our uid if it's not administrative uid (e.g. uucp or nuucp).
   If not there, try $HOME/.fullname, then
   $HOME/.realname, then
   environment string NAME.
   If neither method works, return NULL.
   If $HOME is not defined, skip both .fullname and .realname */

char *
sender(mail, field)
     FILE *mail;
     char *field;
{
  struct passwd *pwd;
  static char name[36];
  char buffer[BUFSIZ];
  register char *cp, *np;
  register int cnt;
  Node dummynode;
  FILE *fp;

  name[35] = 0;
  (void) rewind(mail);
  while (fgets(buffer, BUFSIZ, mail))
    {
      buffer[strlen(buffer) - 1] = 0; /* strip newline */
      if (!strncmp(buffer, field, strlen(field)))
        {
          /* Parse the name out from From: field. there are basically
             two kinds of formats: 'User Name <address>' or
             'address (User Name)'. We'll try to figure it out
             which format sender uses. */
          
          if ((cp = strchr(buffer, '<')) && (np = strchr(cp, '>')))
            {
              /* Format is 'From: Name <address>' */
              for (np = buffer + strlen(field),
		   cnt = 0; np < cp - 1 && cnt < 35;
                   np++, cnt++)
                name[cnt] = *np;
              name[cnt] = 0;
              debug(2, "Got name %s, fmt name <address>", name);
            }
          else
            if ((cp = strchr(buffer, '(')) && (np = strchr(cp, ')')))
              {
                /* Format is 'From: address (Name)' */
                for (cnt = 0, cp++; cp < np && cnt < 35; cp++, cnt++)
                  name[cnt] = *cp;
                name[cnt] = 0;
                debug(2, "Got name %s, fmt address (name)", name);
              }
            else
              {
		debug(5, "Could no find realname in <> or ()");
		/* Try parse it with parse_address */
		if (parse_address(buffer + strlen(field), name, &dummynode))
		  {
		    (void) strncpy(name, buffer + strlen(field), 35);
		    name[35] = 0;
		    debug(2, "No format in %s, name %s", field, name);
		  }
		else
		  {
		    name[35] = 0;
		    debug(2, "Name %s parsed from address", name);
		  }
              }
          return name;
        }
    }

  /* If not searching for sender, don't try to use uid */

  if (strcmp(field, "From: ")) return NULL;

  /* hmm.. no From: field in mail. let's try to figure this problem
     out some other way. If our uid is some user's uid, we'll use
     that uid to show user's name, otherwise we'll return NULL. */
  
  if (getuid() >= config.useruid && (pwd = getpwuid( (int) getuid())))
    {
      /* There are two commonly used gecos-formats: So called USG
         format used by System III and System V machines and BSD
         format used by BSD machines. In USG format name is
         sandwitched between '-' and '(' characters and in BSD
         format name is first this in gecos-field up to first comma
         in it. In many machines there's only name in gecos. */
      
      if ((cp = strchr(pwd->pw_gecos, '-')) && (np = strchr(cp, '(')))
        {
          /* USG format 'stuff-name(stuff)' */
          for (cnt = 0, cp++; cnt < 35 && cp < np; cp++, cnt++)
            name[cnt] = *cp;
          name[cnt] = 0;
          debug(3, "Got name from USG fmt, name %s", name);
        }
      else
        if (cp = strchr(pwd->pw_gecos, ','))
          {
            /* BSD format 'name,stuff...' */
            for (cp = buffer, cnt = 0; cnt < 35 && *cp != ','; cp++, cnt++)
              name[cnt] = *cp;
            name[cnt] = 0;
            debug(3, "Got name from BSD format, name %s", name);
          }
        else
          if (*pwd->pw_gecos)
            {
              /* non-empty gecos, assume that there's only name */
              (void) strncpy(name, pwd->pw_gecos, 35);
              name[35] = 0;
              debug(3, "No fmt in gecos, name %s", name);
            }
          else
            {
              /* Lazy administrator or user who want's to be anonymous
                 (or this is some administrative uid with no explanation
                 which)... We'll use only the username. */
              
              (void) strncpy(name, pwd->pw_name, 35);
              /* never heard over 35 char usernames???? I haven't but... */
              name[35] = 0;
              debug(3, "No gecos, name = %s");
            }
      return name;
    }
  
  *buffer = 0;
  if (cp = getenv("HOME"))
    {
      debug(5, "Try .fullname");
      if (fp = fopen(sprintfs("%s/%s", cp, ".fullname"), "r"))
	{
	  if (!fgets(buffer, BUFSIZ, fp)) *buffer = 0;
	  (void) fclose(fp);
	  (void) strncpy(name, buffer, 35);
	  if (!strempty(name))
	    {
	      (void) strclean(name);
	      debug(2, "Got name %s from .fullname", name);
	      return name;
	    }
	  else
	    debug(1, "Empty name '%s' in .fullname", name);
	}
      debug(5, "Try .realname");
      if (fp = fopen(sprintfs("%s/%s", cp, ".realname"), "r"))
	{
	  if (!fgets(buffer, BUFSIZ, fp)) *buffer = 0;
	  (void) fclose(fp);
	  (void) strncpy(name, buffer, 35);
	  if (!strempty(name))
	    {
	      (void) strclean(name);
	      debug(2, "Got name %s from .realname", name);
	      return name;
	    }
	  else
	    debug(1, "Empty name '%s' in .realname", name);
	}
    }

  if (cp = getenv("NAME"))
    {
      debug(5, "Name defined, use it");
      (void) strncpy(name, buffer, 35);
      if (!strempty(name))
	{
	  (void) strclean(name);
	  debug(2, "Got name %s from environment NAME", name);
	  return name;
	}
    }
  
  /* Found nothing reasonable. we could put there path, but it's quite
     complicated to parse it and it's quite often more than 35 characters
     and partial paths are not very informative. Reader can figure
     it out by himself (or herself) and tell sender to use mailer... */
  
  debug(2, "No name, uid = %d", getuid());

  return (char *) 0;
}

/* Get net/node information from info. If zone, net, or point are missing,
   they will be returned as -1True is returned, if
   everything went fine, otherwise False. */

bool
getnode(info, node)
     char *info;
     Node *node;
{
  /* Extract zone information */
  if (strchr(info, ':'))
    {
      for (node->zone = 0; *info != ':'; info++)
	if (isdigit(*info))
	  node->zone = node->zone * 10 + *info - '0';
	else
	  {
	    debug(1, "Invalid character in zone '%c' %02x", *info, *info);
	    return False;
	  }
      info++;
    }
  else
    node->zone = -1;
	    
  /* Extract net information if net is present, otherwise
     set net to -1. */

  if (strchr(info, '/'))
    {
      for (node->net = 0; *info != '/'; info++)
        if (isdigit(*info))
          node->net = node->net * 10 + *info - '0';
        else
          {
            debug(1, "Invalid character in net '%c' %02x", *info, *info);
            return False;
          }
      info++;
    }
  else
    node->net = -1;
  
  /* Exract node information, set to -1 if empty. */
  
  if (*info)
    for (node->node = 0; *info && *info != '.'; info++)
      if (isdigit(*info))
        node->node = node->node * 10 + *info - '0';
      else
        {
          debug(1, "Invalid characer in node '%c' %02x", *info, *info);
          return False;
        }
  else
    node->node = -1;
  
  /* Exract point information, set to -1 if empty. */
  
  if (*info)
    for (node->point = 0; *info; info++)
      if (isdigit(*info))
        node->point = node->point * 10 + *info - '0';
      else
        {
          debug(1, "Invalid characer in node '%c' %02x", *info, *info);
          return False;
        }
  else
    node->point = -1;
  
  debug(2, "Got alias %s", ascnode(*node));
  return True;
}

/* Compare receiver and user in aliasfile. Each line in aliasfile contains
   alias, optional net/node information separated by commas zero or
   more times, white space(s) and rest of the line literally to whom
   mail should be send. Net and node information is format 'net/node'.
   if net is omitted then every net is counted, if node is omitted,
   then all nodes in that net. If net is omitted, slash may be left off.
   
   E.g following are valid aliases:

   tot,504/ Teemu Torma
   foo Foo Bar
   sysop,504/1,504/9 System Operator */

bool
aliascmp(alias, to, node)
     char *alias, *to;
     Node node;
{
  char buffer[BUFSIZ];
  char *cp;
  Node anode;
  
  while (*alias && *alias != ',' && !isspace(*alias) && *to)
    if (*alias++ != *to++)
      return False;
  
  if (isspace(*alias)) /* match */
    return True;
  
  if (*alias == ',')
    {
      /* copy alias to buffer and terminate the it after first space */
      (void) strcpy(buffer, alias + 1);
      for (cp = buffer; *cp; cp++)
        if (isspace(*cp))
          {
            *cp = 0;
            break;
          }
      
      /* get net/node information from buffer one at the time */
      for (cp = strtok(buffer, ","); cp; cp = strtok((char *) 0, ","))
        {
          debug(2, "Got node '%s'", cp);
          if (getnode(cp, &anode))
            {
              if ((anode.zone == -1 || anode.zone == node.zone) &&
		  (anode.net == -1 || anode.net == node.net) &&
		  (anode.node == -1 || anode.node == node.node) &&
		  (anode.point == -1 || anode.point == node.point))
                return True;
            }
          else
            return False;
        }
    }
  else
    debug(1, "Invalid alias, %c is not ',' or white space", *alias);
  
  return False;
}

/* Return receiver's name. If name is aliased, return it, otherwise
   return receiver's name. */

char *
receiver(to, node)
     char *to;
     Node node;
{
  static char name[36];
  char buffer[BUFSIZ];
  register int cnt;
  register char *cp;
  FILE *fp;
  
  if (fp = fopen(config.alias, "r"))
    {
      while (fgets(buffer, BUFSIZ, fp))
        {
          buffer[strlen(buffer) - 1] = 0;
          if (*buffer != '#')
            debug(3, "Checking for alias %s", buffer);
          if (*buffer != '#' && aliascmp(buffer, to, node))
            {
              /* match, save the alias. */
              for (cp = buffer; *cp && !isspace(*cp); cp++)
                /* skip alias itself */;
              while (isspace(*cp))
                cp++;
              if (*cp)
                {
                  for (cnt = 0; *cp && cnt < 35; cnt++, cp++)
                    name[cnt] = *cp;
                  name[cnt] = 0;
                  debug(2, "Got alias %s", name);
                  return name;
                }
              else
                debug(1, "Missing alias");
            }
        }
      (void) fclose(fp);
    }
  else
    log("$Unable to open aliasfile %s", config.alias);
  
  /* Alias not found. Return the the original receiver with all
     _-characters replaced by space and all words calitalized. */
  
  for (cp = NULL, cnt = 0; *to && cnt < 35; cnt++, cp = to++)
    {
      if (*to == '_')
        name[cnt] = ' ';
      else
        if (!cp || *cp == '_' || *to == ' ')
          name[cnt] = toupper(*to);
        else
          name[cnt] = tolower(*to);
    }
  name[cnt] = 0;
  debug(2, "No alias, name %s", name);
  return name;
}

/* Return receiver's name, took Comment-To: field. If not found,
   call receiver() and return what it returns */

char *newsreceiver(fp, to, node)
     FILE *fp;
     char *to;
     Node node;
{
  char *cp;

  debug(2, "Checking To: field");
  if (cp = sender(fp, "To: "))
    {
      debug(1, "Got recipent %s from To: field", cp);
      (void) strcpy(to, cp);
    }
  else
    {
      debug(2, "Checking Comment-To: field");
      if (cp = sender(fp, "Comment-To: "))
	{
	  debug(1, "Got recipent %s from Comment-To field", cp);
	  (void) strcpy(to, cp);
	}
    }
  
  return receiver(to, node);
}

/* Get date from mail. Look for Date: field, if present and time is in
   correct format (same than ARPA-net mail uses), it will be used, otherwise
   current time will be taken. */

char *
lgetdate(fp)
     FILE *fp;
{
  time_t timevar;
  struct tm *localtime();
  struct tm *mtime;
  static char timebuf[20];
  char buffer[BUFSIZ];
  /* literal months */
  static char *months[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
    (char *) 0,
  };
  /* Literal weekdays */
  static char *wkdays[] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", (char *) 0,
  };
  
  (void) rewind(fp);
  while (fgets(buffer, BUFSIZ, fp))
    /* did we find Date: */
    if (!strncmp(buffer, "Date: ", 6))
      {
	buffer[strlen(buffer) - 1] = '\0';
        /* try to extract date and other information from it */
        debug(2, "Found date: '%s'", buffer + 6);
#ifdef OLD_VERSION
        if (sscanf(buffer + 6, "%3s, %2d %3s %2d %2d:%2d:%*2d %*s",
		   wday, &mday, month, &year, &hour, &min) == 6)
          {
            debug(2, "Correct date format");
            /* save date in SEAdog format */
            (void) sprintf(timebuf, "%3s %2d %3s %2d %02d:%02d",
                           wday, mday, month, year, hour, min);
            return timebuf;
          }
#else
	timevar = getdate(buffer + 6, (struct timeb *) NULL);
	debug(2, "timevar %ld", timevar);
	if (timevar == -1)
	  {
	    timevar = time((long *) NULL);
	    log("Unparseable date %s, using today", ctime(&timevar));
	  }
	
	mtime = localtime(&timevar);
	/* Save date in SEAdog format */
	(void) sprintf(timebuf, "%3s %2d %3s %2d %02d:%02d",
		       wkdays[mtime->tm_wday], mtime->tm_mday,
		       months[mtime->tm_mon], mtime->tm_year,
		       mtime->tm_hour, mtime->tm_min);
	debug(1, "Returning %s", timebuf);
	return timebuf;
#endif
      }
  
  (void) rewind(fp);
  debug(2, "No Date: field in mail");
  
  /* we did not found Date: field, let's use current time */
  return date("%a %d %h %y %T", (long *) NULL);
}

/* Send mail from filepoiner fp to user to. To is in format of
   net!node!receiver, where net and node are destnation and
   receiver is receivers name in which blankos are replaces by
   _-characters or alias. */

int
sendmail(fp, to)
     FILE *fp;
     char *to;
{
  char buffer[BUFSIZ], *cp;
  FILE *sf;
  char *sfile;
  char hostname[10];
  Node node;
  char name[36];
  int status, nodate, nosubject, nofrom, nocommentto, noto;

  (void) gethostname(hostname, 10);
  
  /* get receiver and net/node */
  if (cp = parse_address(to, name, &node))
    {
      sendback(fp, "Parse failed: %s", cp);
      return EX_NOHOST;
    }
  
  debug(1, "Sending mail to %s at %s", name, ascnode(node));
  
  if ((status = valid_netnode(name, node, fp)) != EX_OK)
    return status;

  debug(1, "Netnode ok, opening spool file");

  if (sf = fopen(sfile = spoolfile("M."), "w"))
    {
      /* set correct permissions for spoolfile and lock it */
      (void) chmod(sfile, 0600);
      (void) lock(fileno(sf));

      debug(1, "chmod and lock ok");
      
      /* save net and node information */
      (void) fprintf(sf, "N %s\n", ascnode(node));
      
      /* save receiver. If using newsreceiver seem to cause
	 trouble, use normal receiver if not in news mode */

      (void) fprintf(sf, "T %s\n", newsreceiver(fp, name, node));

      /* save sender ... */
      debug(10, "Trying to find sender (From)");
      (void) fprintf(sf, "F %s\n", (cp = sender(fp, "From: ")) ?
		     cp : "Usenet");
      
      /* try to find subject ... */
      (void) rewind(fp);
      while (fgets(buffer, BUFSIZ, fp))
        if (!strncmp("Subject: ", buffer, 9))
          {
            (void) fprintf(sf, "S %s", buffer + 9);
            buffer[strlen(buffer) - 1] = 0;
            debug(2, "Subject: %s", buffer + 9);
            break;
          }

      if (feof(fp))
        /* we didn't find subject.. */
        (void) fprintf(sf, "S Mail from Usenet\n");
      
      /* save date */
      (void) fprintf(sf, "D %s\n", lgetdate(fp));
      
      /* if not public, mark that message is private */
      if (!public)
        (void) fprintf(sf, "P \n");
      
      /* done with header information, now we'll copy the hole mail
         after the header */
      
      (void) putc('\n', sf);
      
      debug(2, "Copying mail");

      /* Now copy mail, also add Received field to mail */
      (void) rewind(fp);
      while (fgets(buffer, BUFSIZ, fp) && (!strncmp(buffer, "From ", 5) ||
                                           !strncmp(buffer, ">From ", 6) ||
					   !strncmp(buffer, "AREA:", 5)))
	(void) fputs(buffer, sf);

      if (config.rfc_received_header)
	{
	  (void) fprintf(sf, "Received: from %s%s by %s (%s/%s)\n",
			 hostname, config.domain, internode(this),
			 PROGRAMNAME, version, this.name);
	  (void) fprintf(sf, "\tid AA%05d; %s\n", getpid(),
			 date("%a, %d %h %y %T %o (%z)", (long *) NULL));
	}
      
      /* Copy header. Try to avoid duplicating headers already in
	 fidonet header. Only first occurence of header is processed,
	 others will be ignored. Header is considered to end at first
	 empty line. */
      
      nodate = TRUE;
      nosubject = TRUE;
      nofrom = TRUE;
      nocommentto = TRUE;
      noto = TRUE;

      /* Insert ^AINTL if needed */
      if (node.zone != config.mynode.zone)
	(void) fprintf(sf, "\001INTL %s %s\n", ascnode_nopoint(node),
		       ascnode_nopoint(this));

      /* Insert ^AFMPT and ^ATOPT if needed */
      if (this.point)
	(void) fprintf(sf, "\001FMPT %d\n", this.point);
      
      if (node.point)
	(void) fprintf(sf, "\001TOPT %d\n", node.point);
      
      do {

	/* Date is in mail header, so skip header Date: */
	if (nodate)
	  if (!strncmp(buffer, "Date:", 5))
	    {
	      nodate = FALSE;
	      continue;
	    }

	/* Print subject only if it doesnt fit in fidonet header correctly */
	if (nosubject)
	  if (!strncmp(buffer, "Subject:", 8))
	    {
	      if (strlen(buffer + 8) > 72) 
		(void) fputs(buffer, sf);
	      nosubject = FALSE;
	      continue;
	    }

	/* Print From field only if it doesn't fit in fidonet header */
	if (nofrom)
	  if (!strncmp(buffer, "From:", 5))
	    {
	      if (strlen(buffer + 5) > 36)
		(void) fputs(buffer, sf);
	      nofrom = FALSE;
	      continue;
	    }

	/* There should be either comment-to or to, depending on whether this
	   is a news message or not */
	if (nocommentto)
	  if (!strncmp(buffer, "Comment-To:", 11))
	    {
	      if (strlen(buffer + 11) > 36)
		(void) fputs(buffer, sf);
	      nocommentto = FALSE;
	      continue;
	    }
	      
	if (noto)
	  if (!strncmp(buffer, "To:", 3))
	    {
	      if (strlen(buffer + 3) > 36)
		(void) fputs(buffer, sf);
	      noto = FALSE;
	      continue;
	    }
	      
	(void) fputs(buffer, sf);
      } while (fgets(buffer, BUFSIZ, fp));

      /* done. */
      (void) fclose(sf);
      return EX_OK;
    }
  else
    {
      log("$Unable to open spoolfile");
      return EX_CANTCREAT;
    }
  /* NOTREACHED */
}

/*ARGSUSED*/
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  int cnt, c;
  FILE *mail;
  char buffer[BUFSIZ], tmpf[L_tmpnam];
  int status = EX_OK;
  char *error;
  Node *node;

  get_configuration();
  
  newsmode = FALSE;
  while ((c = getopt(argc, argv, "npvV:")) != EOF)
    switch (c)
      {
       case 'n':
	/* Set news-mode */
	newsmode = TRUE;
	break;
      case 'v':
        /* set more verbosity */
        verbose++;
        break;
      case 'V':
        /* allow version on command line only if test version. */
        if (*version != '%' || version[1] != 'I' || version[2] != '%')
          version = optarg;
        /* NOTE: Comparison cannot be with strcmp, because SCCS would also
           change that comparison string. */
        break;
      case 'p':
        /* this is not private message */
        public = True;
        break;
      default:
        (void) fprintf(stderr, "See manual page.\n", *argv);
        exit(EX_USAGE);
      }
  
  /* create name of temporary mail-message */
  (void) strcpy(tmpf, P_tmpdir);
  (void) strcat(tmpf, mktemp("rfm.XXXXXX"));
  
  /* open mail-temp */
  if (mail = fopen(tmpf, "w+"))
    {
      /* protect mail file */
      (void) chmod(tmpf, 0600);
      
      /* copy mail to temp-file */
      while (fgets(buffer, BUFSIZ, stdin))
        (void) fputs(buffer, mail);
      
      /* update nodelist-index if needed */
      if (error = update_index())
        {
          /* there was error while updating nodelist-index */
          if (*error == '$')
            sendback(mail, "%s: %s", error + 1, sys_errlist[errno]);
          else
            sendback(mail, "%s", error);
          exit(EX_SOFTWARE);
        }

      if ((node = node_entry(config.mynode)) == NULL)
        {
          (void) fprintf(stderr, "Unable to find this node from nodelist\n");
          log("No %s in nodelist", ascnode(config.mynode));
          exit(EX_SOFTWARE);
        }
      this = *node;
  
      
      /* send mail to all user's */
      for (rewind(mail), cnt = optind; cnt < argc; rewind(mail), cnt++)
          /* send mail */
          if ((status = sendmail(mail, argv[cnt])) != EX_OK)
            break;
      
      /* remove temporary file */
      (void) fclose(mail);
      (void) unlink(tmpf);
    }
  else
    {
      /* opening tmp-file failed, we can't even send mail back */
      log("$Can not open %s for writing", tmpf);
      exit(EX_CANTCREAT);
    }
  
  exit(status);
  /*NOTREACHED*/
}
