/* @(#)%M%  %I%  Teemu Torma %H%
   
   Configure file for FidoNet mailing system.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* Change these defines for your system. */

/* Machine information. USG for System V. One of these must be defined */
/* #define USG /**/
#define BSD

/* Name of log file. This is not in config file as its needed before config
   file is read. No syslog support yet, but I'm doing my best. You should
   check it out sometimes and clean it up, it grows for ever and with large
   debug level, it eats up your disk overnight if you run lots of traffic.
   Use full pathnames, with no trailing slash! */

#define LOGFILE "/usr/lib/fnet/log"

/* Configuration file. Usually $LIBDIR/rfmail.cf. Again, full pathnames,
   not trailing slash. */

#define CONFIGFILE "/usr/lib/fnet/rfmail.cf"
  
/* Define this if you have <sysexits.h>. Dummy one is included, its quite
   simple so it shouldn't be a problem anyway. It should be standard in BSD
   and SVR3. */
  
#define HAVE_SYSEXITS /**/

/* One of these must be defined. HAVE_DIRENT should work on SVR3 and on any
   posix-compatible system. Ndir is probably more common, and only difference
   I am aware of between dirent and ndir is that directory structure is
   called dirent in dirent, direct in ndir. If BSD, this won't matter,
   comment both would probably be best. */

/* #define HAVE_DIRENT /**/
/* #define HAVE_NDIR /**/

/* Define this if you have <unistd.h>. Dummy one included. It should be
   standard in SVR3. */
  
/* #define HAVE_UNISTD /**/

/* Alloca is bsd-originated function which allocates memory local to
   a function which will be automatically freed when returning. It usually
   allocates it in stack. Gnu emacs includes couple of alloca's for some
   computers and a C-version which is less efficient. If this is not defined,
   malloc will be used and space will not be freed. It to my knowledge doesn't
   hit the roof dangerously fast. Alloca.s for CT miniframe is included (maybe
   works on 3b1 && 7300). */

#define HAVE_ALLOCA /**/

/* This means you are using C-alloca from D A Gwyn or GNU project (or
   are those same?). Only thing it currently causes is a call to alloca
   with zero parameter in funpack during unpacking loop, which should
   force garpage collection. I hope, never used it. 
   
   STACK_DIRECTION is optional, if not defined, it will be detected
   runtime. 

   STACK_DIRECTION > 0 => grows toward higher addresses
   STACK_DIRECTION < 0 => grows toward lower addresses
   STACK_DIRECTION = 0 => direction of growth unknown
   */

/* #define C_ALLOCA /**/
/* #define STACK_DIRECTION -1 /**/
  
/* Define this to use lockf instead of locking. Miniframe CTIX has locking,
   SVR3 has lockf. Notice that LOCK_LOCKFILES is handled at higher
   level than real lock. */

/* #define LOCK_LOCKF /**/
/* #define LOCK_LOCKING /**/
#define LOCK_LOCKFILES /**/
  
/* Define this if you have mkdir(). If not defined, system() will be used
   to create missing directories. */

#define HAVE_MKDIR /**/

/* Define this if you have dial(). Notice that very often system V
   dial distributed doesn't work. In fact, I have never encountered
   a working one. If not defined, built-in dialer real-dumb one will
   be used, so I recommend using one from Gene H. Olson,
   ihnp4!quest!gene, which is more flexible and reliable. */

/* #define HAVE_DIAL /**/
  
/* Type to hold 16 bit integer. This probably isn't used in all places it
   should be used. Due to alignment problems it shouldn't do structure
   writes/reads any more. */

#define INT16 short

/* Define this if bytes need to be swapped to msdos. This is needed for
   68k series of processors, not needed for VAX or intel processors. */

/* #define SWAB_BYTES /**/

/* Define this if your poor compiler doesn't understand names longer than 7
   chars as in some USG versions. It just includes file created by clash. To
   compile on systems on which even C prerocessor doesn't understand long
   names, I would strongly getting cpp from GNU C package, even though you
   probably sometimes have to switch between original and it (relinking
   the kernel doesn't work on my miniframe when using gnu cpp) */

/* #define HAVE_SHORTNAMES */

/* End of important configuration section. Normally you can ignore rest
   of this file. */
   
/* These maybe must be made smaller if trying to port to 16-bit computers, as
   config structure should be less than 64 k, these probably hit the roof.
   Try shortening comand length and newsgroup length first. */
  
#define RECEIVE_PATH_LEN 128
#define DOMAIN_LEN 128
#define PATH_LEN 1024
#define DIALS 20
#define DIALSTRING_LEN 40
#define ORIGIN_LEN 128
#define SEENBY_LEN 1024
/* Echolen 32 is imposed by fidonet echomail programs to my knowledge */
#define MAX_ECHOLEN 32
#define MAX_NGLEN 64
#define MAX_DISTRIBUTION_LEN 32
/* This may be a bit too long for real use */
#define MAX_COMMAND_LEN 256
/* I will soon hit 100 echos in my system, so this probably need a tweak at
   big sites (I'm in Europe) */
#define MAX_NEWSGROUPS 200
#define MAX_AKAS 10
#define MAX_SEENBYS 12
#define MAX_HEADERS 20
#define MAX_HEADER_LEN 256
  
/* End of configure section. Don't go further. */
  
#ifdef HAVE_SYSEXITS
# include <sysexits.h>
#else /* not HAVE_SYSEXITS */
# define EX_OK 0 /* successful termination */
# define EX_USAGE 64 /* command line usage error */
# define EX_DATAERR 65 /* data format error */
# define EX_NOINPUT 66 /* cannot open input */
# define EX_NOHOST 68 /* host name unknown */
# define EX_UNAVAILABLE 69 /* service unavailable */
# define EX_SOFTWARE 70 /* internal software error */
# define EX_OSERR 71 /* system error (e.g., can't fork) */
# define EX_OSFILE 72 /* critical OS file missing */
# define EX_CANTCREAT 73 /* can't create (user) output file */
# define EX_IOERR 74 /* input/output error */
#endif /* not HAVE_SYSEXITS */

#ifdef HAVE_SHORTNAMES
#include "longnames.h"
#endif

#ifndef HAVE_ALLOCA
#define alloca malloc /* a dirty shortcut ? */
#endif

#ifdef HAVE_UNISTD
#include <unistd.h>
#else
#include "unistd.h"
#endif

#ifdef USG
struct timeb
{
  time_t	time;
  unsigned short	millitm;
  short		timezone;
  short		dstflag;
};
#include <malloc.h>
#endif
#ifdef BSD

#include <sys/timeb.h>
extern char *malloc();
extern char *realloc();
extern FILE *tmpfile();
#ifndef P_tmpdir
#define P_tmpdir "/tmp"
#endif
#ifndef L_tmpnam
#define L_tmpnam (sizeof(P_tmpdir) + 255)
#endif

#endif /* BSD */

#include <ctype.h>

#if !defined(USG) && !defined(BSD)
unknown operating system, trying to cause a panic...!
You need to define either USG or BSD.
hope it worked.
#endif


  
