#include <stdio.h>
#include <sys/types.h>
#include "hsu.h"  
#include "config.h"
  
#ifdef BSD

/* BSD doesn't seem to have bsearch? Weird, but hope this works */
  
char *bsearch(item, items, nitems, itemsize, cmpfunction)
     char *item, *items;
     unsigned nitems;
     unsigned itemsize;
     int (*cmpfunction)();
{
  unsigned int position, previous_position, step;
  int cmp, lastcmp;
  
  if (!items) return NULL;
  
  previous_position = -1;
  step = (nitems - 1) / 2;
  position = step;
  if (step < 1) step = 1;
  
  while (cmp = cmpfunction(item, items + position * itemsize)) {
    cmp = REDUCE(cmp); /* This maybe isn't necessary ? */
    step = step / 2;
    if (!step) {
      step = 1;
      if (lastcmp != cmp) {
	/* Seems that we are stepping around same point, its not there */
	return NULL;
      }
    }

    if (cmp > 0) {
      if (position + step >= nitems) {
	if (step == 1) {
	  return NULL; /* Fell of the edge */
	} else {
	  position = nitems - 1;
	}
      } else {
	position += step;
      }
    } else {
      if ((int) position - step < 0) {
	if (step == 1) {
	  return NULL; /* Fell of the edge */
	} else {
	  position = 0;
	}
      } else {
	position -= step;
      }
    }
    lastcmp = cmp;
  }
  
  return items + position * itemsize;
}
      
#endif /* BSD */
