/*
 *************
 * DISTRIBUTION NOTICE  July 30 1985
 * A Revised Edition of WM, by Matt Lennon and Tom Truscott,
 *		Research Triangle Institute, (919) 541-7005.
 * Based on the original by Robert Jacob (decvax!nrl-css!jacob),
 *		Naval Research Laboratory, (202) 767-3365.
 * No claims or warranties of any sort are made for this distribution.
 * General permission is granted to copy, but not for profit,
 * any of this distribution, provided that this notice
 * is always included in the copies.
 *************
 */
/*
 * definitions for wm
 */

#include "curses.h"
#include <sys/types.h>
#include <ctype.h>

#define	CURSEASSIST		/* give curses a hand, sigh. */
#define	SET_WINDOW		/* assist all-wonderful scrolling rectangles */
#define	GAGMEKEYPAD		/* gross hack for arrow keys */
/*#define	SNEAKYTERMCAP		/* /tmp termcap kludge */

/* define TERMINFO if we are using a terminfo version of curses */
#ifdef A_STANDOUT
#define	TERMINFO
#endif

#ifdef TERMINFO
/* define FASTTERMINFO if your terminfo has a clever doupdate */
/*#define	FASTTERMINFO	/**/
/* define BUGGYTERMINFO if your terminfo has 'certain bugs' */
#define	BUGGYTERMINFO	/**/
#endif

/*
 * Definitions for curses
 */
#define	wcury(w)	((w)->_cury)	/* current (y,x) in window w */
#define	wcurx(w)	((w)->_curx)
#define	wbegy(w)	((w)->_begy)	/* window offset from origin */
#define	wbegx(w)	((w)->_begx)
#define	wlines(w)	((w)->_maxy)	/* # lines/cols in window w */
#define	wcols(w)	((w)->_maxx)
#define	cursrow()	wcury(curscr)	/* current (y,x) on screen */
#define	curscol()	wcurx(curscr)

/* stuff dependent on the version of curses */
#ifdef TERMINFO
#undef GAGMEKEYPAD
#ifdef FASTTERMINFO
#undef CURSEASSIST
#endif
#undef wlines
#undef wcols
#define	wlines(w)	((w)->_maxy+1)	/* # lines/cols in window w */
#define	wcols(w)	((w)->_maxx+1)
#include <term.h>
/* undefine one of the more annoying definitions in term.h */
#ifdef lines
#undef lines
#endif
extern WINDOW *newscr;
#define	Untouchwin(wp)	untouchwin(wp),untouchwin(newscr)
#ifdef CURSEASSIST
/* curseassist cheats big */
#define	Cmove(y,x)	wmove(curscr,y,x),wmove(newscr,y,x)
#define	Cinsertln()	winsertln(curscr),winsertln(newscr)
#define	Cdeleteln()	wdeleteln(curscr),wdeleteln(newscr)
#endif
#else
extern int *_putchar();
#define	putp			_puts
#define	enter_ca_mode		TI
#define	cursor_address		CM
#define	flash_screen		VB
#define	enter_standout_mode	SO
#define	exit_standout_mode	SE
#define	move_standout_mode	MS
#define	insert_line		AL
#define	delete_line		DL
#define	change_scroll_region	CS
#define	scroll_reverse		SR
#define	save_cursor		SC
#define	restore_cursor		RC
#define	insert_character	IC
#define	insert_null_glitch	IN
#define	enter_insert_mode	IM
#define	exit_insert_mode	EI
#define	delete_character	DC
#define	scroll_forward		NL
#define	cursor_down		DO
#define	cursor_up		UP
#define	Untouchwin(wp)	untouchwin(wp)
#ifdef CURSEASSIST
/* curseassist cheats big */
#define	Cmove(y,x)	wmove(curscr,y,x)
#define	Cinsertln()	winsertln(curscr)
#define	Cdeleteln()	wdeleteln(curscr)
#endif
#endif

/* key pad atrocities follow */
extern char tty_text[], keycap[];
extern int tty_textlen, tty_backcnt;
#ifndef KEY_BACKSPACE
#define	KEY_BACKSPACE	0401
#define	KEY_UP		0402
#define	KEY_DOWN	0403
#define	KEY_LEFT	0404
#define	KEY_RIGHT	0405
#define	KEY_HOME	0406
#endif
#ifndef GAGMEKEYPAD
#define	tty_getch	tty_realgetch
#endif

/*
 * The number of active windows is limited by the number of
 * open files a process (i.e., main) may have,
 * the number of processes a user or the whole system can have,
 * and (on an 11 but not a VAX) the memory for the per-window curses buffers.
 * Also, window names are limited to 0..9, i.e. at most 10 windows.
 */
#define	MAXWINDOWS	10	/* windows #0..#9 */

#define	ESC		'\033'	/* char for virtual terminal functions */
#define	CANCEL1		'\033'	/* char to cancel wm command */
#define	CANCEL2		'\177'	/* char to cancel wm command */

#define	MINWINDOW	1	/* change this to 0 to permit window #0 */
#define	iswindow(w) ((w)>=MINWINDOW && (w)<MAXWINDOWS && (win[w].flags&INUSE))
#define	ctoi(c)		((c)-'0')	/* convert ascii digit to int */
#define	itoc(i)		((i)+'0')	/* convert int to ascii digit */

/*
 * Global data with miscellaneous information about each window
 */
struct win_struct
{
    int flags;			/* window status bits */
#define	INUSE	001	/* window is in use */
#define	XFLEX	002	/* # of columns is COLS (depends on terminal type) */
#define	YFLEX	004	/* # of rows    is ROWS ( ""     ""    ""     "" ) */
#define	FAST	010	/* window can scroll 'quickly' (not redrawn) */
#define	BROWSE	020	/* window is in 'browse' mode */
#define	BLOCKED	040	/* window updates are being delayed */
    int next;			/* next window in list */
    char covers[MAXWINDOWS];	/* TRUE for windows we're on top of */
    WINDOW *wptr;		/* ptr to small curses win to be displayed */
    WINDOW *boxbot, *boxtop;	/* ptrs to curses wins for box, or NULL */
    WINDOW *boxright, *boxleft;	/* ptrs to curses wins for box, or NULL */
    char pend[4];		/* characters in partial escape sequence */
    int pid;			/* pid of this window's shell */
    int pty;			/* fildes of pty to/from this win's shell */
};

/*
 * Handy macros
 */
#define	MAX(a,b)	((a)>=(b)? (a): (b))
#define	MIN(a,b)	((a)<=(b)? (a): (b))

/*
 * External variables.
 */
extern struct win_struct win[];	/* array of windows */
extern int botw, topw, lastw;	/* bottom, top, last window */
extern int prefix;		/* WM command prefix character */
extern char savefile[];		/* name of save/restore file */
extern char shellname[];	/* name of shell */
extern char shellpgm[];		/* pathname of shell */
extern int configflag;		/* true if window config. has changed */
extern time_t msgbirth;		/* time last message was displayed */
#ifndef TERMINFO
extern char *change_scroll_region, *save_cursor, *restore_cursor;
extern char *set_window;
#endif
extern int has_scroll_window, has_scroll_region, has_insdel_line;

/*
 * Functions returning a non-int value
 */
FILE *fopen();
char *sprintf(), *strcpy(), *strcat(), *rindex(), *getenv();
char *mkprint(), *termcap(), *WPrompt(), *plural();
double *Malloc();	/* if only malloc were declared this way */

#define	alloc(n,type)	((type*)Malloc((unsigned)((n)*sizeof(type))))
