/*
 *************
 * DISTRIBUTION NOTICE  July 30 1985
 * A Revised Edition of WM, by Matt Lennon and Tom Truscott,
 *		Research Triangle Institute, (919) 541-7005.
 * Based on the original by Robert Jacob (decvax!nrl-css!jacob),
 *		Naval Research Laboratory, (202) 767-3365.
 * No claims or warranties of any sort are made for this distribution.
 * General permission is granted to copy, but not for profit,
 * any of this distribution, provided that this notice
 * is always included in the copies.
 *************
 */
/*
 * save.c  M. Lennon  2/07/85
 * Save and restore windows between WM sessions.
 */

#include "wm.h"


/* Save windows from this session in HOME/.wmrc.
 *
 * Produces an ascii file containing info
 * necessary for restoring windows in next WM session.
 */
Save(file)

char *file;	/* name of save file */
{
    register FILE *fp;			/* save file pointer */
    register WINDOW *w;
    register int i;


    if (*file == '\0')
	return(FALSE);
    if ((fp=fopen(file,"w")) == NULL)
	return(FALSE);

    fprintf(fp, "%s\n", mkprint(prefix));

    for (i=botw; i>=0; i=win[i].next)
    {
	w = win[i].wptr;
	fprintf(fp, "%d %d %d %d %d\n",
	  i,
	  (win[i].flags&YFLEX)? 0: wlines(w),
	  (win[i].flags&XFLEX)? 0: wcols(w),
	  wbegy(w), wbegx(w));
    }

    (void)fclose(fp);
    return(TRUE);
}

/*
 * Restore windows from previous session
 * as stored in ~/.wmrc.
 * Returns number of windows restored (0 on error).
 */
Restore(file)

char *file;	/* name of restore file */
{
    register FILE *fp;			/* restore file pointer */
    int w;				/* window index */
    int lines, cols, begline, begcol;	/* window parameters */
    int count;		/* number of windows restored */
    int lshrink, cshrink; /* amount that windows must be shrunk to fit */
    int rc;		/* temporary to hold return code from fscanf */
    char ccbuf[10], tbuf[100];	/* temporary buffers */
    register char *p;	/* temp pointer into tbuf */


     /* Open save/restore file.
      */
    if (*file == '\0')
	return(0);
    if ((fp=fopen(file,"r")) == NULL) {
	showmsg("\007Cannot read '%s'.", file);
	sleep(2);
	return(0);
    }
    
     /* Read first line of ~/.wmrc to get the WM prefix character.
      */
    if (fscanf(fp,"%2s%1[\n]", ccbuf, tbuf) != 2) {
	(void)fclose(fp);
	showmsg("\007Bad .wmrc file '%s'.", file);
	sleep(2);
	return(0);
    }
    if (ccbuf[0]=='^' && ccbuf[1])
	prefix = (ccbuf[1]=='?' ? '\177' : ccbuf[1]-0100);
    else prefix = ccbuf[0];

    
     /* Restore the windows.
      * Stop trying if input error encountered.
      */
    count = 0;
    for (;;)
    {
	 /* Read window parameters.
	  * Check for end of file, format error,
	  * bad window name, and bad window dimensions.
	  */
	rc = fscanf(fp,"%d%d%d%d%d%1[\n]",
		&w,&lines,&cols,&begline,&begcol,tbuf);
	if (rc == EOF)
	    break;
	if (rc != 6 || lines < 0 || cols < 0 || begline < 0 || begcol < 0
	 || w < MINWINDOW || w >= MAXWINDOWS || (win[w].flags&INUSE)) {
	    showmsg("\007Bad window entry, file '%s'.", file);
	    sleep(2);
	    break;
	}

	/*
	 * check for "flex" windows
	 */
	if (lines == 0 && begline == 0) {
	    lines = LINES-1;
	    win[w].flags |= YFLEX;
	}
	if (cols == 0 && begcol == 0) {
	    cols = COLS;
	    win[w].flags |= XFLEX;
	}

	/* Check for windows which are beyond this screen */
	/* Bug: if .wmrc is updated these windows are omitted! */
	if (begline >= LINES-1 || begcol >= COLS) {
	    showmsg("\007Window #%d is off this screen.", w);
	    sleep(2);
	    continue;
	}

	/* Check for windows which must be shrunk to fit */
	/* Bug(?): if .wmrc is updated the new sizes are saved */
	lshrink = cshrink = 0;
	if (begline+lines > LINES-1) {
	    lshrink = begline+lines-(LINES-1);
	    lines -= lshrink;
	}
	if (begcol+cols > COLS) {
	    cshrink = begcol+cols-COLS;
	    cols -= cshrink;
	}
	if (lshrink+cshrink) {
	    p = tbuf;
	    (void)sprintf(p, "\007Window #%d shrunk by", w); p += strlen(p);
	    if (lshrink) {
		(void)sprintf(p, " %d line%s%s", lshrink, plural(lshrink),
			cshrink? " and": "");
		p += strlen(p);
	    }
	    if (cshrink) {
		(void)sprintf(p, " %d column%s", cshrink, plural(cshrink));
		p += strlen(p);
	    }
	    (void)sprintf(p, ".");
	    showmsg("%s", tbuf);
	    sleep(2);
	}

	 /* Construct new window.
	  */
	if (NewWindow(w,lines,cols,begline,begcol))
	    continue;	/* cannot happen? */
	WListAdd(w);
	count++;
    }

    (void)fclose(fp);
    return(count);
}
