#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif lint

/* Replacement for rmail. This looks out, if destination system
   name is numeric, and if it is, feeds mail to fidonet mail
   server. If systemname is not numeric, this executes real rmail.
   If this site is not fidonet gateway, define GATEWAY in rmail.h
   to path to that host.

   This is just a temporary replacement, MUCH MORE better is to use
   sendmail for gatewaying or smail 2.3 version that also can invoke
   other mailer.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "rmail.h"
#include "sysexits.h"

extern char *malloc();
extern void exit();
extern void perror();
extern char *regex();

#ifndef GATEWAY


/* Open stream associated with programs standard input. Program is invoked
   with given argument list. Popen(3S) would invoke mailer thru sh(1),
   so this uses less memory and is faster. */

FILE *
open_mailer(program, args, pid)
     char *program, **args;
     int *pid;
{
  FILE *fp;
  int fd[2];
  
  /* create pipe */
  if (pipe(fd) == -1)
    {
      perror("rmail: pipe");
      exit(EX_OSERR);
    }
  
  switch (*pid = fork())
    {
    case -1:
      perror("rmail: fork failed");
      exit(EX_OSERR);
    case 0:
      (void) close(0);
      if (dup(fd[0]) == 0)
        {
          (void) close(fd[0]);
          (void) close(fd[1]);
          (void) execvp(program, args);
          perror(program);
        }
      else
        perror("rmail: dup");
      exit(EX_OSERR);
    default:
      (void) close(fd[0]);
      if ((fp = fdopen(fd[1], "w")) == NULL)
        {
          perror("rmail: fdopen");
          exit(EX_OSERR);
        }
    }
  return fp;
}

#endif GATEWAY


/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  int cnt;
  
#ifdef GATEWAY
  
  char *path;
  
#else GATEWAY
  
  char **rargs = marray(argc + 1), **fargs = marray(argc + 1);
  int rrec = 0, frec = 0, rargc = 1, fargc = 1;
  int status = EX_OK;
  
#endif GATEWAY
  
#ifdef GATEWAY
  
  /* If GATEWAY is defined, send all mail going to fidonet to there.
     If domain .FidoNet is known by other mahcines, routing is not
     really problem and this rmail is not needed elsewhere than in
     real gateway if there's no sendmail or other intelligent system
     in use. */
  
  for (cnt = 1; cnt < argc; cnt++)
    if (parse_address(argv[cnt]) == NULL)
      {
#ifdef DEBUG
        (void) printf("Routing %s to %s.\n", argv[cnt], GATEWAY);
#endif DEBUG
        path = malloc((unsigned) (strlen(GATEWAY) +
                                  strlen(argv[cnt]) + 2));
        (void) strcpy(path, GATEWAY);
        (void) strcat(path, "!");
        argv[cnt] = strcat(path, argv[cnt]);
      }
  
  (void) execvp(RMAIL, argv);
  perror(RMAIL);
  
#else GATEWAY
  
  *rargs = RMAIL;
  *fargs = FIDOMAILER;
  
  /* Scan thru receiver list and put all receivers in fidonet in fido-
     mailer's receiver-list and all others in real rmails one. No
     options can be passed to fidomailer thru this, because it would
     be too difficult to determine which one goes to which one and
     there might be same options also. Somehow it's good that fidomailer
     is well hidden under this... */
  
  for (cnt = 1; cnt < argc; cnt++)
    if (*argv[cnt] == '-')
      rargs[rargc++] = strsave(argv[cnt]);
    else
      {
        if (parse_address(argv[cnt]) == NULL)
          {
#ifdef DEBUG
            (void) printf("Argument %d (receiver %d) in fidomailer: %s\n",
                          fargc, frec + 1, argv[cnt]);
#endif DEBUG
            fargs[fargc++] = strsave(argv[cnt]);
            frec++;
          }
        else
          {
#ifdef DEBUG
            (void) printf("Argument %d (receiver %d) in rmail: %s\n",
                          rargc, rrec + 1, argv[cnt]);
#endif DEBUG
            rargs[rargc++] = strsave(argv[cnt]);
            rrec++;
          }
      }
  
  /* NULL terminate arument lists */
  rargs[rargc] = NULL;
  fargs[fargc] = NULL;
  
  /* If there is mail only to rmail or fidomail, execute that mailer
     with our original argument list. */
  
  if (!frec)
    {
#ifdef DEBUG
      (void) printf("No mail to fidonet, executing %s\n", RMAIL);
#endif DEBUG
      (void) execvp(RMAIL, argv);
      perror(RMAIL);
      exit(1);
    }
  else
    if (!rrec)
      {
#ifdef DEBUG
        (void) printf("No mail to UUCP, executing %s\n", FIDOMAILER);
#endif DEBUG
        (void) execvp(FIDOMAILER, argv);
        perror(FIDOMAILER);
        exit(1);
      }
    else
      {
        
        /* There's mail to both fidonet and usenet. We'll have to open
           both mailers and feed this letter to them at the same time.
           This is quite risky: If one of the mailer's exits for any
           reason, we will get SIGPIPE and we'll fall down.... if that
           happens, the other mailer got incomplete letter. */
        
        int rmail_pid, fmail_pid;
        register FILE *rmail = open_mailer(RMAIL, rargs, &rmail_pid),
        register FILE *fmail = open_mailer(FIDOMAILER, fargs, &fmail_pid);
        char buffer[BUFSIZ];
        int stat_loc, pid;
        
#ifdef DEBUG
        (void) printf("Mail both to fidonet and UUCP\n");
#endif DEBUG
        while (fgets(buffer, BUFSIZ, stdin))
          {
            (void) fputs(buffer, rmail);
            (void) fputs(buffer, fmail);
          }
        (void) fclose(rmail);
        (void) fclose(fmail);
        
        /* We should wait for both mailers to exit and check their exit
           statuses. Then we should decide which one we'll should return,
           in this case let's return status from rmail, if other than
           EX_OK, otherwise from fidomail. */
        
        while ((pid = wait(&stat_loc)) != -1)
          if (pid == rmail_pid)
            {
              if ((stat_loc & 0377) == 0)
                status = stat_loc >> 8;
            }
          else
            if (pid == fmail_pid)
              {
                if ((stat_loc & 0377) == 0 && status == EX_OK)
                  status = stat_loc >> 8;
              }
      }
#endif GATEWAY
  
  exit(status);
  /* NOTREACHED */
}
