#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif lint

/* Read mail from standard input and put it into spool-directory.
   Usually this program is executed by our rmail, but it can be
   excuted manually or put as external fidomailer. If our rmail is
   not used (or some other modified rmail), mail from other UUCP
   node can not be sent to fidonet, because (normally) the other
   node sends mail in this site by using rmail.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/types.h>
#include <time.h>
#include <varargs.h>
#include "config.h"
#include "fnet.h"
#include "nodelist.h"

extern struct passwd *getpwuid();
extern char *mktemp();
extern int getopt();
extern char *optarg;
extern int optind;
extern void exit();
extern char *spoolfile(), *basename();
extern char *regex();
extern time_t time();
extern FILE *popen();
extern int errno;
extern char *sys_errlist[];

/* verbosity */
int verbose = 0;

/* non-private mail */
bool public = False;

/* version of rfmail */
char *version = "%I%";

/* Our net/node information */
Node this;

/* Extract address from Reply-To or From field. Possible formats are:
   - Full Name <address>
   - address (Full Name)
   - address */

void
get_address(field, address)
     char *field, *address;
{
  register char *cp, *np;
  
  /* strip possible newline */
  if (cp = strchr(field, '\n'))
    *cp = 0;
  
  if ((cp = strchr(field, '(')) && strchr(cp + 1, ')'))
    {
      /* format is 'address (full name)' */
      for (np = field; np < cp - 1; np++)
        *address++ = *np;
      *address = 0;
    }
  else
    if ((cp = strchr(field, '<')) && (np = strchr(cp + 1, '>')))
      {
        /* format is 'full name <address>' */
        while (cp < np)
          *address++ = *cp++;
        *address = 0;
      }
    else
      /* line contains only address */
      (void) strcpy(address, field);
}

/* Get return address from mail. Extract it from Reply-To: of From:
   fields. */

void
get_return_address(mail, address)
     FILE *mail;
     char *address;
{
  char buffer[BUFSIZ];
  
  *address = 0;
  
  /* check is there is Reply-To: field */
  (void) rewind(mail);
  while (fgets(buffer, BUFSIZ, mail) && *buffer != '\n')
    if (!strncmp(buffer, "Reply-To: ", 10))
      {
        get_address(buffer + 10, address);
        return;
      }
  
  /* no Reply-To:, check for From: */
  (void) rewind(mail);
  while (fgets(buffer, BUFSIZ, mail) && *buffer != '\n')
    if (!strncmp(buffer, "From: ", 6))
      {
        get_address(buffer + 6, address);
        return;
      }
  
  /* not found, send it to uucp */
  (void) strcpy(address, "uucp");
}

/* Send mail back to sender. If Reply-To: of From:-field is present,
   we'll use address specified in that, otherwise we will not return
   mail (it also should be able to parse From_ fields). First argument
   is file containing this mail, others are for vprintf(3S) to be used
   as transcript. */

/* VARARGS */
void
sendback(va_alist)
     va_dcl
{
  va_list args;
  FILE *mail;

#ifdef RETURN_FAILED_MAIL
  FILE *mailer;
  char *fmt, buffer[BUFSIZ];
  char to[128];
#endif /* RETURN_FAILED_MAIL */

  va_start(args);
  mail = va_arg(args, FILE *);
  fmt = va_arg(args, char *);
  
#ifdef RETURN_FAILED_MAIL
  get_return_address(mail, to);
  log("Mail failed, return to %s", to);
  
  /* generate shell command and open it */
  (void) sprintf(buffer, "exec %s %s", RMAIL, to);
  if (mailer = popen(buffer, "w"))
    {
      /* print correct header for mailer */
      (void) fprintf(mailer, "From %d!MAILER-DAEMON %s remote from %d\n",
                     this.node, date("%a %h %d %T 19%y", (long *) 0),
                     this.net);
      (void) fprintf(mailer, "Received: by %d.%d.fidonet (rfmail%s/%s)\n",
                     this.node, this.net, version, this.name);
      (void) fprintf(mailer, "\tid AA%05d; %s\n", getpid(),
                     date("%a, %d %h %y %T %o (%z)", (long *) 0));
      (void) fprintf(mailer, "Date: %s\n", date("%a, %d %h %y %T %o",
                                                (long *) 0));
      (void) fprintf(mailer, "From: FidoNet Mail <%s@%d.%d.%s>\n",
                     "MAILER-DAEMON", this.node, this.net, "fidonet");
      (void) fprintf(mailer, "Subject: Returned mail: %s\n",
                     "Unable to deliver mail to FidoNet");
      (void) fprintf(mailer, "Message-Id: <%s.AA%05d@%d.%d.fidonet>\n",
                     date("%y%m%q%H%M", (long *) 0), getpid(), this.node,
                     this.net);
      (void) fprintf(mailer, "To: %s\n", to);
      (void) fprintf(mailer, "\n");
      (void) fprintf(mailer, "  ----- Transcript of session follows -----\n");
      (void) vfprintf(mailer, fmt, args);
      (void) fprintf(mailer, "\n\n");
      (void) fprintf(mailer, "  ----- Unsent message follows -----\n");
      
      /* now copy the message to mailer */
      (void) rewind(mail);
      while (fgets(buffer, BUFSIZ, mail))
        (void) fputs(buffer, mailer);
      
      /* mail is now sent, close mailer */
      (void) pclose(mailer);
    }
  else
    log("$Unable to invoke mailer for returned mail");
#else /* not RETURN_FAILED_MAIL */
  /* get dummy mail-file pointer */
  mail = va_arg(args, FILE*);
  fmt = va_arg(args, char *);

  /* just print error to stderr, sendmail will return mail to sender
     due to non-zero exit code. */
  (void) vfprintf(stderr, fmt, args);
#endif /* not RETURN_FAILED_MAIL */
  
  va_end(args);
}

/* Check that net/node exists and mail can be send to there (ie. it
   is not down or in hold). Also be will replace name with sysop's name,
   if mail is for sysop (note that alias will override this sysop-name).
   Mail will be send back to sender, if this checking fails. */

int
valid_netnode(name, net, node, mail)
     char *name;
     int net, node;
     FILE *mail;
{
  Node *entry;
  
  if (entry = node_entry(net, node))
    switch (entry->type)
      {
      case HOLD:
        /* node is in hold */
        sendback(mail, "Node %d/%d is in hold", net, node);
        return EX_NOHOST;
      case DOWN:
        /* node is down */
        sendback(mail, "Node %d/%d is currently down", net, node);
        return EX_NOHOST;
      default:
        /* everything was fine */
        if (!strcmp(name, "sysop") || !strcmp(name, "Sysop"))
          (void) strcpy(name, entry->sysop);
        return EX_OK;
      }
  
  /* we didn't find node */
  sendback(mail, "Node %d/%d does not exist", net, node);
  return EX_NOHOST;
}

/* Return sender of mail. Figure it out from From: field or from
   our uid if it's not administrative uid (e.g. uucp or nuucp).
   If neither method works, return NULL. */

char *
sender(mail)
     FILE *mail;
{
  struct passwd *pwd;
  static char name[36];
  char buffer[BUFSIZ];
  register char *cp, *np;
  register int cnt;
  
  (void) rewind(mail);
  while (fgets(buffer, BUFSIZ, mail))
    {
      buffer[strlen(buffer) - 1] = 0; /* strip newline */
      if (!strncmp(buffer, "From: ", 6))
        {
          /* Parse the name out from From: field. there are basically
             two kinds of formats: 'User Name <address>' or
             'address (User Name)'. We'll try to figure it out
             which format sender uses. */
          
          if ((cp = strchr(buffer, '<')) && (np = strchr(cp, '>')))
            {
              /* Format is 'From: Name <address>' */
              for (np = buffer + 6, cnt = 0; np < cp - 1 && cnt < 35;
                   np++, cnt++)
                name[cnt] = *np;
              name[cnt] = 0;
              debug(2, "Got sender name %s, fmt name <address>", name);
            }
          else
            if ((cp = strchr(buffer, '(')) && (np = strchr(cp, ')')))
              {
                /* Format is 'From: address (Name)' */
                for (cnt = 0, cp++; cp < np && cnt < 35; cp++, cnt++)
                  name[cnt] = *cp;
                name[cnt] = 0;
                debug(2, "Got sender name %s, fmt address (name)", name);
              }
            else
              {
                /* found nothing reasonable, save whole field */
                (void) strncpy(name, buffer + 6, 35);
                name[35] = 0;
                debug(2, "No format in From:, name %s", name);
              }
          return name;
        }
    }
  
  /* hmm.. no From: field in mail. let's try to figure this problem
     out some other way. If our uid is some user's uid, we'll use
     that uid to show user's name, otherwise we'll return NULL. */
  
  if (getuid() >= USERUID && (pwd = getpwuid(getuid())))
    {
      /* There are two commonly used gecos-formats: So called USG
         format used by System III and System V machines and BSD
         format used by BSD machines. In USG format name is
         sandwitched between '-' and '(' characters and in BSD
         format name is first this in gecos-field up to first comma
         in it. In many machines there's only name in gecos. */
      
      if ((cp = strchr(pwd->pw_gecos, '-')) && (np = strchr(cp, '(')))
        {
          /* USG format 'stuff-name(stuff)' */
          for (cnt = 0, cp++; cnt < 35 && cp < np; cp++, cnt++)
            name[cnt] = *cp;
          name[cnt] = 0;
          debug(3, "Got sender from USG fmt, name %s", name);
        }
      else
        if (cp = strchr(pwd->pw_gecos, ','))
          {
            /* BSD format 'name,stuff...' */
            for (cp = buffer, cnt = 0; cnt < 35 && *cp != ','; cp++, cnt++)
              name[cnt] = *cp;
            name[cnt] = 0;
            debug(3, "Got sender from BSD format, name %s", name);
          }
        else
          if (*pwd->pw_gecos)
            {
              /* non-empty gecos, assume that there's only name */
              (void) strncpy(name, pwd->pw_gecos, 35);
              name[35] = 0;
              debug(3, "No fmt in gecos, name %s");
            }
          else
            {
              /* Lazy administrator or user who want's to be anonymous
                 (or this is some administrative uid with no explanation
                 which)... We'll use only the username. */
              
              (void) strncpy(name, pwd->pw_name, 35);
              /* never heard over 35 char usernames???? I haven't but... */
              name[35] = 0;
              debug(3, "No gecos, name = %s");
            }
      return name;
    }
  
  /* Found nothing reasonable. we could put there path, but it's quite
     complicated to parse it and it's quite often more than 35 characters
     and partial paths are not very informative. Reader can figure
     it out by himself (or herself) and tell sender to use mailer... */
  
  debug(2, "No sender, uid = %d", getuid());
  return (char *) 0;
}

/* Get net/node information from info. If net is missing, return our
   net, if node is missing, return node -1. True is returned, if
   everything went fine, otherwise False. */

bool
getnode(info, net, node)
     char *info;
     int *net, *node;
{
  /* Extract net information if net is present, otherwise
     set net to -1. */
  
  if (strchr(info, '/'))
    {
      for (*net = 0; *info != '/'; info++)
        if (isdigit(*info))
          *net = *net * 10 + *info - '0';
        else
          {
            debug(1, "Invalid character in net '%c' %02x", *info, *info);
            return False;
          }
      info++;
    }
  else
    *net = NET;
  
  /* Exract node information, set to -1 if empty. */
  
  if (*info)
    for (*node = 0; *info; info++)
      if (isdigit(*info))
        *node = *node * 10 + *info - '0';
      else
        {
          debug(1, "Invalid characer in node '%c' %02x", *info, *info);
          return False;
        }
  else
    *node = -1;
  
  debug(2, "Got alias net %d, node %d", *net, *node);
  return True;
}

/* Compare receiver and user in aliasfile. Each line in aliasfile contains
   alias, optional net/node information separated by commas zero or
   more times, white space(s) and rest of the line literally to whom
   mail should be send. Net and node information is format 'net/node'.
   if net is omitted then every net is counted, if node is omitted,
   then all nodes in that net. If net is omitted, slash may be left off.
   
   E.g following are valid aliases:

   tot,504/ Teemu Torma
   foo Foo Bar
   sysop,504/1,504/9 System Operator */

bool
aliascmp(alias, to, net, node)
     char *alias, *to;
     int net, node;
{
  char buffer[BUFSIZ];
  char *cp;
  int anet, anode;
  
  while (*alias && *alias != ',' && !isspace(*alias) && *to)
    if (*alias++ != *to++)
      return False;
  
  if (isspace(*alias)) /* match */
    return True;
  
  if (*alias == ',')
    {
      /* copy alias to buffer and terminate the it after first space */
      (void) strcpy(buffer, alias + 1);
      for (cp = buffer; *cp; cp++)
        if (isspace(*cp))
          {
            *cp = 0;
            break;
          }
      
      /* get net/node information from buffer one at the time */
      for (cp = strtok(buffer, ","); cp; cp = strtok((char *) 0, ","))
        {
          debug(2, "Got net/node '%s'", cp);
          if (getnode(cp, &anet, &anode))
            {
              if (anet == net && (anode == -1 || anode == node))
                return True;
            }
          else
            return False;
        }
    }
  else
    debug(1, "Invalid alias, %c is not ',' or white space", *alias);
  
  return False;
}

/* Return receiver's name. If name is aliased, return it, otherwise
   return receiver's name. */

char *
receiver(to, net, node)
     char *to;
     int net, node;
{
  static char name[36];
  char buffer[BUFSIZ];
  register int cnt;
  register char *cp;
  FILE *fp;
  
  if (fp = fopen(ALIAS, "r"))
    {
      while (fgets(buffer, BUFSIZ, fp))
        {
          buffer[strlen(buffer) - 1] = 0;
          if (*buffer != '#')
            debug(3, "Checking for alias %s", buffer);
          if (*buffer != '#' && aliascmp(buffer, to, net, node))
            {
              /* match, save the alias. */
              for (cp = buffer; *cp && !isspace(*cp); cp++)
                /* skip alias itself */;
              while (isspace(*cp))
                cp++;
              if (*cp)
                {
                  for (cnt = 0; *cp && cnt < 35; cnt++, cp++)
                    name[cnt] = *cp;
                  name[cnt] = 0;
                  debug(2, "Got alias %s", name);
                  return name;
                }
              else
                debug(1, "Missing alias");
            }
        }
      (void) fclose(fp);
    }
  else
    log("$Unable to open aliasfile %s", ALIAS);
  
  /* Alias not found. Return the the original receiver with all
     _-characters replaced by space and all words calitalized. */
  
  for (cp = NULL, cnt = 0; *to && cnt < 35; cnt++, cp = to++)
    {
      if (*to == '_')
        name[cnt] = ' ';
      else
        if (!cp || *cp == '_' || *to == ' ')
          name[cnt] = toupper(*to);
        else
          name[cnt] = tolower(*to);
    }
  name[cnt] = 0;
  debug(2, "No alias, name %s", name);
  return name;
}

/* Get date from mail. Look for Date: field, if present and time is in
   correct format (same than ARPA-net mail uses), it will be used, otherwise
   current time will be taken. */

char *
getdate(fp)
     FILE *fp;
{
  static char timebuf[20];
  char wday[4], month[4];
  int mday, year, hour, min;
  char buffer[BUFSIZ];
  
  (void) rewind(fp);
  while (fgets(buffer, BUFSIZ, fp))
    /* did we find Date: */
    if (!strncmp(buffer, "Date: ", 6))
      {
        /* try to extract date and other information from it */
        debug(2, "Found date: '%s'", buffer + 6);
        if (sscanf(buffer + 6, "%3s, %2d %3s %2d %2d:%2d:%*2d %*s", wday,
                   &mday, month, &year, &hour, &min) == 6)
          {
            debug(2, "Correct date format");
            /* save date in SEAdog format */
            (void) sprintf(timebuf, "%3s %2d %3s %2d %02d:%02d",
                           wday, mday, month, year, hour, min);
            return timebuf;
          }
      }
  
  (void) rewind(fp);
  debug(2, "No Date: field in mail");
  
  /* we did not found Date: field, let's use current time */
  return date("%a %d %h %y %T", (long *) NULL);
}

/* Send mail from filepoiner fp to user to. To is in format of
   net!node!receiver, where net and node are destnation and
   receiver is receivers name in which blankos are replaces by
   _-characters or alias. */

int
sendmail(fp, to)
     FILE *fp;
     char *to;
{
  char buffer[BUFSIZ], *cp;
  FILE *sf;
  char *sfile;
  char hostname[10];
  int net, node;
  char name[36];
  int status;

  (void) gethostname(hostname, 10);
  
  /* get receiver and net/node */
  if (cp = parse_address(to, name, &net, &node))
    {
      sendback(fp, "Parse failed: %s", cp);
      return EX_NOHOST;
    }
  
  debug(1, "Sending mail to %s at %d/%d", name, net, node);
  
  if ((status = valid_netnode(name, net, node, fp)) != EX_OK)
    return status;
  
  if (sf = fopen(sfile = spoolfile("M."), "w"))
    {
      /* set correct permissions for spoolfile and lock it */
      (void) chmod(sfile, 0600);
      (void) lock(fileno(sf));
      
      /* save net and node information */
      (void) fprintf(sf, "N %d %d\n", net, node);
      
      /* save receiver */
      (void) fprintf(sf, "T %s\n", receiver(name, net, node));
      
      /* save sender ... */
      (void) fprintf(sf, "F %s\n", (cp = sender(fp)) ? cp : "Usenet");
      
      /* try to find subject ... */
      (void) rewind(fp);
      while (fgets(buffer, BUFSIZ, fp))
        if (!strncmp("Subject: ", buffer, 9))
          {
            (void) fprintf(sf, "S %s", buffer + 9);
            buffer[strlen(buffer) - 1] = 0;
            debug(2, "Subject: %s", buffer + 9);
            break;
          }
      if (feof(fp))
        /* we didn't find subject.. */
        (void) fprintf(sf, "S Mail from Usenet\n");
      
      /* save date */
      (void) fprintf(sf, "D %s\n", getdate(fp));
      
      /* if not public, mark that message is private */
      if (!public)
        (void) fprintf(sf, "P \n");
      
      /* done with header information, now we'll copy the hole mail
         after the header */
      
      (void) putc('\n', sf);
      
      debug(2, "Copying mail");
      
      /* Now copy mail, also add Received field to mail */
      (void) rewind(fp);
      while (fgets(buffer, BUFSIZ, fp) && (!strncmp(buffer, "From ", 5) ||
                                           !strncmp(buffer, ">From ", 6)))
        (void) fputs(buffer, sf);
      (void) fprintf(sf, "Received: from %s%s by %d.%d.fidonet (%s%s/%s)\n",
                     hostname, DOMAIN, this.node, this.net, "rfmail",
                     version, this.name);
      (void) fprintf(sf, "\tid AA%05d; %s\n", getpid(),
                     date("%a, %d %h %y %T %o (%z)", (long *) NULL));
      for (fputs(buffer, sf); fgets(buffer, BUFSIZ, fp); fputs(buffer, sf));

      /* done. */
      (void) fclose(sf);
      return EX_OK;
    }
  else
    {
      log("$Unable to open spoolfile");
      return EX_CANTCREAT;
    }
  /* NOTREACHED */
}

/*ARGSUSED*/
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  int cnt, c;
  FILE *mail;
  char buffer[BUFSIZ], tmpf[L_tmpnam];
  int status = EX_OK;
  char *error;
  Node *node;
  
  while ((c = getopt(argc, argv, "pvV:")) != EOF)
    switch (c)
      {
      case 'v':
        /* set more verbosity */
        verbose++;
        break;
      case 'V':
        /* allow version on command line only if test version. */
        if (*version != '%' || version[1] != 'I' || version[2] != '%')
          version = optarg;
        /* NOTE: Comparison cannot be with strcmp, because SCCS would also
           change that comparison string. */
        break;
      case 'p':
        /* this is not private message */
        public = True;
        break;
      default:
        (void) fprintf(stderr, "See manual page.\n", *argv);
        exit(EX_USAGE);
      }
  
  /* create name of temporary mail-message */
  (void) strcpy(tmpf, P_tmpdir);
  (void) strcat(tmpf, mktemp("rfm.XXXXXX"));
  
  /* open mail-temp */
  if (mail = fopen(tmpf, "w+"))
    {
      /* protect mail file */
      (void) chmod(tmpf, 0600);
      
      /* copy mail to temp-file */
      while (fgets(buffer, BUFSIZ, stdin))
        (void) fputs(buffer, mail);
      
      /* update nodelist-index if needed */
      if (error = update_index())
        {
          /* there was error while updating nodelist-index */
          if (*error == '$')
            sendback(mail, "%s: %s", error + 1, sys_errlist[eno]);
          else
            sendback(mail, "%s", error);
          exit(EX_SOFTWARE);
        }

      if ((node = node_entry(NET, NODE)) == NULL)
        {
          (void) fprintf(stderr, "Unable to this node from nodelist\n");
          log("No %d/%d in nodelist", NET, NODE);
          exit(EX_SOFTWARE);
        }
      this = *node;
  
      
      /* send mail to all user's */
      for (rewind(mail), cnt = optind; cnt < argc; rewind(mail), cnt++)
          /* send mail */
          if ((status = sendmail(mail, argv[cnt])) != EX_OK)
            break;
      
      /* remove temporary file */
      (void) fclose(mail);
      (void) unlink(tmpf);
    }
  else
    {
      /* opening tmp-file failed, we can't even send mail back */
      log("$Can not open %s for writing", tmpf);
      exit(EX_CANTCREAT);
    }
  
  exit(status);
  /*NOTREACHED*/
}
