#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Get host name. This emulates routine with same name in BSD-Unix.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <sys/utsname.h>
#include <string.h>

/* Get name of this uucp-node. Name is stored in buffer. Len in maximum
   length of buffer. Return -1 if can not do uname(2), otherwise 0. */

int
gethostname(buffer, len)
     char *buffer;
     int len;
{
  struct utsname name;
  
  if (uname(&name) == -1)
    return -1;
  (void) strncpy(buffer, name.nodename, len);
  buffer[len - 1] = 0;
  return 0;
}
