#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Create and update fidomail packets. Read mail messages from
   spool directory and append them to packet. If packet doesn't
   exist already, it will be created. Packet name in P.net-node.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <time.h>
#include <sys/stat.h>
#include <ndir.h>
#include "config.h"
#include "fnet.h"
#include "fpack.h"

extern time_t time();
extern int getopt();
extern int optind;
extern char *optarg;
extern uint sleep();
extern void exit();
extern void swab();

int net = -1, node = -1;
int verbose = 0;

/* Return True if string is numeric. */

bool
numeric(s)
     register char *s;
{
  while (*s)
    if (!isdigit(*s++))
      return False;
  return True;
}

/* Return argument as 16 bit interger to msdos */

INT16
int16(val)
     int value;
{
  INT16 msint, mval = (INT16) value;
  
#ifdef SWAB_BYTES
  swab((char *) &mval, (char *) &msint, 2);
#else !SWAB_BYTES
  msint = mval;
#endif !SWAB_BYTES
  return msint;
}

/* Put string to file in null-terminated format. */

void
put_string(fp, s)
     FILE *fp;
     char *s;
{
  while (*s)
    {
      (void) putc(*s, fp);
      s++;
    }
  (void) putc(0, fp);
}

/* Return date in ascii string that is in fido-format, ie.
   dd mmm yy hh:mm:ss, like 24 Jan 87 06:24:27 */

char
*fido_date(clock)
     time_t clock;
{
  struct tm *tm;
  static char date[20];
  
  /* Literal months */
  static char *months[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
  };
  
  tm = localtime(&clock);
  (void) sprintf(date, "%02d %3s %02d %02d:%02d:%02d", tm->tm_mday,
                 months[tm->tm_mon], tm->tm_year, tm->tm_hour,
                 tm->tm_min, tm->tm_sec);
  return date;
}

/* Write int to file in msdos interger format */

int
write_int(fp, value)
     FILE *fp;
     int value;
{
  INT16 msint = int16(value);
  
  return fwrite((char *) &msint, sizeof(INT16), 1, fp);
}

/* Write fido msg header for mailfile. Mailfile contains first headers
   terminated by empty line, after that comes message text.
   Header consists of one letter id followed by arguments if any.
   
   Id-letters:
   N - net/node information of message, e.g. N 504 8.
   T - to whom message is to, e.g. T Teemu Torma.
   F - from whom message is from, e.g. F Foo Bar.
   S - subject of message, e.g S How are you?.
   P - indicates that message is private. (Here is little conflict:
       rfmail uses option -p to indicate that mail to public and here
       P means that mail is private. Maybe this P should mean that
       mail is public and default is private).
   
   All letters having arguments have only on space after them, and all
   rest of the line is considered to be that argument. */

bool
write_hdr(source, packet)
     FILE *source, *packet;
{
  char buffer[BUFSIZ];
  char from[36], to[36], subject[72], date[20];
  int msg_net = -1, msg_node = -1;
  int attr = 0;
  struct stat stbuf;
  
  /* clean up from, to and subject */
  *from = 0;
  *to = 0;
  *subject = 0;
  *date = 0;
  
  while (fgets(buffer, BUFSIZ, source) && *buffer != '\n')
    {
      buffer[strlen(buffer) - 1] = 0; /* strip newline */
      switch (*buffer)
        {
        case 'N':
          if (sscanf(buffer, "%*s %d %d", &msg_net, &msg_node) != 2)
            {
              log("Invalid destination: %s", buffer);
              return False;
            }
          break;
        case 'F':
          (void) strncpy(from, buffer + 2, 35);
          from[35] = 0;
          break;
        case 'T':
          (void) strncpy(to, buffer + 2, 35);
          to[35] = 0;
          break;
        case 'S':
          (void) strncpy(subject, buffer + 2, 71);
          subject[71] = 0;
          break;
        case 'D':
          (void) strncpy(date, buffer + 2, 19);
          date[19] = 0;
          break;
        case 'P':
          attr |= ATTR_PRIVATE;
          break;
        }
    }
  
  /* check if net/node was missing */
  if (msg_net == -1 || msg_node == -1)
    {
      log("Message with no destination");
      return False;
    }
  
  /* we must have also receiver */
  if (!*to)
    {
      log("Missing receiver in mail header");
      return False;
    }
  
  /* if from is missing, we'll improvise...*/
  if (!*from)
    {
      log("Missing from is header");
      (void) strcpy(from, "Usenet");
    }
  
  /* if subject is missing, let's put there something */
  if (!*subject)
    {
      log("Missing subject in header");
      (void) strcpy(subject, "Mail from Usenet");
    }
  
  /* if date is missing, put there current date */
  if (!*date)
    {
      log("Missing date in header");
      (void) strcpy(date, fido_date(time((long *) 0)));
    }
  
  /* save all header values */
  (void) write_int(packet, MSGTYPE); /* save msg type */
  (void) write_int(packet, NODE); /* save our node */
  (void) write_int(packet, msg_node); /* save messages node */
  (void) write_int(packet, NET); /* save our net */
  (void) write_int(packet, msg_net); /* save messages net */
  (void) write_int(packet, attr); /* save attributes */
  (void) write_int(packet, 0); /* cost, not used by us */
  put_string(packet, date); /* save time of mail */
  put_string(packet, to); /* save receiver */
  put_string(packet, from); /* save sender */
  put_string(packet, subject); /* save subject */
  
  /* get status of mailfile and log this message */
  if (fstat(fileno(source), &stbuf) == -1)
    log("Unable to get stat of msg");
  
  log("Msg from %s to %s at %d/%d packetized (%ld chars)", from, to,
      msg_net, msg_node, stbuf.st_size - ftell(source));
  
  /* done with this header */
  return True;
}

/* Write packet header for new packet. */

bool
write_pkthdr(packet)
     FILE *packet;
{
  Packet header;
  struct tm *tm;
  time_t clock = time((long *) 0);
  
  tm = localtime(&clock);
  
  /* create packet structure */
  header.orig_node = int16(NODE);
  header.dest_node = int16(node);
  header.orig_net = int16(NET);
  header.dest_net = int16(net);
  
  /* save time for header (why all these fields?) */
  header.year = int16(tm->tm_year + 1900);
  header.month = int16(tm->tm_mon);
  header.day = int16(tm->tm_mday);
  header.hour = int16(tm->tm_hour + 1);
  header.minute = int16(tm->tm_min);
  header.second = int16(tm->tm_sec);
  
  header.rate = 0;
  header.ver = int16(HDRVER);
  
  /* write header to file */
  if (fwrite((char *) &header, sizeof(Packet), 1, packet) != 1)
    {
      log("$Write error on packet header");
      return False;
    }
  
  debug(1, "New packet created");
  
  return True;
}

/*ARGSUSED*/
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  DIR *dp;
  struct direct *dir;
  FILE *msg, *packet;
  char packet_name[16];
  int c;
  
  /* get options */
  while ((c = getopt(argc, argv, "vn:")) != EOF)
    switch (c)
      {
      case 'n':
        if (numeric(optarg))
          {
            net = atoi(optarg);
            if (optind < argc)
              if (numeric(argv[optind]))
                node = atoi(argv[optind++]);
              else
                {
                  log("Non numeric node: '%s'", argv[optind]);
                  exit(1);
                }
            else
              {
                log("Missing node");
                exit(1);
              }
          }
        else
          {
            log("Non numeric net: '%s'", optarg);
            exit(1);
          }
        break;
      case 'v':
        verbose++;
        break;
      default:
        (void) fprintf(stderr, "Usage: %s [-v] -n net node\n", *argv);
        exit(1);
      }
  
  /* make sure that we got net/node */
  if (net == -1 || node == -1)
    {
      log("Missing net/node in command line");
      exit(1);
    }
  
  /* goto spool directory, everything exiting happens there... */
  if (chdir(SPOOL) == -1)
    {
      log("$Can not chdir to %s", SPOOL);
      exit(1);
    }
  
  /* create packet name */
  (void) sprintf(packet_name, "P.%d-%d", net, node);
  
  if (access(packet_name, 0) == 0) {
    debug(1, "Packet %s exists, append to it", packet_name);
    if ((packet = fopen(packet_name, "r+")) == NULL)
      {
        log("$Can not open %s for update", packet_name);
        exit(1);
      }
    (void) fseek(packet, -2l, 2);
  }
  else {
    debug(1, "New packet %s", packet_name);
    if ((packet = fopen(packet_name, "w")) == NULL)
      {
        log("$Can not open packet %s for writing", packet_name);
        exit(1);
      }
    
    /* protect packet from users...*/
    (void) chmod(packet_name, 0600);
    
    /* write packet-header, if it fails, exit */
    if (!write_pkthdr(packet))
      {
        (void) unlink(packet_name);
        exit(1);
      }
  }
  
  /* lock packet, wait if it's alredy locked */
  while (lock(fileno(packet)) == -1 && errno == EAGAIN)
    (void) sleep((unsigned) 1);
  
  /* open spool directory */
  if (dp = opendir("."))
    {
      while (dir = readdir(dp))
        {
          /* check that file is for us */
          if (*dir->d_name == 'M' && dir->d_name[1] == '.')
            {
              if (msg = fopen(dir->d_name, "r"))
                {
                  debug(1, "Adding mailfile %s", dir->d_name);
                  
                  /* save header */
                  if (write_hdr(msg, packet))
                    {
                      /* copy mail text, replace newlines with <cr> <lf> */
                      while ((c = getc(msg)) && c != EOF)
                        {
                          if (c == '\n')
                            (void) putc('\r', packet);
                          (void) putc(c, packet);
                        }
                      /* null-terminate msg text */
                      (void) putc(0, packet);
                    }
                  (void) fclose(msg);
                  if (unlink(dir->d_name) == -1)
                    log("$Unable to unlink %s", dir->d_name);
                }
              else
                log("$Can not open mail %s for reading", dir->d_name);
            }
        }
      (void) closedir(dp);
    }
  else
    {
      log("$Can not open spool directory %s", SPOOL);
      exit(1);
    }
  
  /* msg type 0 indicates end of packet */
  (void) write_int(packet, 0);
  
  (void) fclose(packet);
  
  exit(0);
  /* NOTREACHED */
}
