/* demonstration of _cset */

#include "cset.h"

OPTIONS
{  "DEMO",   COMM_KWD, "a command name",
   "Tesco",  COMM_KWD, "another command name",
   "String", SVAL_KWD, "an arbitrary string",
   "Number", NVAL_KWD, "a number, base 8, 10 or 16",
   "Tabs",   MVAL_KWD, "list of tab stops",
   "Wide",   PLUS_KWD, "turn an option on",
   "Multi",  PLUS_KWD | DASH_KWD | BLNK_KWD, "option may be +, - or plain string",
   "Hidden", HIDE_KWD | NVAL_KWD | 19, "hidden numeric base 19 argument!",
   OPT_HELP(OPT_EXEC, "more README")
};

#define STRING	0
#define	DEMO	1
#define	TESCO	(DEMO+1)
#define STR	(TESCO+1)
#define NUM	(STR+1)
#define TABS	(NUM+1)
#define WIDE	(TABS+1)
#define MULTI	(WIDE+1)
#define HID	(MULTI+1)

/* I'm sure I should be able to do this in one go..., but the compiler barfs */
char *d1[] = {"demo", "st=asda", (char *)0};
char *d2[] = {"demo", "tesco", "num=0xd", "l=57", "+g", (char *)0};
char *d3[] = {"tesco", "+w", "-mu", "+mt", "muti", (char *)0};
char *d4[] = {"demo", "h=beef t=09,9,0x9", (char *)0};
char *d5[] = {"demo", "==", (char *)0};
char *d6[] = {"demo", "=hi", "=+", "=#", (char *)0};

char **Demos[] =
{  d1, d2, d3, d4, d5, d6,
   (char **)0
};

execute(cmd, args)
char *cmd, **args;
{  if( fork() )
      wait(0);
   else
      execv(cmd, args);
};

main(argc, argv) char **argv;
{  _opt_desc *parsed;
   char ***dp, **cmd;
   int *p, num;

   if(argc <= 1)
   {  /* no arguments, do demos */
      dp = Demos;
      while(*dp != (char **)0)
      {  printf("\n************************\nExecuting:");
         cmd = *dp;
         while(*cmd != (char *)0) printf(" %s", *cmd++);
         printf("\nGives:\n\n");
	 execute("./demo", *dp++);
      }
      return;
   }

   parsed = _cset(argv, 1);

   while( parsed->_opt_num != -1 )
   {  switch( parsed->_opt_num ) 
      {  case STRING:
     	    printf("Arbitrary string option: %s\n", parsed->_opt.sval); break;
         case DEMO:
   	    break;
         case TESCO:
   	    printf("Called using alternative command name \"tesco\"\n"); break;
         case NUM:
   	    printf("Numeric value: 0%o, %d, 0x%x\n", parsed->_opt.nval, parsed->_opt.nval, parsed->_opt.nval); break;
         case STR:
   	    printf("String valued option: %s\n", parsed->_opt.sval); break;
         case HID:
   	    printf("Hidden keyword, number input in base 19 = %d in decimal\n", parsed->_opt.nval);
         case MULTI:
   	    printf("Option may be +, - or blank, this time it was: '%c'\n", parsed->_opt_type);
   	    break;
         case WIDE:
   	    printf("Wide option turned on\n"); break;
         case TABS:
   	    p = parsed->_opt.mval;
   	    printf("Muliple numeric valued keyword with %d values:", (num = *p++));
            while(num--) printf(" %d", *p++);
   	    printf("\n");
   	    break;
	 default:	/* out of range - looks like an option but didn't match */
   	    printf("Unknown option: %s\n", parsed->_opt.sval );

      }
      parsed++;
   }
}
   
