/*
	CxPhas -- phase (angle, argument) of a complex

	CxPhas( &c )	returns  arg(c)  in radians (-Pi,Pi]

	last edit:	86/01/04	D A Gwyn

	SCCS ID:	@(#)cxphas.c	1.1 (modified for public version)
*/

#include	<math.h>

#include	<complex.h>

double
CxPhas( cp )
	register complex	*cp;
	{
	if ( cp->re == 0.0 && cp->im == 0.0 )
		return 0.0;		/* can't trust atan2() */
	else
		return atan2( cp->im, cp->re );
	}
