/*
	CxDiv -- divide one complex by another

	CxDiv( &a, &b )	divides  a  by  b  and returns  &a;
			zero divisor fails

	last edit:	86/01/04	D A Gwyn

	SCCS ID:	@(#)cxdiv.c	1.1 (modified for public version)
*/

#include	<complex.h>

#define Abs( x )	((x) < 0 ? -(x) : (x))

complex *
CxDiv( ap, bp )
	register complex	*ap, *bp;	/* may coincide (?) */
	{
	double	r, s;
	double	ap__re = ap->re;

	/* Note: classical formula may cause unnecessary overflow */
	r = bp->re;
	s = bp->im;
	if ( Abs( r ) >= Abs( s ) )
		{
		r = s / r;		/* <= 1 */
		s = bp->re + r * s;
		ap->re = (ap->re + ap->im * r) / s;
		ap->im = (ap->im - ap__re * r) / s;
		}
	else /* Abs( s ) > Abs( r ) */
		{
		r = r / s;		/* < 1 */
		s = s + r * bp->re;
		ap->re = (ap->re * r + ap->im) / s;
		ap->im = (ap->im * r - ap__re) / s;
		}

	return ap;
	}
