/* pbmcatlr.c - concatenate portable bitmaps left to right
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

#define MAXFILES 100

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd[MAXFILES];
    bit **bits[MAXFILES], **newbits, background;
    int argn, backdefault, nfiles, i, c;
    int rows[MAXFILES], cols[MAXFILES], row, col;
    int newrows, newcols, newcol, padtop;
    char *usage = "usage:  %s [-0] [-1] pbmfile pbmfile ...\n";

    argn = 1;
    backdefault = 1;

    /* Check for flags. */
    if ( argc > argn )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( strcmp( argv[argn], "-0" ) == 0 )
		{
		backdefault = 0;
		background = 0;
		argn++;
		}
	    else if ( strcmp( argv[argn], "-1" ) == 0 )
		{
		backdefault = 0;
		background = 1;
		argn++;
		}
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    }
	}

    if ( argc > argn )
	{
	nfiles = argc - argn;
	for ( i = 0; i < nfiles; i++ )
	    {
	    if ( strcmp( argv[argn+i], "-" ) == 0 )
		ifd[i] = stdin;
	    else
		{
		ifd[i] = fopen( argv[argn+i], "r" );
		if ( ifd[i] == NULL )
		    {
		    fprintf( stderr, "%s: can't open.\n", argv[argn+i] );
		    exit( 1 );
		    }
		}
	    }
	}
    else
	{
	nfiles = 1;
	ifd[0] = stdin;
	}

    newcols = 0;
    newrows = 0;
    for ( i = 0; i < nfiles; i++ )
	{
	bits[i] = pbm_readpbm( ifd[i], &cols[i], &rows[i] );
	if ( ifd[i] != stdin )
	    fclose( ifd[i] );
	newcols += cols[i];
	if ( rows[i] > newrows )
	    newrows = rows[i];
	}

    newbits = pbm_allocarray( newcols, newrows );

    newcol = 0;

    for ( i = 0; i < nfiles; i++ )
	{
	if ( backdefault )
	    {
	    /* Make a reasonable guess as to what the background is. */
	    c = (int) bits[i][0][0] + (int) bits[i][0][cols[i]-1] +
		(int) bits[i][rows[i]-1][0] +
		(int) bits[i][rows[i]-1][cols[i]-1];
	    background = ( c <= 2 ) ? 0 : 1;
	    }

	padtop = (newrows - rows[i]) / 2;

	for ( col = 0; col <= cols[i]; col++ )
	    {
	    for ( row = 0; row < padtop; row++ )
		newbits[row][newcol+col] = background;
	    for ( row = 0; row < rows[i]; row++ )
		newbits[padtop+row][newcol+col] = bits[i][row][col];
	    for ( row = padtop+rows[i]; row < newrows; row++ )
		newbits[row][newcol+col] = background;
	    }

	newcol += cols[i];
	}

    pbm_writepbm( stdout, newbits, newcols, newrows );

    exit( 0 );
    }
