/* icontopbm.c - read a Sun icon file and produce a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <sys/types.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, row, col, shortcount, mask;
    short *data;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage: %s [iconfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
	ifd = fopen( argv[1], "r" );
	if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    if ( ReadIconFile( ifd, &cols, &rows, &data ) < 0 )
	{
	fprintf( stderr, "%s: can't load.\n", argv[1] );
	exit( 1 );
	}

    if ( ifd != stdin )
	fclose( ifd );

    bits = pbm_allocarray( cols, rows );

    for ( row = 0; row < rows; row++ )
	{
	shortcount = 0;
	mask = 0x8000;
	for ( col = 0; col < cols; col++ )
	    {
	    if ( shortcount >= 16 )
		{
		data++;
		shortcount = 0;
		mask = 0x8000;
		}
	    bits[row][col] = ( ( *data & mask ) ? 1 : 0 );
	    shortcount++;
	    mask = mask >> 1;
	    }
	data++;
	}

    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }


/* size in bytes of a bitmap */
#define BitmapSize(width, height) (((((width) + 15) >> 3) &~ 1) * (height))

int
ReadIconFile( file, width, height, data )
FILE *file;
int *width, *height;
short **data;
    {
    char variable[81], ch;
    int status, firsttime, value, i, data_length;

    if ( file == NULL )
    	return ( -1 );

    if ( getc( file ) != '/' )
	{
	fprintf( stderr, "Error 1 scanning beginning of initial section.\n" );
	return ( -1 );
	}
    if ( getc( file ) != '*' )
	{
	fprintf( stderr, "Error 2 scanning beginning of initial section.\n" );
	return ( -1 );
	}
    while ( ( ch = getc( file ) ) == '\n' | ch == '\t' | ch == ' ' )
	;
    ungetc( ch, stdin );

    *width = *height = -1;
    firsttime = -1;
    for ( ; ; )
	{
	if ( firsttime )
	    firsttime = 0;
	else
	    if ( getc( file ) != ',' )
		break;
	while ( ( ch = getc( file ) ) == '\n' | ch == '\t' | ch == ' ' )
	    ;
	for ( i = 0; ch != '='; i++ )
	    {
	    variable[i] = ch;
	    ch = getc( file );
	    }
	variable[i] = '\0';

	if ( fscanf( file, "%d", &value ) != 1 )
	    break;

	if ( strcmp( variable, "Width" ) == 0 )
	    *width = value;
	else if ( strcmp( variable, "Height" ) == 0 )
    	    *height = value;
	else if ( strcmp( variable, "Depth" ) == 0 )
    	    {
	    if ( value != 1 )
		{
		fprintf( stderr, "Invalid depth.\n" );
		return ( -1 );
		}
	    }
	else if ( strcmp( variable, "Format_version" ) == 0 )
    	    {
	    if ( value != 1 )
		{
		fprintf( stderr, "Invalid Format_version.\n" );
		return ( -1 );
		}
	    }
	else if ( strcmp( variable, "Valid_bits_per_item" ) == 0 )
    	    {
	    if ( value != 16 )
		{
		fprintf( stderr, "Invalid Valid_bits_per_item.\n" );
		return ( -1 );
		}
	    }
	}

    for ( ; ; )
	{
	while ( getc( file ) != '*' )
	    ;
	if ( ( ch = getc( file ) ) == '/' )
	    break;
	ungetc( ch, stdin );
	}
    if ( getc( file ) != '\n' )
	{
	fprintf( stderr, "Error 3 scanning end of initial section.\n" );
	return ( -1 );
	}

    if ( *width <= 0 )
	{
	fprintf( stderr, "Invalid width: %d.\n", *width );
	return ( -1 );
	}
	
    if ( *height <= 0 )
	{
	fprintf( stderr, "Invalid height: %d.\n", *height );
	return ( -1 );
	}

    data_length = BitmapSize( *width, *height );
    *data = (short *) malloc( data_length );
    data_length /= sizeof( short );
    if ( *data == NULL )
        {
    	return ( -1 );
	}
    
    for ( i = 0 ; i < data_length; i++ )
	{
	if ( i == 0 )
	    status = fscanf( file, " 0x%4hx", *data );
	else
	    status = fscanf( file, ", 0x%4hx", *data + i );
	if ( status != 1 )
	    {
	    free( *data );
	    fprintf( stderr, "Error 4 scanning bits item.\n" );
	    return ( -1 );
	    }
    	}

    return ( 0 );
    }
