
/* advprs.c - adventure parser */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
	Improved parser by Boris J. H. Boesler
	Parser version 1.0
*/

#pragma lint -1
#pragma noroot

#if STACKDEBUG
#pragma debug 24
#endif

#if OPTIMIZE
#pragma optimize 9
#endif

/*#include "intproto.h"*/		/* TUU */
#include "interpreter.h"
#include "../shared/dbaccess.h"

/*
#define PROMPT ':'
*/
#define PROMPT '>'

#define MAX_ACTION_ARRAY  20

#ifdef DEBUG
char dbgbuf[256];
#endif

/* parser result variables */
int nouns[20];
int *adjectives[20];
static int actor, action, dobject, ndobjects, iobject;
static int preposition, flag;


/* external variables */
extern char line[];		/* line buffer */

/* local variables */
static char *lptr;		/* line pointer */
static int words[100];	/* word table */
static char *wtext[100];	/* word text table */
static int *wptr;		/* word pointer */
static int wcnt;		/* word count */

static int verbs[3];		/* words in the verb phrase */
static int nnums[20];		/* noun word numbers */
static int nptr;		/* noun pointer (actually, an index) */
static int adjs[100];		/* adjective lists */
static int anums[100];	/* adjective word numbers */
static int aptr;		/* adjective pointer (actually, an index) */

static int noun1, cnt1, noun2, cnt2;
static int word_type;

static int active_state;
static int actionptr = 0;

enum state
{
	S = 0, A, V, C1, DO, C2, P, IO, C3, ERROR, ACCEPT
};

/* parser states */

static int states[9][9] = {
	/*       UNKNOWN  VERB   NOUN    ADJ   PREP   CONJ    ART  LAMBDA*/
	/* S  */ {ERROR,     V,     A,     A, ERROR, ERROR,     A,  ERROR},
	/* A  */ {ERROR,     V, ERROR, ERROR, ERROR, ERROR, ERROR,  ERROR},
	/* V  */ {ERROR, ERROR,    DO,    DO, ERROR,    C1,    DO, ACCEPT},
	/* C1 */ {ERROR,     V, ERROR, ERROR, ERROR, ERROR, ERROR,  ERROR},
	/* DO */ {ERROR, ERROR,    IO,    IO,     P,    C2,    IO, ACCEPT},
	/* C2 */ {ERROR,     V,    DO,    DO, ERROR, ERROR,    DO,  ERROR},
	/* P  */ {ERROR, ERROR,    IO,    IO, ERROR, ERROR,    IO,  ERROR},
	/* IO */ {ERROR, ERROR, ERROR, ERROR, ERROR,    C3, ERROR, ACCEPT},
	/* C3 */ {ERROR,     V,    IO,    IO, ERROR, ERROR,    IO,  ERROR}
};

/* action array */
static int action_actor[MAX_ACTION_ARRAY];
static int action_action[MAX_ACTION_ARRAY];
static int action_dobject[MAX_ACTION_ARRAY];
static int action_ndobjects[MAX_ACTION_ARRAY];
static int action_iobject[MAX_ACTION_ARRAY];


/* parse - read and parse an input line */
int parse(void)
{
	if (!parse1())
		return (FALSE);
	setvalue(V_ACTOR, action_actor[0]);
	setvalue(V_ACTION, action_action[0]);
	setvalue(V_DOBJECT, action_dobject[0]);
	setvalue(V_NDOBJECTS, action_ndobjects[0]);
	setvalue(V_IOBJECT, action_iobject[0]);
#ifdef DEBUG
	sprintf(dbgbuf," parse : actionptr: %d\n", actionptr);
	trm_str(dbgbuf);
	sprintf(dbgbuf," actor %d  action %d  do %d  nd %d  io %d\n",
	       action_actor[0], action_action[0], action_dobject[0],
	       action_ndobjects[0], action_iobject[0]);
	trm_str(dbgbuf);
#endif
	actionptr = 1;
	return (TRUE);
}

/* next - get the next command (next direct object) */
int next(void)
{
	if (action_action[actionptr] != NIL)
	{
		setvalue(V_ACTOR, action_actor[actionptr]);
		setvalue(V_ACTION, action_action[actionptr]);
		setvalue(V_DOBJECT, action_dobject[actionptr]);
		setvalue(V_NDOBJECTS, action_ndobjects[actionptr]);
		setvalue(V_IOBJECT, action_iobject[actionptr]);
#ifdef DEBUG
	sprintf(dbgbuf," next : actionptr: %d\n", actionptr);
	trm_str(dbgbuf);
	sprintf(dbgbuf," actor %d  action %d  do %d  nd %d  io %d\n",
			action_actor[actionptr], action_action[actionptr],
			action_dobject[actionptr],
			action_ndobjects[actionptr], action_iobject[actionptr]);
	trm_str(dbgbuf);
#endif
		++actionptr;
		return (TRUE);
	}
	else
	{
		actionptr = 0;
		action_actor[0] =
			action_action[0] =
			action_dobject[0] =
			action_ndobjects[0] =
			action_iobject[0] = NIL;
#ifdef DEBUG
		trm_str(" next: FALSE\n");
#endif
		return (FALSE);
	}
}

/* fill_action_array - fill array with current action */
int fill_action_array(void)
{
	int i;

#ifdef DEBUG
	trm_str(" fill-action-array\n");
#endif
	/* setup the direct and indirect objects */
	if (preposition)
	{
		if (cnt2 > 1)
		{
			parse_error();
			return (FALSE);
		}
		dobject = noun1;
		ndobjects = cnt1;
		iobject = noun2;
	}
	else if (noun2)
	{
		if (cnt1 > 1)
		{
			parse_error();
			return (FALSE);
		}
		preposition = findword("to");
		dobject = noun2;
		ndobjects = cnt2;
		iobject = noun1;
	}
	else
	{
		dobject = noun1;
		ndobjects = cnt1;
		iobject = NIL;
	}

	/* setup the flags for the action lookup */
	if (dobject)
		flag |= A_DOBJECT;
	if (iobject)
		flag |= A_IOBJECT;

#ifdef DEBUG
	sprintf(dbgbuf," aptr %d  action %d  do %d  nd %d  io %d  pre %d\n",
	   actionptr, action, dobject + i, ndobjects, iobject, preposition);
	trm_str(dbgbuf);
#endif
	/* find the action */
	if ((action = findaction(verbs, preposition, flag)) == NIL)
	{
		parse_error();
		action_action[0] = NIL;
		actionptr = 0;
		return (FALSE);
	}

	/* fill the array */
	i = 0;
	do
	{
#ifdef DEBUG
		sprintf(dbgbuf," aptr %d  action %d  do %d  nd %d  io %d\n",
		       actionptr, action, dobject + i, ndobjects, iobject);
		trm_str(dbgbuf);
#endif
		action_actor[actionptr] = actor;
		action_action[actionptr] = action;
		action_dobject[actionptr] = dobject + i;
		action_ndobjects[actionptr] = ndobjects;
		action_iobject[actionptr] = iobject;
		++i;
		++actionptr;
	} while (i < ndobjects);

	action_actor[actionptr] =
		action_action[actionptr] =
		action_dobject[actionptr] =
		action_ndobjects[actionptr] =
		action_iobject[actionptr] = NIL;

	/* initialize for next command parse */
	noun1 = noun2 = NIL;
	cnt1 = cnt2 = 0;
	/* nptr = aptr = 0;*/ /* This was THE bug */
	preposition = 0;
	flag = 0;

	/* initialize the parser result variables */
	action = dobject = iobject = NIL;
	ndobjects = 0;

#ifdef DEBUG
	trm_str(" fill-action-array ended\n");
#endif
	return (TRUE);
}

/* parse1 - the main parser */
int parse1(void)
{
	/* initialize */
	noun1 = noun2 = NIL;
	cnt1 = cnt2 = 0;
	nptr = aptr = 0;
	preposition = 0;
	flag = 0;

	/* initialize the parser result variables */
	actor = action = dobject = iobject = NIL;
	ndobjects = 0;
	word_type = WT_LAMBDA;
	active_state = S;
	actionptr = 0;

	/* get an input line */
	if (!get_line())
		return (FALSE);


	while (active_state != ERROR && active_state != ACCEPT)
	{
#ifdef DEBUG
		sprintf(dbgbuf," while.. action-state:%d\n", active_state);
		trm_str(dbgbuf);
#endif
		if (*wptr)
			word_type = wtype(*wptr);
		else
			word_type = WT_LAMBDA;

		switch (active_state)
		{

		case S:
			switch (word_type)
			{
			case WT_NOUN:
			case WT_ADJECTIVE:
			case WT_ARTICLE:
				if ((actor = getnoun()) == NIL)
					return (FALSE);
				flag |= A_ACTOR;
				break;

			case WT_VERB:
				if (!getverb())
					return (FALSE);
				break;


			default:
				break;	/* ERROR STATE */
			}
			break;

		case A:
			switch (word_type)
			{
			case WT_VERB:
				if (!getverb())
					return (FALSE);
				break;


			default:
				break;	/* ERROR */
			}
			break;

		case V:
			switch (word_type)
			{
			case WT_NOUN:
			case WT_ADJECTIVE:
			case WT_ARTICLE:
				if (noun1 == NIL)
					noun1 = nptr + 1;
				if (getnoun() == NIL)
					return (FALSE);
				++cnt1;
				break;

			case WT_CONJUNCTION:
				wptr++;
				break;

			case WT_LAMBDA:
				break;
				/* it's ok */


			default:
				break;	/* ERROR STATE */
			}
			break;

		case C1:
			if (word_type != WT_VERB)
				break;	/* ERROR STATE */
			if (!fill_action_array())
				return (FALSE);
			if (!getverb())
				return (FALSE);
			break;

		case DO:
			switch (word_type)
			{
			case WT_NOUN:
			case WT_ADJECTIVE:
			case WT_ARTICLE:
				if (noun2 == NIL)
					noun2 = nptr + 1;
				if (getnoun() == NIL)
					return (FALSE);
				++cnt2;
				break;

			case WT_CONJUNCTION:
				wptr++;
				break;

			case WT_LAMBDA:
				break;
				/* it's ok */

			case WT_PREPOSITION:
				preposition = *wptr++;
				break;


			default:
				break;	/* ERROR STATE */
			}
			break;

		case C2:
			switch (word_type)
			{
			case WT_NOUN:
			case WT_ADJECTIVE:
			case WT_ARTICLE:
				if (getnoun() == NIL)
					return (FALSE);
				++cnt1;
				break;

			case WT_VERB:
				if (!fill_action_array())
					return (FALSE);
				if (!getverb())
					return (FALSE);
				break;


			default:
				break;	/* ERROR STATE */
			}
			break;

		case P:
			switch (word_type)
			{
			case WT_NOUN:
			case WT_ADJECTIVE:
			case WT_ARTICLE:
				if (noun2 == NIL)
					noun2 = nptr + 1;
				if (getnoun() == NIL)
					return (FALSE);
				++cnt2;
				break;


			default:
				break;	/* ERROR STATE */
			}
			break;

		case IO:
			switch (word_type)
			{
			case WT_CONJUNCTION:
				wptr++;
				break;

			case WT_LAMBDA:
				break;	/* it's ok */


			default:
				break;	/* ERROR STATE */
			}
			break;

		case C3:
			switch (word_type)
			{
			case WT_NOUN:
			case WT_ADJECTIVE:
			case WT_ARTICLE:
				if (getnoun() == NIL)
					return (FALSE);
				++cnt2;
				break;

			case WT_VERB:
				if (!fill_action_array())
					return (FALSE);
				if (!getverb())
					return (FALSE);
				break;


			default:
				break;	/* ERROR STATE */
			}
			break;


		default:
			trm_str("Unknown state during parsing!\n");
			break;

		}		/* switch(active_state) */
		active_state = states[active_state][word_type];
	}			/* while */

	/* return successfully */
	if (active_state == ERROR)
		return (FALSE);
	if (!fill_action_array())
		return (FALSE);

	actionptr = 0;		/* reset for next() and parse() */
	return (TRUE);
}

/* getverb - get a verb phrase and return the action it refers to */
int getverb(void)
{
	int *wptr2;
	/* get the verb */
	if (*wptr == NIL || wtype(*wptr) != WT_VERB)
	{
		parse_error();
		return (NIL);
	}
	verbs[0] = *wptr++;
	verbs[1] = NIL;

	/* check for a word following the verb e.g. switch on the lamp */
	if (*wptr)
	{				/* or switch the lamp on */
		verbs[1] = *wptr;	/* or switch the lamp on and n */
		verbs[2] = NIL;
		if (checkverb(verbs))
		{
			wptr++;		/* found 'switch on' */
			return (T);
		}
		else
		{
#ifdef DEBUG
			trm_str("Enter deep space\n");
#endif
			wptr2 = wptr;
			while (*wptr2 != NIL)
				if (wtype(*wptr2) == WT_CONJUNCTION &&
				    wtype(*(wptr2 + 1)) == WT_VERB)
					break;
				else
					++wptr2;

			if (*wptr2 == NIL)
			{
#ifdef DEBUG
				trm_str("it's nil\n");
#endif
				verbs[1] = *(wptr2 - 1);
				if (checkverb(verbs))
				{
					do
					{
						*(wptr2 - 1) = *wptr2;
					}
					while (*wptr2++);
					--wcnt;
#ifdef DEBUG
					{int i;
					for(i = 0; words[i]; i++) {
						sprintf(dbgbuf,"(%d)",wtype(words[i]));
						trm_str(dbgbuf);
					}
					trm_chr('\n');
					}
#endif
					return (T);
				}
			}
			else  /* WT_UNKNOWN WT_CONJ.(<-wptr2) WT_VERB */
			{
#ifdef DEBUG
				trm_str("it gets difficult\n");
#endif
				verbs[1] = *(wptr2 - 1);
				if (checkverb(verbs))
				{
				int j;
					j = (wptr2 - words);
					do
					{
						*(wptr2-1) = *wptr2;
						wtext[j-1] = wtext[j];
						++j;
					}
					while (*wptr2++);
					--wcnt;
#ifdef DEBUG
					{int i;
					for(i = 0; words[i]; i++) {
						sprintf(dbgbuf,"(%d)",wtype(words[i]));
						trm_str(dbgbuf);
					}
					trm_chr('\n');
					}
#endif
					return (T);
				}
			}
		}
	}

	verbs[1] = NIL;
	if (!checkverb(verbs))
	{
		parse_error();
		return (NIL);
	}
	return (T);
}

/* getnoun - get a noun phrase and return the object it refers to */
int getnoun(void)
{
	/* initialize the adjective list pointer */
	adjectives[nptr] = adjs + aptr;

	/* get the optional article */
	if (*wptr != NIL && wtype(*wptr) == WT_ARTICLE)
		wptr++;

	/* get optional adjectives */
	while (*wptr != NIL && wtype(*wptr) == WT_ADJECTIVE)
	{
		adjs[aptr] = *wptr++;
		anums[aptr] = wptr - words - 1;
		aptr++;
	}
	adjs[aptr++] = NULL;

	/* get the noun itself */
	if (*wptr == NIL || wtype(*wptr) != WT_NOUN)
	{
		parse_error();
		return (NIL);
	}

	/* save the noun */
	nouns[nptr] = *wptr++;
	nnums[nptr] = wptr - words - 1;

#ifdef DEBUG
	trm_str("noun is :");
	show_noun(nptr+1);
	trm_chr('\n');
#endif
	return (++nptr);
}

/* get_line - get the input line and lookup each word */
int get_line(void)
{
	/* read an input line */
	trm_chr(PROMPT);
	if ((lptr = trm_get(line)) == NULL)
	{
		trm_str("Speak up!  I can't hear you!\n");
		return (FALSE);
	}

	/* get each word on the line */
	for (wcnt = 0; skip_spaces(); wcnt++) {
		if (get_word() == NIL)
			return (FALSE);
#ifdef DEBUG
		sprintf(dbgbuf,"(%d)", wtype(words[wcnt]));
		trm_str(dbgbuf);
	}
	trm_chr('\n');
#else
	}
#endif
	words[wcnt] = NIL;

	/* check for a blank line */
	if (wcnt == 0)
	{
		trm_str("Speak up!  I can't hear you!\n");
		return (FALSE);
	}

	/* point to the first word and return successfully */
	wptr = words;
	return (TRUE);
}

/* skip_spaces - skip leading spaces */
int skip_spaces(void)
{
	while (spacep(*lptr))
		lptr++;
	return (*lptr != EOS);
}

/* show_noun - show a noun phrase */
void show_noun(int n)
{
	int adj, *p;

	/* print the adjectives */
	for (p = adjectives[n - 1], adj = FALSE; *p; p++, adj = TRUE)
	{
		if (adj)
			trm_chr(' ');
		trm_str(wtext[anums[p - adjs]]);
	}

	/* print the noun */
	if (adj)
		trm_chr(' ');
	trm_str(wtext[nnums[n - 1]]);
}

/* get_word - get the next word */
int get_word(void)
{
	int ch;

	/* get the next word */
	for (wtext[wcnt] = lptr; (ch = *lptr) != EOS && !spacep(ch);)
		*lptr++ = (isupper(ch) ? tolower(ch) : ch);
	if (*lptr != EOS)
		*lptr++ = EOS;

	/* look up the word */
	if (words[wcnt] = findword(wtext[wcnt]))
		return (words[wcnt]);
	else
	{
		trm_str("I don't know the word \"");
		trm_str(wtext[wcnt]);
		trm_str("\".\n");
		actionptr = 0;
		action_actor[0] =
			action_action[0] =
			action_dobject[0] =
			action_ndobjects[0] =
			action_iobject[0] = NIL;
		return (NIL);
	}
}

/* spacep - is this character a space? */
int spacep(int ch)
{
	return (ch == ' ' || ch == ',' || ch == '.');
}

/* parse_error - announce a parsing error */
void parse_error(void)
{
	trm_str("I don't understand.\n");
	actionptr = 0;
	action_actor[0] =
		action_action[0] =
		action_dobject[0] =
		action_ndobjects[0] =
		action_iobject[0] = NIL;
}

