
/* advcom.h - adventure compiler definitions */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

#include <stdio.h>
#include <ctype.h>

#ifndef MSG_VERSION
#define MSG_VERSION "Text Adventures in Lisp (TAiL) 1.3 compiler\n\
ADVCOM v1.2 (c) 1986 by David Betz / ANSI-C version by Matt Ackerett\n\
Patched/enhanced release TAiL 1.3 by Valerie Winter\n"
#endif

#ifndef MSG_USAGE
#define MSG_USAGE "\nusage: advsys-compiler <source file> [<output file>]"
#endif


/* #define MyInt int */

/* limits */
/*#define TKNSIZE		(( int)50)*/	/* maximum token size */
/*#define OSIZE		(( int)104)*/	/* maximum object size (O_SIZE/2 + OPMAX*2) */
/*#define OPMAX		(( int)50)*/	/* maximum # properties/object */
/*#define WMAX		(( int)500)*/	/* maximum number of words */
/*#define OMAX		(( int)500)*/	/* maximum number of objects */
/*#define AMAX		(( int)200)*/	/* maximum number of actions */
/*#define DMAX		(( int)16384)*/	/* maximum data space */
/*#define CMAX		(( int)16384)*/	/* maximum code space */
/*#define FMAX		(( int)20)*/	/* file name maximum */

#define TKNSIZE		(( int)50)	/* maximum token size */
#define OSIZE		(( int)104)	/* maximum object size (O_SIZE/2 + OPMAX*2) */
#define OPMAX		(( int)50)	/* maximum # properties/object */
#define WMAX		(( int)2000)	/* maximum number of words */
#define OMAX		(( int)2000)	/* maximum number of objects */
#define AMAX		(( int)500)	/* maximum number of actions */
#define DMAX		(( int)262144)	/* maximum data space */
#define CMAX		(( int)262144)	/* maximum code space */
#define FMAX		(( int)40)	/* file name maximum */

/* useful definitions */
#define TRUE		(( int)1)
#define FALSE		(( int)0)
#define EOS		'\0'            

/* token definitions */
#define T_OPEN		(( int)1)
#define T_CLOSE		(( int)2)
#define T_STRING	(( int)3)
#define T_IDENTIFIER	(( int)4)
#define T_NUMBER	(( int)5)
#define T_EOF		(( int)6)

/* symbol types */
#define ST_OBJECT	(( int)1)
#define ST_ACTION	(( int)2)
#define ST_VARIABLE	(( int)3)
#define ST_CONSTANT	(( int)4)
#define ST_PROPERTY	(( int)5)
                                        
/* symbol structure */
typedef struct symbol {
    char *s_name;		/* symbol name */
    int s_type;			/* symbol type */
    int s_value;		/* symbol value */
    struct symbol *s_next;	/* next symbol in table */
} SYMBOL;

/* function argument structure */
typedef struct argument {
    char *arg_name;		/* argument name */
    struct argument *arg_next;	/* next argument */
} ARGUMENT;


/* avl.h - avl tree definitions */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

typedef struct tree {
    struct tnode *tr_root;	/* root node */
    int tr_cnt;			/* count of entries */
} TREE;

typedef struct tnode {
    int tn_b;			/* balance flag */
    struct tnode *tn_llink;	/* left subtree */
    struct tnode *tn_rlink;	/* right subtree */
    char *tn_key;		/* word */
    int tn_word;		/* word number */
} TNODE;

#define LLINK(n)	((n)->tn_llink)
#define RLINK(n)	((n)->tn_rlink)
#define KEY(n)		((n)->tn_key)
#define WORD(n)		((n)->tn_word)
#define B(n)		((n)->tn_b)
#define tentries(t)	((t)->tr_cnt)


/* allcom.h -- made up to save my sanity TUU */

#pragma lint -1   /* TUU */

/*#include "avltree.h"*/    /* TUU - for the TNODE * stuff below */
/*#include "compiler.h"*/    /* TUU - for SYMBOL stuff below */

/* from advcom.c */
int getvalue(void);
int dalloc(int size);
int add_word(char *str,int type);
int add_synonym(char *str,int wrd);
int getword(int off);
void putword(int off,int dat);
int getbyte(int off);
void putbyte(int off,int dat);
void output(void);
void woutput(TNODE *node);
void wtoutput(TNODE *node);
void undef_object(int n);
void str_out(char *str,int len);
/* CHANGED THE FOLLOWING FROM MYINT TO INT */
void word_out(int dat);
void byte_out(int dat);
int oenter(char *name);
int ofind(char *name);
int aenter(char *name);
int venter(char *name);
int penter(char *name);
void center(char *name,int value);
SYMBOL *sfind(char *name);
SYMBOL *senter(char *name,int type, int value);
void frequire(int rtkn);
void require(int tkn,int rtkn);
char *save(char *str);
int match(char *str);
void fail(char *msg);

/* from advfcn.c */
void do_adventure(void);
void do_word(int type);
void do_synonym(void);
void do_define(void);
void do_variable(void);
void do_defproperty(void);
void do_default(void);
void do_dflag(int flag);
int do_object(char *cname,int class);
void do_noun(void);
void do_adjective(void);
void do_property(int flags);
void do_method(void);
void setprop(int prop,int flags,int value);
void addprop(int prop,int flags,int value);
int do_code(char *type);
void do_action(void);
void do_flag(int flag);
void do_verb(void);
void do_preposition(void);
void do_function(void);
void addargument(ARGUMENT **list,char *name);
void freelist(ARGUMENT *arg);
int findarg(char *name);
int findtmp(char *name);

/* from advscn.c */
void sinit(void);
int token(void);
void stoken(int tkn);
int rtoken(void);
int getstring(void);
int getid(int ch);
int isanumber(char *str,int *pval);
void wputc(int ch);
void strdone(void);
int skipspaces(void);
int isidchar(int ch);
int getch(void);
int getchr(void);
int encode(int ch);
void error(char *msg);
void xerror(char *msg);

/* from advexp.c */
void do_expr(void);
int in_ntab(void);
int in_ftab(void);
void do_cond(void);
void do_and(void);
void do_or(void);
void do_if(void);
void do_while(void);
void do_progn(void);
void do_setq(void);
void do_return(void);
void do_send(void);
void do_sndsuper(void);
void sender(void);
void do_call(void);
void do_nary(int op,int n);
void do_literal(void);
void do_identifier(void);
void code_argument(int n);
void code_setargument(int n);
void code_temporary(int n);
void code_settemporary(int n);
void code_variable(int n);
void code_setvariable(int n);
void code_literal(int n);
void do_op(int op);
int putcbyte(int b);
int putcword(int w);
void fixup(int chn,int val);

/* from advavl.c */
TREE *tnew(void);
int tenter(TREE *tree,char *key);
int tenter1(TNODE **pnode,int *ph);
int tfind(TREE *tree,char *key);
int tfind1(TNODE *node);

/* from advfio.c */
void ad_create(char *name);
void ad_close(void);
void ad_putc(int ch);
void ad_seek(long pos);
void ad_flush(void);

