/****************************************************************************\
*
* Magnetic - Magnetic Scrolls Interpreter.
*
* Written by Niclas Karlsson <nkarlsso@abo.fi>,
*            David Kinder <d.kinder@btinternet.com>,
*            Stefan Meier <Stefan.Meier@if-legends.org> and
*            Paul David Doherty <pdd@if-legends.org>
*
* Copyright (C) 1997-2003  Niclas Karlsson
*
*     This program is free software; you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation; either version 2 of the License, or
*     (at your option) any later version.
*
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
*
*     Simple ncurses interface
*
\****************************************************************************/


#include "core.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifndef STORYDIR
#define STORYDIR "/usr/share/games/if/magnetic_scrolls/"
#endif

#define PROGID "Magnetic 2.2-vw1"
#define COPYRIGHT "Magnetic 2.2 is copyrighted (c) 1997-2003 by Niclas Karlsson"
#define PROGPORT "improved version 2.2-vw1 (r) by Valerie Winter"


#ifdef USE_CURSES
#define PROGSUBID "(ncurses interface)"
#define INTERNAL_CMDS "Internal interpreter commands:\n\n\
\\undo         undo the last game turn\n\
\\picnum       toggle showing the picture number\n\
\\reverse      invert the video mode\n\
\\status       toggle status line format (IF standard or Magnetic Scrolls)\n\
\\version      show the interpreter version\n\n\
\\transscript  start recording a game transscript\n\
\\stoptrans    stop recording a game transscript\n\
\\script       start recording a command script\n\
\\stopscript   stop recording a command script\n\n\
\\config       display an overview of current settings\n\
\\q            quick-quit, exit game and interpreter at once"
#define USAGE "an interpreter for Magnetic Scrolls text/graphic adventures\n\n\r\
Usage: magnetic [options] <game>.mag \n\r\
(<game>.gfx and <game>.hnt in same dir will automatically be loaded)\n\n\r\
Where the options are:\n\r\
      -i       use reverse video\n\r\
      -np      don't show picture number in status line\n\r\
      -ns      use original Magnetic Scrolls status line\n\r\
      -nt      don't set xterm title\n\n\r\
      -rname   read script file <name>\n\r\
      -wname   write script file <name>\n\r\
      -tname   write transscript file <name>\n\n\r\
      -dn      dump registers after n instructions\n\r\
      -sn      safety mode, exit automatically after n instructions\n\n\r\
Type \\help at the game prompt for run-time commands.\n"
#endif

/* " */

#ifdef USE_DUMB
#define PROGSUBID "(dumb interface)"
#define USAGE "an interpreter for Magnetic Scrolls text/graphic adventures\n\n\
Usage: magnetic [options] <game>.mag \n\
(<game>.gfx and <game>.hnt in same dir will automatically be loaded)\n\n\
Where the options are:\n\
      -ln      screen is n lines high (default: 24)\n\
      -cn      screen has n columns (default: 78)\n\
      -np      don't use \"more\" prompts\n\
      -ns      don't use new status line\n\
      -rname   read script file <name>\n\
      -wname   write script file <name>\n\
      -tname   write transscript file <name>\n\
      -dn      dump registers after n instructions\n\
      -sn      safety mode, exit automatically after n instructions\n\n\
Type \\help at the game prompt for run-time commands.\n"
#define INTERNAL_CMDS "Internal interpreter commands:\n\n\
\\undo         undo the last game turn\n\
\\picnum       toggle showing the picture number\n\
\\status       toggle status line format (IF standard or Magnetic Scrolls)\n\
\\version      show the interpreter version\n\n\
\\transscript  start recording a game transscript\n\
\\stoptrans    stop recording a game transscript\n\
\\script       start recording a command script\n\
\\stopscript   stop recording a command script\n\n\
\\config       display an overview of current settings\n\
\\q            quick-quit, exit game and interpreter at once"
#endif
