/*
  term_curses.c --- a ncurses frontend to magnetic

    somewhat ripped, changed and improved from the original main.c,
  but still quite a mess.  If I ever meet the... person... who coded
  magnetic 2.2, it will be quite a physical encounter.
    And I do not mean one of the sensual kind.  Meet my fist, say
  hello to my knee and good-bye to your balls.
    Most of what I wanted to change or implement doesn't work because
  of the stupid way things are done in the original main.c and in
  core_emu.c.  And I certainly will not re-write any of this mess.  I
  have already cleaned up some of the awful, stupid and silly coding
  everywhere.  And I have far better things to do with my time.

*/


/* #include <stdio.h> */ /* is redundant via stdlib and string */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
/* #include <libgen.h> */ /* what for?!  MS-DOS world?! */
#include <curses.h>
#include "terminal.h"

const char program_name[]=PROGID;
char program_info[256];
char *gametitle;

char moreprompts=TRUE;
char newstatus=TRUE;
char xtermtitle=TRUE;
char pictures=TRUE;
char quickquit=FALSE;
char reverse=FALSE;
char dumpreg=FALSE;
char failsafe=FALSE;

/* have to keep this silly global stuff */
unsigned char textbuf[80], xpos=0, ypos=1, bufpos = 0;
unsigned char log_on = 0, ms_gfx_enabled, filename[256];
unsigned char transscriptname[128], cmdfilename[128], record_ts=FALSE;
FILE *commandfile = 0, *transscript = 0; /* was log1 and log2 */

/* (n)curses related */
WINDOW *statuswin, *textwin;
int screenwidth=80;
int screenheight=24;
int textwinheight;


/* statusline stuff */
extern char version; /* from core_engine.c, for the status line method */
char statusline[79]=" \0";
char newstatusline[79]=" \0";
char picinfo[14];


extern void ms_showpic(unsigned int picnum,unsigned char mode);


void transcript_write(unsigned char c)
{
  if (transscript && c == 0x08 && ftell(transscript) > 0)
    fseek(transscript,-1,SEEK_CUR);

  else if (transscript && fputc(c,transscript) == EOF)
    {
      /* close transscripts silently --- val */
      /*
      wprintw(textwin,"[Problem with transcript file - closing]\n");
      */
      fclose(transscript);
      transscript = 0;
      log_on=0;
    }
}


/* more_prompt()

   a shame to having to mention, but THIS elemental thing was missing!
      ---val
*/
int more_prompt(void)
{
  if(moreprompts)
    {
      wprintw(textwin,"[More]");
      wgetch(textwin);
      wprintw(textwin,"      \r");      /* the spaces *are* necessary, eg. on 
					   a line where just the prompt shows up.
					   otherwise, it would look something like 
					   ">ore]" */
      ypos=1; /* reset the when-to-issue-next-more-prompt counter */
    }
}


/* some original shi^H^Htuff, hugely optimized --- val */
void ms_flush(void)
{
  int j;
  
  if (!bufpos)
    {
      return;
    }
  if(xpos + bufpos >= screenwidth)
    {
      waddch(textwin,'\n');
      transcript_write('\n');
      xpos = 0;
      ypos++;
    }
  if(ypos>=screenheight-1)
    {
      more_prompt();
      ypos=1;
    }
  for (j = 0; j < bufpos; j++)
    {
      if (textbuf[j] == 0x0a)
	{
	  xpos = 0;
	  ypos++;
	}
      if (textbuf[j] == 0x08)
	xpos -= 2;
      waddch(textwin,textbuf[j]);
      transcript_write(textbuf[j]);
      xpos++;
    }
  bufpos = 0;
}


/* some original shi^H^Htuff */
void ms_putchar(unsigned char c)
{
  textbuf[bufpos++] = c;

  if((c==0x20) && (bufpos>=sizeof(textbuf)))
     textbuf[bufpos]='\0';
  if((c == 0x20) || (c == 0x0a) || (bufpos >= sizeof(textbuf)))
    ms_flush();
}


/* some original shi^H^Htuff */
unsigned char ms_load_file(signed char *name, unsigned char *ptr, unsigned short size)
{
  FILE *fh;
  signed char *realname;

  if (name)
    realname = name;
  else
    {
      do
	{
	  wprintw(textwin,"Filename: ");
	}
      while (!gets(filename));
      realname = filename;
    }
  if (!(fh=fopen(realname,"rb")))
    return 1;
  if (fread(ptr,1,size,fh) != size)
    return 1;
  fclose(fh);
  return 0;
}


/* some original shi^H^Htuff */
unsigned char ms_save_file(signed char *name, unsigned char *ptr, unsigned short size)
{
  FILE *fh;
  signed char *realname;
  
  if (name)
    realname = name;
  else
    {
      do
	{
	  wprintw(textwin,"Filename: ");
	}
      while (!gets(filename));
      realname = filename;
    }
  if (!(fh = fopen(realname,"wb")))
    return 1;
  if (fwrite(ptr,1,size,fh) != size)
    return 1;
  fclose(fh);
  return 0;
}


/* some original shi^H^Htuff */
void script_write(unsigned char c)
{
  if (log_on == 2 && fputc(c,commandfile) == EOF)
    {
      wprintw(textwin,"[Problem with script file - closing]\n");
      fclose(commandfile);
      log_on = 0;
    }
}


/* create_if_statusline()

  A routine that copies the status line into a neat IF-standard comformant one.
  Magnetic Scrolls's status line (included in the storyfiles) is a bit weird:

  25 bytes location name
  0x09 ("jump-right")
  9 bytes score/moves (6-byte-padded, right-aligned score#/moves#; ______0/0 to 9999/9999)

  My version of ms_statuschar() already composes an 80col status line of purely 
  printable characters, but that one is in Magnetic Scrolls style.
  Hence, we must re-compose it a little.
     ---val
 */
int create_if_statusline(void)
{
  char statscore[]="Score: ";
  char statmoves[]="Moves: ";
  int oldoffset=11, newoffset=29, movesoffset=15;
  int x_in=0, x_out=0;

  /* replace Score: and Moves: with S: and M: on narrow screens */
  if(screenwidth<70)
    {
      strcpy(statscore,"S: ");
      strcpy(statmoves,"M: ");
      newoffset=18;
    }
  /* use Magnetic Scrolls's status on tiny screens */
  if(screenwidth<50)
    newstatus=FALSE;

  strcpy(newstatusline,"\0");

  /* copy the location string up to new status field's position */
  strncat(newstatusline,statusline,newoffset);
  x_out=strlen(newstatusline);
      
  /* pad to position of status field */
  for(; x_out<=sizeof(newstatusline)-newoffset; x_out++)
    newstatusline[x_out]=' ';

  if(strstr(statusline,"/")!=NULL) /* handle original "<score>/<moves>" status */
    {
      /* tell us the first number is the score */
      strcat(newstatusline,statscore);
      /*x_out+=sizeof(statscore);*/
      x_out+=strlen(statscore);

      /* copy the score field without its padding */
      for(x_in=strlen(statusline)-oldoffset; x_in<=strlen(statusline); x_in++)
	if(statusline[x_in]>='0' && statusline[x_in]<='9')
	  break;
      while(statusline[x_in]!='/')
	{
	  newstatusline[x_out]=statusline[x_in];
	  x_in++;
	  x_out++;
	}

      x_in++; /* get rid of the "/" */

      /* insert padding between "Score: x" and "Moves: y"*/
      for(;x_out<=sizeof(newstatusline)-movesoffset;x_out++)
	newstatusline[x_out]=' ';
      
      /* insert "Moves: " and according number */
      strcat(newstatusline,statmoves);
      x_out+=strlen(statmoves);
      for(; statusline[x_in]>='0' && statusline[x_in]<='9'; x_in++, x_out++)
	newstatusline[x_out]=statusline[x_in];
    }

  if(strstr(statusline,":")!=NULL) /* handle original "HH:MMxm" time status */
    for(x_in=0,x_out=0;x_in<=strlen(statusline);x_in++,x_out++)
      newstatusline[x_out]=statusline[x_in]; /* just copy the status line 1:1 */
  
  /* pad with spaces to full length */
  for(; x_out<=sizeof(newstatusline); x_out++)
    newstatusline[x_out]=' ';

  /* avoid strange errors on some systems */
  strcat(newstatusline,"\0");

  /* un-do the engine's up-casing of the location string (core_engine.c) */
  for(x_out=0;x_out<=strlen(newstatusline);x_out++)
    if((newstatusline[x_out] >= 'A') && (newstatusline[x_out] <= 'Z') &&
       (newstatusline[x_out-1]!=' '))
      newstatusline[x_out]=tolower(newstatusline[x_out]);

}


/* print_statusline()

   A printer that puts out a neat statusline, including info about
   which picture is currently displayed (well, not on tiny screens).
   Had to split this from ms_statuschar because otherwise the picture
   info wouldn't be printed with the corresponding game location at once.
     ---val
 */
void print_statusline(void)
{
  int x,y,z;
  char outstatus[screenwidth]; /* always look good on the full width */
  int offset=29, smalloffset=20, tinyoffset=11;


  /* for Magnetic Windows versions, use this "status" instead
     (MW versions don't have a status line at all) */
  if(version>=4)
    {
      if(gametitle!=NULL)
	{
	  sprintf(outstatus," %s",gametitle);
	  for(x=strlen(outstatus); x<=sizeof(outstatus)-strlen(program_name)-2; x++)
	    strcat(outstatus," ");
	}
      else /* gametitle is unknown; just spaces, then */
	for(x=0; x<=sizeof(outstatus)-strlen(program_name)-1; x++)
	  outstatus[x]=' ';
      strcat(outstatus,program_name);
      z=23;
    }  
  else
    {
      /* copy the location name part */
      for(x=0; x<=offset; x++)
	if(newstatus)
	  outstatus[x]=newstatusline[x];
	else
	  outstatus[x]=statusline[x];

      /* fill outstatus with spaces */
      for(; x<=screenwidth; x++)
	outstatus[x]=' ';

      /* determine offsets and copy status part */ 
      if(screenwidth<=70)
	offset=smalloffset;
      if(screenwidth<=50)
	offset=tinyoffset;

      /* since statusline and newstatusline are of the same size, we use any */
      for(x=sizeof(outstatus)-offset,y=sizeof(statusline)-offset;
	  x<=sizeof(outstatus); x++,y++)
      if(newstatus)
	outstatus[x]=newstatusline[y];
      else
	outstatus[x]=statusline[y];
    }
  /* insert the picture number information between location and score */

  if(pictures)
    {
      if(screenwidth<=50)
	{
	  z = (screenwidth/2)+5;
	  for(x=0;x<=strlen(picinfo);x++)
	    if((picinfo[x]=='(' || picinfo[x]==')') ||
	       (picinfo[x]>='0' && picinfo[x]<='9')) 
	      outstatus[z++]=picinfo[x];
	}
      else
	{
	  z = (screenwidth / 2) - (strlen(picinfo) / 2); /* put picture info centered */
	  for(x=0;x<=strlen(picinfo);x++)
	    if(picinfo[x]!='\n' && picinfo[x]!='\0') 
	      outstatus[z++]=picinfo[x];
	}
    }

  /* now print to screen and pad to screenwidth */
  wprintw(statuswin,"\r%s",outstatus);

  for(x=strlen(outstatus); x<=screenwidth; x++)
    waddch(statuswin,' ');

  wrefresh(statuswin);
}


/* ms_statuschar() --- some original shi^H^Htuff, heavily modified 

  this originally made some checks --- as stupid as complicated --- on
  a character and printed every single character of the status line
  directly onto the display, which made me wonder why it wasn't simply
  done via ms_putchar().  or, alternately, which stupid fool coded it.
  hoewver, I turned this into a buffered status line that can be
  modified, for example by create_other_statusline() and
  print_statusline().
     ---val
*/
void ms_statuschar(unsigned char c)
{
  static int length=1;
  int offset=11;

  if(c == '\n') /* newline? then print and reset */
    {
      while(length<sizeof(statusline))
	statusline[length++] = ' ';

      /* if(newstatus) */
	create_if_statusline();

      length=1;

      print_statusline();
    }
  else
    {
      if(c == 0x09) /* move-to-right-side byte */
	{
	  /* pad to statusline width using spaces */
	  while (length < sizeof(statusline)-offset)
	    statusline[length++] = ' ';
	}
      else
	statusline[length++] = c;
    }
}


/* some original shi^H^Htuff, somewhat modified */
unsigned char ms_getchar(unsigned char trans)
{
  static unsigned char buf[256];
  static unsigned short pos=0;
  int c;
  unsigned char i,key;
  
  if (!pos)
    {
      /* Read new line? */
      i = 0;
      print_statusline(); /* update this with every prompt (picinfo) */
      wrefresh(statuswin);
      wrefresh(textwin);
      nocbreak(); /* let's have normal keyboard here */
      ypos=1; /* reset line counter for [more] with every prompt */
      while (1)
	{
	  if (log_on == 1)
	    {
	      /* Reading from logfile */
	      if ((c = fgetc(commandfile)) == EOF)
		{
		  /* End of log? - turn off */
		  log_on = 0;
		  fclose(commandfile);
		  c = wgetch(textwin);
		}
	      else wprintw(textwin,"%c",c); /* print the char as well */
	    }
	  else
	    {
	      c = wgetch(textwin);

	      /* note: new internal command character */
	      if(c == '\\' && !i && trans) /* this is an interpreter command */
		{
		  while((c = wgetch(textwin)) != '\n' && c != EOF && i < 255)
		    buf[i++] = c;
		  buf[i] = 0;
		  c = '\n'; /* => Prints new prompt */
		  i = 0;
		  if(!strcmp(buf,"script"))
		    {
		    if(log_on == 2)
		      wprintw(textwin,"[we're already recording a command script]\n");
		      if(log_on == 1)
			wprintw(textwin,"[doesn't work --- we're already recording a transscript]\n");
		    if(log_on == 0)
		      {
			wprintw(textwin,"[recording command script %s]\n", cmdfilename);
			commandfile=fopen(cmdfilename,"w");
			log_on=2;
		      }
		    }
		  else if(!strcmp(buf,"transscript"))
		    {
		      if(log_on == 1)
			wprintw(textwin,"[we're already recording a transscript]\n");
		      if(log_on == 2)
			wprintw(textwin,"[doesn't work --- we're already recording a command script]\n");
		      if(log_on == 0 && log_on != 1)
			{
			  wprintw(textwin,"[recording transscript %s]\n", transscriptname);
			  log_on=1;
			  transscript=fopen(transscriptname,"w");
			}
		    }
		  else if(!strcmp(buf,"stopscript"))
		    {
		      if(log_on == 2)
			{
			  wprintw(textwin,"[closing command script file]\n");
			  log_on = 0;
			  fclose(commandfile);
			}
		      else
			  wprintw(textwin,"[we're not recording any command script!]\n");
		    }
		  else if(!strcmp(buf,"stoptrans"))
		    {
		      if(log_on == 1)
			{
		      wprintw(textwin,"[closing transscript file]\n");
		      log_on=0;
		      fclose(transscript);
			}
		      else
		      wprintw(textwin,"[we're not recording any transscript!]\n");
		    }
		  else if(!strcmp(buf,"undo"))
		    c = 0;
		  else if(!strcmp(buf,"version"))
		    wprintw(textwin,"%s\n",program_info);
		  else if(!strcmp(buf,"status"))
		    {
		      if(newstatus==TRUE) 
			  newstatus=FALSE;
		      else
			  newstatus=TRUE;
		      set_term_attributes();
		      wprintw(textwin,"[setting status line to %s]\n", newstatus? "IF standard" : "Magnetic Scrolls" );
		      /*
		      wprintw(textwin,"[the status feature is buggy, hence disabled.]");
		      */
		    }
		  else if(!strcmp(buf,"reverse"))
		    {
		      if(reverse==TRUE)
			reverse=FALSE;
		      else
			reverse=TRUE;
		      set_term_attributes();
		      wprintw(textwin,"[turning %s reverse mode]\n", reverse? "on" : "off");
		    }
		  else if(!strcmp(buf,"picnum"))
		    {
		      if(pictures==TRUE)
			pictures=FALSE;
		      else
			pictures=TRUE;
		      ms_showpic(0,0);
		      wrefresh(statuswin);
		      wprintw(textwin,"[turning %s picture numbers]\n", pictures? "on" : "off");
		    }
		  else if(!strcmp(buf,"q"))
		    {
		      /* wprintw(textwin,"[quick-quit game]\n"); */
		      quickquit=TRUE;
		    }
		  else if(!strcmp(buf,"config"))
		    {
		      wprintw(textwin,"status line type: %s\n", newstatus? "IF standard" : "Magnetic Scrolls" );
		      wprintw(textwin,"display picture number: %s\n", pictures? "on" : "off" );
		      wprintw(textwin,"disable hints: (not yet implemented)\n");
#ifdef USE_DUMB
		      wprintw(textwin,"use more prompts: %s\n", moreprompts? "yes" : "no" );
#endif
#ifdef USE_CURSES
		      wprintw(textwin,"reverse display: %s\n", reverse? "on" : "off" );
		      wprintw(textwin,"set xterm title: %s\n", xtermtitle? "yes" : "no" );
#endif
		      wprintw(textwin,"use external picture/animation viewer: (not yet implemented)\n");
		      wprintw(textwin,"use external audio player: (not yet implemented)\n");
		      wprintw(textwin,"currently recording command script: %s\n", log_on==2? "yes" : "no");
		      wprintw(textwin,"currently recording transsscript: %s\n",  log_on==1? "yes" : "no");
		      wprintw(textwin,"dump registers: %s\n",  dumpreg? "yes" : "no");
		      wprintw(textwin,"failsafe mode: %s\n",  failsafe? "yes" : "no");
		    }
		  else if(!strcmp(buf,"help"))
		    wprintw(textwin,"%s\n",INTERNAL_CMDS);
		  else
		    wprintw(textwin,"[unknown command, try \\help]\n");
		}
	    }
	  script_write((unsigned char)c);
	  if (c != '\n')
	    transcript_write((unsigned char)c);
	  if (c == '\n' || c == EOF || i == 255)
	    break;
	  buf[i++] = c;
	  if (!c)
	    break;
	}
      buf[i] = '\n';
      cbreak(); /* turn on ncurse's buffered character mode again */
    }
  if ((c = buf[pos++]) == '\n' || !c || quickquit)
    pos = 0;
  if(quickquit)
    {
      wprintw(textwin,"[quick-quit game --- sure (y/n)?] ");
      key=wgetch(textwin);
      waddch(textwin,'\n');
      if(key=='y' || key=='Y')
	ms_stop();
      quickquit=FALSE;
    }
  return (unsigned char)c;
}



/* end_program(return code)

   the exit(rcode) replacement here that takes care of log closing and
   curses termination.
      ---val
*/
void end_program(int rcode)
{
  ms_freemem();

  if (log_on)
    fclose(commandfile);

  if (transscript)
    fclose(transscript);

  /* tell curses to quit, also */
  endwin();

  exit(rcode);
}


void ms_fatal(signed char *txt)
{
  fputs("\nFatal error: ",stderr);
  fputs(txt,stderr);
  fputs("\n",stderr);
  ms_status();
  end_program(1);
}


unsigned char ms_showhints(struct ms_hint * hints)
{
  return 0;
}



/* set_term_attributes()

   set the terminal's ncurses attributes according to current mode
      ---val
*/
void set_term_attributes(void)
{
  if(reverse && newstatus)
    {
      wattrset(statuswin,A_NORMAL);
      wbkgd(statuswin,' ' | A_NORMAL);
      wattrset(textwin,A_REVERSE);
      wbkgd(textwin,' ' | A_REVERSE);
    }
  else if(newstatus)
    {
      wattrset(statuswin,A_REVERSE);
      wbkgd(statuswin,' ' | A_REVERSE);
      wattrset(textwin,A_NORMAL);
      wbkgd(textwin,' ' | A_NORMAL);
    }
  else if(reverse)
    {
      if(has_colors())
	wbkgd(statuswin,' ' | COLOR_PAIR(2) | A_BOLD);
      else
	wbkgd(statuswin,' ' | A_REVERSE | A_BOLD);
      wattrset(textwin,A_REVERSE);
      wbkgd(textwin,' ' | A_REVERSE);
    }
  else
    {
      if(has_colors())
	wbkgd(statuswin,' ' | COLOR_PAIR(2) | A_BOLD);
      else
	wbkgd(statuswin,' ' | A_NORMAL | A_BOLD);
      wattrset(textwin,A_NORMAL);
      wbkgd(textwin,' ' | A_NORMAL);
    }


  wrefresh(textwin);
  wrefresh(statuswin);
}



/* init_curses()

   start a new curses screen and create the two output windows we will
   use.
      ---val
*/
int init_curses(void)
{
  int x;

  initscr();
  start_color();
  use_default_colors();
  cbreak();
  echo();
  intrflush(stdscr, FALSE);
  keypad(textwin, TRUE);
  newwin(0,0,0,0);
  screenwidth=COLS;
  screenheight=LINES;

  if(has_colors())
    {
      init_pair(1,-1,-1);
      init_pair(2,COLOR_WHITE,COLOR_BLACK);
      init_pair(3,COLOR_BLACK,COLOR_WHITE);
    }

  statuswin=subwin(stdscr,1,screenwidth,0,0);
  textwin=subwin(stdscr,screenheight-1,screenwidth,1,0);
  scrollok(textwin, TRUE);

  set_term_attributes();

}


/* identify_game(storyfile)

   Identify a game from its storyfile header, and cache the game's name for
   later queries.  must be a fqfn to work.
   unknown values will be returned as the content of program_name. 

   To-do: make this ambivalent to also get the gfx and hint version info
          (toggle returned information via mode parameter)

   This was originally simply copied from Magnetic-Glk, but when I saw what 
   bullshit the code actually was, I mostly rewrote it from scratch and reduced 
   it from four functions that exclusively called each other into a single one.
      ---val
*/
/* char* identify_game(const char *storyfile, char mode) <--- future layout */
char* identify_game(const char *storyfile)
{
  unsigned short undo_size, undo_pc, temp;
  game_tableref_t game;
  int x;
  unsigned char buffer[4], offset;
  FILE *infile;

  infile = fopen(storyfile, "r");
  if(infile)
    {
      /* Read the game header's undo size and undo pc values. */
      offset=0x22; /* undo_size within header */

      /* a simple two-pass loop to set undo_size and undo_pc */
      for(x=1;x<3;x++)
	{
	  if(fseek(infile, offset, SEEK_SET)==0)
	    if(fread(buffer, 1, sizeof(buffer), infile) != sizeof(buffer))
	      break;
	  temp=buffer[0]<<24 | buffer[1]<<16 | buffer[2]<<8 | buffer[3];
	  /* the kludge to avoid an "external" function */
	  if(x<2) 
	    {
	      undo_size=temp;
	      offset=0x26; /* undo_pc within header */
	    }
	  else
	      undo_pc=temp;
	}
      fclose(infile);

      /* now search the table GAME_TABLE for these values ---
         need x to avoid a flip-turn back to the start of the table */
      for(x=0, game=GAME_TABLE; x<sizeof(GAME_TABLE); game++, x++)
	if(game->undo_size == undo_size && game->undo_pc == undo_pc)
	  return game->name;
    }

  /* if no game->name could be found, size and pc are set to zero, which 
  is not good since I would need to handle a NULL return value and to waste code
  and effort on unneccessary things.  So, I simply return a default in this case. */
  return program_name;
}


/* some original shi^H^Htuff, somewhat modified */
int main(int argc, char *argv[])
{
  int running, i;
  char *gamename="\0";
  char gfxfilename[256]="\0", hintfilename[256]="\0";
  char fqgamename[256]="\0";
  FILE *ftest;
  int dlimit, slimit;
  
  /* define escape sequences to set the window title of xterm */
  char *termname=getenv("TERM");
  char xtermname[60]="echo -en \"\\033]0;";
  char xtermname2[]="\\007\"";
  char xtermdefault[]="echo -en \"\\033]0;xterm\\007\"";

  sprintf(program_info,"%s %s\n%s,\n%s",PROGID,PROGSUBID,COPYRIGHT,PROGPORT);

  if (sizeof(unsigned char) != 1 || sizeof(unsigned short) != 2 || sizeof(unsigned long) != 4)
    {
      fprintf(stderr,
	      "You have incorrect typesizes, please edit the typedefs and recompile\n"
	      "or proceed on your own risk...\n");
      end_program(1);
    }
  dlimit = slimit = 0xffffffff;

  /* note: new shell parameter list */
  for (i = 1; i < argc; i++)
    {
      if (argv[i][0] == '-')
	{
	  switch (tolower(argv[i][1]))
	    {
	    case 'i':
	      reverse=TRUE;
	      break;
	    case 'n':
	      switch(tolower(argv[i][2]))
		{
		case 'p':
		  pictures=FALSE;
		  break;
		case 's':
		  newstatus=FALSE;
		  break;
		case 't':
		  xtermtitle=FALSE;
		  break;
		}
	      break;
	    case 'd':
	      if (strlen(argv[i]) > 2)
		{
		  dlimit = atoi(&argv[i][2]);
		  dumpreg=TRUE;
		}
	      else
		dlimit = 0;
	      break;
	    case 's':
	      if (strlen(argv[i])>2)
		{
		  slimit = atoi(&argv[i][2]);
		  failsafe=TRUE;
		}
	      else
		slimit = 655360;
	      break;
	    case 't':
	      if (!(transscript = fopen(&argv[i][2],"w")))
		{
		  wprintw(textwin,"Failed to open \"%s\" for writing.\n",&argv[i][2]);
		  record_ts=TRUE;
		}
	      break; 
	    case 'r':
	      if (commandfile = fopen(&argv[i][2],"r"))
		log_on = 1;
	      else
		wprintw(textwin,"Failed to open \"%s\" for reading.\n",&argv[i][2]);
	      break;
	    case 'w':
	      if (commandfile = fopen(&argv[i][2],"w"))
		log_on = 2;
	      else
		wprintw(textwin,"Failed to open \"%s\" for writing.\n",&argv[i][2]);
	      break;
	    default:
	      wprintw(textwin,"Unknown option -%c, ignoring.\n",argv[i][1]);
	      break;
	    }
	}
      else if (gamename=="\0")
	  gamename = argv[i];
    }
  if (gamename=="\0")
    {
      fprintf(stderr,"%s\n%s",program_info,USAGE);
      end_program(1);
    }

  /* test if the storyfile exists in absolute path, ./ or STORYDIR */

  /* does given file exist with this fqfn or (path)name? */
  ftest=fopen(gamename,"r");
  if(ftest)
    {
      fclose(ftest);
      strcpy(fqgamename,gamename);
    }
  /* if not fqfn, try to find it in STORYDIR */
  if(gamename[0]!='/')
    {
      strcat(fqgamename,STORYDIR);
      strcat(fqgamename,gamename);
    }
  ftest=fopen(fqgamename,"r");
  if(!ftest)
    {
      fprintf(stderr,"There's no \"%s\".\n",gamename);
      end_program(1);
    }
  fclose(ftest);
  
  /* get the game's name for the v4+ status line and the xterm title */
  gametitle=identify_game(fqgamename);

  /* assume graphics and hints file end with .gfx and .hnt, respectively */
  strcpy(gfxfilename,fqgamename);
  strcpy(hintfilename,fqgamename);
  strcpy(strpbrk(gfxfilename,"."),".gfx");
  strcpy(strpbrk(hintfilename,"."),".hnt");

  strcpy(transscriptname,basename(gamename));
  strcpy(cmdfilename,basename(gamename));
  strcpy(strpbrk(transscriptname,"."),".transscript");
  strcpy(strpbrk(cmdfilename,"."),".cmdscript");
  /* fprintf(stderr,"%s\n\r%s\n\r%s\n\r",fqgamename,gfxname,hintname); */

  /* configure the curses display */
  init_curses();

  /* set xterm's window title to the game's name */
  if(xtermtitle)
    if(strstr(termname,"xterm"))
      {
	/*
	if(gametitle==NULL)
	  strcat(xtermname,program_name);
	else
	*/ /* obsolete; see identify_game() */
	strcat(xtermname,gametitle);
	for(i=0; i<strlen(xtermname); i++)
	  if(xtermname[i]==' ' && xtermname[i+1]=='(')
	    xtermname[i]='\0';
	strcat(xtermname,xtermname2);
	system(xtermname);
      }

  /* this is a bit crude --- why didn't he just give a path and basename
     and let ms_init() find out about the other files (same location)? */
  ms_gfx_enabled = ms_init(fqgamename,gfxfilename,hintfilename);

  ms_gfx_enabled--; /* this still makes me wonder what this actually does... */
  running = 1; /* ...and this also... */

  while ((ms_count() < slimit) && running)
    {
      if (ms_count() >= dlimit)
	ms_status();
      running = ms_rungame();
    }
  if (ms_count() == slimit)
    {
      wprintw(textwin,"\n\nSafety limit (%d) reached.\n",slimit);
      ms_status();
    }

  /* be a bit more nice */
  wprintw(textwin,"\r[Press any key to exit.]");
  wgetch(textwin);

  /* set xterm's window title back to its default */
  if(xtermtitle)
    {
      if(strstr(termname,"xterm"))
	system(xtermdefault);
    }

  end_program(0);
}


