/*
 * random.c
 *
 * Z-machine random number generator
 *
 */

#include <stdlib.h>
#include <time.h>
#include "frotz.h"

static zword interval = 0;
static zword counter = 0;

/*
 * seed_random
 *
 * Set the seed value for the random number generator.
 *
 */

void seed_random (zword value)
{

    if (value == 0) {

	/* Randomize by using the current time */

	srand ((unsigned) time (0));
	interval = 0;

    } else if (value < 1000) {

	/* Start the sequence 1,...,|range|,1,...,|range|... */

	counter = 0;
	interval = value;

    } else {

	/* Seed the random number generator with value */

	srand (value);
	interval = 0;
    }

}/* seed_random */

/*
 * z_random
 *
 * Calculate a random number between 1 and range (if range > 0),
 * randomize (if range = 0) or make the random number generator
 * predictable (if range < 0). Following G. Nelson's suggestion,
 * a seed value less than 1000 generates a sequence running from
 * 1 to |range|, and a seed value greater or equal 1000 is used
 * as a standard random number seed.
 *
 */

void z_random (zword range)
{
    zword result;

    if ((short) range <= 0) {

	/* Set random seed */

	seed_random (-range);

	/* Store 0 */

	result = 0;

    } else {

	/* Generate random number (either in predictable or standard mode) */

	if (interval != 0) {

	    result = counter;

	    if (++counter == interval)
		counter = 0;

	} else result = rand ();

	/* Random number must be between 1 and range */

	result = result % range + 1;
    }

    /* Return random number to the Z-machine */

    store (result);

}/* z_random */
