/*
 * math.c
 *
 * Arithmetic, compare and logical opcodes
 *
 */

#include "frotz.h"

/*
 * z_add
 *
 * Add two operands.
 *
 */

void z_add (zword a, zword b)
{

    store ((short) a + (short) b);

}/* z_add */

/*
 * z_and
 *
 * Bitwise AND.
 *
 */

void z_and (zword a, zword b)
{

    store (a & b);

}/* z_and */

/*
 * z_art_shift
 *
 * Arithmetic shift +/- b bits.
 *
 */

void z_art_shift (zword a, zword b)
{

    if ((short) b > 0)
	store ((short) a << b);
    else
	store ((short) a >> -b);

}/* z_art_shift */

/*
 * z_div
 *
 * Signed division.
 *
 */

void z_div (zword a, zword b)
{

    if (b == 0)
	os_fatal ("Division by zero");

    store ((short) a / (short) b);

}/* z_div */

/*
 * z_je
 *
 * Jump if operand 1 is equal to any other operand.
 *
 */

void z_je (int argc, zword *argv)
{
    zword a;

    a = argv[0];

    branch (argc > 1 && (a == argv[1] || (
	    argc > 2 && (a == argv[2] || (
	    argc > 3 && (a == argv[3]))))));

}/* z_je */

/*
 * z_jg
 *
 * Branch if operand 1 is greater than operand 2.
 *
 */

void z_jg (zword a, zword b)
{

    branch ((short) a > (short) b);

}/* z_jg */

/*
 * z_jl
 *
 * Branch if operand 1 is less than operand 2.
 *
 */

void z_jl (zword a, zword b)
{

    branch ((short) a < (short) b);

}/* z_jl */

/*
 * z_jz
 *
 * Branch if operand is zero.
 *
 */

void z_jz (zword a)
{

    branch ((short) a == 0);

}/* z_jz */

/*
 * z_log_shift
 *
 * Logical shift +/- b bits.
 *
 */

void z_log_shift (zword a, zword b)
{

    if ((short) b > 0)
	store (a << b);
    else
	store (a >> -b);

}/* z_log_shift */

/*
 * z_mod
 *
 * Remainder after signed division.
 *
 */

void z_mod (zword a, zword b)
{

    if (b == 0)
	os_fatal ("Division by zero");

    store ((short) a % (short) b);

}/* z_mod */

/*
 * z_mul
 *
 * Multiply two operands.
 *
 */

void z_mul (zword a, zword b)
{

    store ((short) a * (short) b);

}/* z_mul */

/*
 * z_not
 *
 * Bitwise NOT.
 *
 */

void z_not (zword a)
{

    store (~a);

}/* z_not */

/*
 * z_or
 *
 * Bitwise OR.
 *
 */

void z_or (zword a, zword b)
{

    store (a | b);

}/* z_or */

/*
 * z_sub
 *
 * Subtract two operands.
 *
 */

void z_sub (zword a, zword b)
{

    store ((short) a - (short) b);

}/* z_sub */

/*
 * z_test
 *
 * Branch if all bits of "flags" are set in "bitmap".
 *
 */

void z_test (zword bitmap, zword flags)
{

    branch ((bitmap & flags) == flags);

}/* z_test */
