/*
 * hotkey.c
 *
 * Hot key functions
 *
 */

#include <stdlib.h>
#include "frotz.h"

extern int stream_record;
extern int replaying;

static int aborting;

/*
 * hot_key_playback
 *
 */

static void hot_key_playback (void)
{

    print_string ("Playback on\n");
    z_input_stream (1);

}/* hot_key_playback */

/*
 * hot_key_recording
 *
 */

static void hot_key_recording (void)
{

    if (replaying) {
	print_string ("Playback off\n");
	z_input_stream (0);
    } else if (stream_record) {
	print_string ("Recording off\n");
	z_output_stream (1, -4, 0, 0);
    } else {
	print_string ("Recording on\n");
	z_output_stream (1, 4, 0, 0);
    }

}/* hot_key_recording */

/*
 * hot_key_seed
 *
 */

static void hot_key_seed (void)
{
    char buffer[6];

    print_string ("Seed random numbers\n");
    print_string ("Enter seed value (or return to randomize): ");

    /* Read new seed value */

    buffer[0] = 0;

    while (read_line (5, buffer, 0, 0) != 13);
    z_new_line ();

    /* Set new seed value */

    seed_random (atoi (buffer));

}/* hot_key_seed */

/*
 * hot_key_undo
 *
 */

static void hot_key_undo (void)
{

    print_string ("Undo one turn\n");

    /* Attempt to undo */

    undo_flag = 0;

    z_restore_undo (1);

    if (undo_flag == 0) {
	print_string ("No more undo information available.\n");
	return;
    }

    /* See if this a V5+ game... */

    if (h_version >= V5) {

	/* Store 2 for successful undo */

	store (2);

	/* Abort current input action */

	aborting = 1;
    }

}/* hot_key_undo */

/*
 * hot_key_restart
 *
 */

static void hot_key_restart (void)
{
    int key;

    print_string ("New game\n");
    print_string ("Do you wish to restart? (y/n) >");

    /* Read yes or no */

    key = read_char (0);
    z_new_line ();

    if (key != 'y' && key != 'Y')
	return;

    /* Restart */

    z_restart ();

    /* Abort current input action */

    aborting = 1;

}/* hot_key_restart */

/*
 * hot_key_quit
 *
 */

static void hot_key_quit (void)
{
    int key;

    print_string ("Exit game\n");
    print_string ("Do you wish to quit? (y/n) >");

    /* Read yes or no */

    key = read_char (0);
    z_new_line ();

    if (key != 'y' && key != 'Y')
	return;

    /* Quit */

    z_quit ();

    /* Abort current input action */

    aborting = 1;

}/* hot_key_quit */

/*
 * hot_key
 *
 * Perform the action associated with a so-called hot key. Returns true
 * to signal that the current input instruction should be aborted.
 *
 */

int hot_key (int key)
{

    aborting = 0;

    if (cwin == 0) {

	print_string ("\nHot key -- ");

	if (key == HOT_KEY_RECORDING)
	    hot_key_recording ();
	if (key == HOT_KEY_PLAYBACK)
	    hot_key_playback ();
	if (key == HOT_KEY_SEED)
	    hot_key_seed ();
	if (key == HOT_KEY_UNDO)
	    hot_key_undo ();
	if (key == HOT_KEY_RESTART)
	    hot_key_restart ();
	if (key == HOT_KEY_QUIT)
	    hot_key_quit ();
    }

    return aborting;

}/* hot_key */
