title_screen =
#	 123456789-123456789-123456789-123456789-
	"    Welcome to Mystery Island v0.1a",
	"             by Stu George",
	"",
	"    Based on the C64 version created",
	"      by Mountain Valley Software",
	"    circa somewhere in the mid 80's",
	"",
	"                 Enjoy!";

word_length = 8;
light_time = 25;

noun(north) north;
noun(south) south;
noun(east)  east;
noun(west)  west;
noun(up)    up;
noun(down)  down;

verb(go) 	go;
verb(drop) 	drop, throw;
verb(get) 	get, take;

verb read, see;
verb inventory, inv;

flag intro;				# Set if intro written.
flag(night) night;		# Turn this on for darkness.
flag(runout) runout;	# Set when light has just run out.

flag look_rocks;		#for looking at rocks to find planks

act look any
{
#	"I see nothing special.";
	.room;
}

act quit any
{
	quit;
}

act inventory any
{
	.inv;
}

noun inventory, inv, i
noun look, l, examine, ex, x
noun get, take, pickup, grab, steal, grift
noun drop, putdown, put, place, leave
noun throw, chuck, pitch, lob, toss


# dead room
room rm_Storage "Welcome to the storage closet!";

item crab_meat "Crab Meat";
noun meat;

item planks "planks";
noun planks, wood;

act auto 100 {
	!set intro
	set intro

	# setup some defaults.
	off look_rocks;

	# move hidden objects...
	move NeverNever, crab_meat;
	move NeverNever, planks;

	"Welcome to the Mysterious Island!  Your goal is to "
	"find and store all ten treasures hidden on the island "
	"by the nasty long dead pirate Barnabous Redbeard!~"
	"~"
	"Good luck!";
}


room Shore
	"I'm on the shore.",
	s_to Peninsula,
	w_to Rocks,
	n_to Plain_Path;

item crab "Giant Crab";
noun crab;

item rotten_tree "Tree";
noun tree;

act climb tree
{
	here(rotten_tree);
	"Your weight is too much for the rotten tree and it snaps.";
	die;
}

act look tree
{
	here(rotten_tree);
	"Its old and rotten.~There is writing on the trunk.";
}

act read writing
{
	here(rotten_tree);
	"It says~'2 - 1 = 3'";
}

act get crab
{
	here(crab);
	"You grab the giant crab, which grabs you!  Its pincers crush the life out of you.";
	die;
}

act get crab
{
	here(crab_meat);
	get crab_meat;
}

act kill crab
{
	here(crab);
	swap crab, crab_meat;
	"You kill the crab.";
}

act go south
{
	in(Shore);
	here(crab);
	"The crab won't let me.";
}

room Peninsula
	"Sandy Peninsula.",
	n_to Shore;


room Rocks
	"I am by a cliff.",
	e_to Shore;

item rocks "Rocks";
noun rock;

item ship "Wrecked Ship";
noun ship;

act look rocks
{
	in(Rocks);
	!set(look_rocks);
	on look_rocks;
	move Rocks, planks;
}

room Shipwreck "Wrecked Ship"
	"I am on the deck of a ship.",
	n_to Rocks;

act go ship
{
	in(Rocks);
	goto Shipwreck;
}

item cabin "cabin";
noun cabin;
item closed_cabin_door "closed door";
noun door;

item cutlass "cutlass";
noun cutlass, sword;

item rope "rope";
noun rope;


room Plain_Path
	"I'm on a path leading inland.",
	n_to Foot_of_Cliff,
	w_to Next_to_Hut,
	s_to Shore;

item sign "Sign";
noun sign;

act read sign
{
	in(Plain_Path);
	"It says...~'Beware of the CAT.'";
}


room Next_to_Hut
	"I am on the banks of a river.",
	e_to Plain_Path;

item river "River";
noun river;

item wooden_hut "Wooden Hut";
noun hut;

act look river
{
	in(Next_to_Hut);
	"It's very deep and turbulent.";
}

room Foot_of_Cliff
	"I am at the foot of a sheer cliff.",
	s_to Plain_Path;

item boulder "boulder";
noun boulder;

act look cliff
{
	in(Foot_of_Cliff);
	"There's writing on the cliff.";
}

act read writing
{
	in(Foot_of_Cliff);
	"It Says~'Say the Magic Word'.";
}

act dig any
{
	"What good is that?";
}

act climb any
{
	"You will achieve nothing by that.";
}

initial=Shore;
