/*
**      Line mode frontend for JScott 1.00
**      Scott Adams Classic Adventure driver in Java.
**      Copyright (C) 1998 Vasyl Tsvirkunov.
**
**      This is intended to be a test for driver, not a
**      standalone program. It is rather ugly and not
**      very comfortable to play with. However it has one
**      advantage over applet version - it supports save
**      and load. Compiler reports one warning about readLine()
**      which is deprecated in class library. Ignore.
*/

import java.io.*;
import java.lang.reflect.Array;

////////////////////////////////////////////////////////////////////////////
final public class JScottTest
	implements UserInterface
{
        private Adventure adventure;

// The first argument is game script file (mandatory), the second is language
// translation file (optional)
	public static void main(String args[])
        	throws FileNotFoundException, IOException
	{
                JScottTest theGame = new JScottTest();
                theGame.run(args);
	}


        public void run(String args[]) throws FileNotFoundException, IOException
        {
                InputStream languageData = null;
                InputStream gameData = null;
                InputStream loadData = null;

                if(Array.getLength(args) < 1)
                {
                        System.out.println("Error: script name is required!");
                        return;
                }

                if(Array.getLength(args) >= 2)
                {
	                try
        	        {
                	        languageData = new FileInputStream(args[1]);
	                }
        	        catch(FileNotFoundException ex)
                	{
	                }
                }
                try
                {
                        gameData = new FileInputStream(args[0]);
                }
                catch(FileNotFoundException ex)
                {
                }
                try
                {
                        System.out.print("Want to restore previously saved game?");
                        if(Character.toUpperCase(new DataInputStream(System.in).readLine().charAt(0)) == 'Y')
	                        loadData = getLoadStream();
                }
                catch(FileNotFoundException ex)
                {
                }

        // Create driver instance and initialize it.
		adventure = new Adventure(this, languageData, gameData);
                adventure.run(loadData);

        // Main game loop.
                while(adventure.tick()) ;
        }

// ****** Interface implementation
// Implementation doesn't need any comments at all

        public void notifyRoomChanged()
        {
        // Formatting, just formatting...
                System.out.println(adventure.describeRoom());

	        String exits[] = adventure.describeExits();
                if(exits != null)
                {
                        int count = Array.getLength(exits);
                        for(int i=0; i<count; i++)
                        {
                                if(i > 1)
                                        System.out.print(", ");
                                System.out.print(exits[i]);
                        }
                        System.out.println(".");
                }

                String items[] = adventure.describeItems();
                if(items != null)
                {
                        int count = Array.getLength(items);
                        for(int i=0; i<count; i++)
                        {
                                if(i > 1)
                                        System.out.print(" - ");
                                System.out.print(items[i]);
                        }
                        System.out.println("");
                }
        }

        public void printText(String message)
        {
                System.out.print(message);
        }

        public void clearScreen()
        {
        // How can I clear screen in line mode???
                System.out.println("<***CLS***>");
        }

        public void doPrompt(String message)
        {
                printText(message);
        }

        public String getUserInput()
        {
                try
                {
        	        return new DataInputStream(System.in).readLine();
                }
                catch(IOException ex)
                {
                	return null;
                }
        }

        public void delay(int milliseconds)
        {
        // Huh?
                long goal = System.currentTimeMillis() + milliseconds;
                while(System.currentTimeMillis() < goal) ;
        }

        public OutputStream getSaveStream() throws IOException
        {
                System.out.print("Filename: ");
               	return new FileOutputStream(new DataInputStream(System.in).readLine());
        }

        public InputStream getLoadStream() throws IOException, FileNotFoundException
        {
               	System.out.print("Filename: ");
                return new FileInputStream(new DataInputStream(System.in).readLine());
        }
}

