//
//  This is a TADS 3 source file, for misc. testing of XTads.
//  Copyright (c) 2015 by Rune Berg.
//

#include <adv3.h>
#include <en_us.h>


gameMain: GameMainDef
	initialPlayerChar = me
   showIntro()   
   	{ 
		"Welcome to the XTads tests game<p>";
   	} 
   showGoodbye()   
   	{ 
   	"OK, bye.\b";   
   	} 
   maxScore = 100
   ;

versionInfo: GameID
	name = 'XTads tests'
	byline = 'by Rune Berg'
	htmlByline = 'by <a href="mailto:runeberg76@gmail.com">Rune Berg</a>'
	version = '1.'
	authorEmail = 'runeberg76@gmail.com' 
  	desc = 'XTads tests.'   
  	htmlDesc = 'XTads tests.'
  	showCredit()
  		{ 
  		/* show our credits */   
  		"The TADS 3 language and library were created by Michael J. Roberts.";
  		"\b";   
  		} 
  	showAbout()   
  		{ 
  		"XTads tests.
  		<p>";
  		} 
  ;

me: Actor
   desc
	   {
	   "You are the xtads tester :-)";
	   }
	location()
		{
		return testRoom;
		}
	;

testRoom: Room 
	roomName = 'XTads Test Room'
	desc 
		{
		"You can only do the following here:<br>
		<br>test files
		<br>test readNoAccess
		<br>test readGameDirOnly
		<br>test readAnywhere
		<br>test writeNoAccess
		<br>test writeGameDirOnly
		<br>test writeAnywhere
		<br>test pseudotagP
		<br>test styletags
		";
		}
	;

/* 
 *  "test topic"
 */

DefineTopicAction(Test)
	execAction()
		{
		local tt = getTopic().getTopicText();
		if (tt == 'files')	
			{
			test_files();
			}
		else if (tt == 'readNoAccess')
			{
			test_read_no_access();
			}
		else if (tt == 'readGameDirOnly')
			{
			test_read_game_dir_only();
			}
		else if (tt == 'readAnywhere')
			{
			test_read_anywhere();
			}
		else if (tt == 'writeNoAccess')
			{
			test_write_no_access();
			}
		else if (tt == 'writeGameDirOnly')
			{
			test_write_game_dir_only();
			}
		else if (tt == 'writeAnywhere')
			{
			test_write_anywhere();
			}
		else if (tt == 'pseudotagP')
			{
			test_pseudotag_p();
			}
		else if (tt == 'styletags')
			{
			test_style_tags();
			}
		else 
			{
			"Sorry, no test named \"<<tt>>\"";
			}
		}
	;

VerbRule(test)
   'test' singleTopic
   : TestAction
   verbPhrase = 'test/testing (what)'
   askDobjResponseProd = singleNoun
	;

