#include <tads.h>
#include <file.h>

// Test access to resource files, both bundled within the game file and external

main(args)
{
	local resourceList = [
		'resfile1.txt',
		'resfile2.txt',
		'alias3',
		'resfolder/resfileInFolder1.txt',
		'extResfileA.txt',
		'extresfolder/extResfileInFolder.txt',
		'terpEmbeddedResfileA.txt',
		'nonExistingResfile.non',
		'../resFileOutsideGameDir.txt',
		'/etc/bashrc'
	];
	
	for (local r in resourceList) {
		dumpContentsOfResource(r);
	}
	
	for (local r in resourceList) {
		showIfResourceExists(r);
	}
	
	"\bDone!";
}

dumpContentsOfResource(resourceName) {

	"<b>---- <<resourceName>> ----</b>\b";
	try {
   	local f = File.openTextResource(resourceName, 'UTF-8');
    	for (local linenum = 1 ; ; ++linenum) {
      	local txt;
        	if ((txt = f.readFile()) == nil) {
            break;
         }
        	"<<linenum>>:<<txt.htmlify()>>";
   	}
		"&lt;&lt;EOF&gt;&gt;";

	} catch (FileNotFoundException e) {
		"*** Caught a FileNotFoundException: <<e.exceptionMessage>>";

	} catch (FileOpenException e) {
		"*** Caught a FileOpenException: <<e.exceptionMessage>>";

	} catch (FileSafetyException e) {
		"*** Caught a FileSafetyException: <<e.exceptionMessage>>";

	} catch (FileException e) {
		"*** Caught another FileException: <<e.exceptionMessage>>";
	}
	"\b";
}

showIfResourceExists(resourceName) {

	local existsBit = (resExists(resourceName) ? 'Yes' : 'No');
	"<<resourceName>> exists? <<existsBit>>\n";
}