#include <tads.h>

/*
 * An XTads test game.
 * Focus is on auto-scrolling for grid banner.
 */
main(args)
{
	local b0 = nil;
	local b1;
    
    "A banner test game for XTads.";
    
    //------------

    "\bGrid banner with vert auto-scroll, scroll-bar:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleVScroll | BannerStyleAutoVScroll);
    bannerSetTextColor(b1, ColorYellow, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    fillGridHorizontally(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with vert auto-scroll, no scroll-bar:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleAutoVScroll);
    bannerSetTextColor(b1, ColorYellow, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    fillGridHorizontally(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with horiz auto-scroll with scroll-bar:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleHScroll | BannerStyleAutoHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    fillGridHorizontally(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with horiz auto-scroll without scroll-bar:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleAutoHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    fillGridHorizontally(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with vert & horiz auto-scroll with scroll-bars:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleVScroll | BannerStyleAutoVScroll | BannerStyleHScroll | BannerStyleAutoHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    fillGridHorizontally(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with vert & horiz auto-scroll without scroll-bars:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleAutoVScroll | BannerStyleAutoHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    fillGridHorizontally(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

	 //--------------    
    
    "\bPress another key to exit...\n";
    inputKey();
}

fillGridHorizontally(banner)
{
	local list = ['1111111111', '2222222222', '3333333333', '4444444444', '5555555555', '6666666666', '7777777777', '8888888888', '9999999999', '0000000000'];
	
	for (local i = 1; i <= 11; i++) { 
    	bannerGoTo(banner, i, ((i - 1) * 10) + 1); // 1, 11, 21, ...
    	bannerSay(banner, list[((i - 1) % 10) + 1]); // '1234567890');
    	inputKey();
    }
}
