#include <tads.h>

/*
 * An XTads test game.
 * Focus is on banner view layout.
 */
main(args)
{
	local b0 = nil;
    
    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeText, BannerAlignRight,
                       50, BannerSizePercent,
                       BannerStyleVScroll | BannerStyleAutoVScroll | BannerStyleBorder);
    bannerSay(b1, 'b1 is a
        vertical banner window on the right sized to 50% of the
        total application window size.  Has a border
        and a vertical scrollbar, and automatically scrolls vertically
        when new contents are displayed and they don\'t fit in the
        window\'s existing height. blah blah blaaaah. blah blah blaaaah. blah blah blaaaah. blah blah blaaaah. 
        blah blah blaaaah. blah blAAAAAAh blaaaah. blah blah blaaaah. blah blah blaaaah. blah blah blaaaaaaaaaaaaaaaah. 
        blah blah blaaaah.  blah blah blaaaah.  blah blah blaaaah. blah blah blaaaah. blah blah blaaaah. 
        blah blah blaaaah. blah blah blaaaahaaaaa. blah blah blaaasssssah. blah blah blaaaah. blah blah blaaaah. blah blah blaaaah. 
        blah blah blaaaah. blah blah blaaaah. blaaaaah blah blaaaah. blah blah blaaaah. blah blah blaaaah. blah blah blaaaah. 
        blah blah blaaaah. blah blah blaaaah. blah blah blaaaaaaaaah. blah blah blaaaah. blah blah blaaaah. blah blah blaaaah. 
        blah blah blaaaah. blah?? blah blaaaah. blah blaaaaah blaaaah. ');
    "Press a key to continue...\n";
    inputKey();

    local b2 = bannerCreate(b1, BannerFirst, nil, BannerTypeText, BannerAlignTop,
                       50, BannerSizePercent,
                       0);
    bannerSay(b2, 'b2 (child of b1). horiz banner window above b1, and 50% of its height.
        no border or scroll bars.');

    "Press a key to continue...\n";
    inputKey();

    local b3 = bannerCreate(b1, BannerLast, nil, BannerTypeText, BannerAlignBottom,
                       50, BannerSizePercent,
                       0);
    bannerSay(b3, 'b3 (child of b1). horiz banner window below b1, and 50% of its (remaining) height.
        no border or scroll bars.');

    "Press a key to continue...\n";
    inputKey();

    local b4 = bannerCreate(b0, BannerLast, nil, BannerTypeText, BannerAlignTop,
                       25, BannerSizePercent,
                       0);
    bannerSay(b4, 'b4 (child of b0). horiz banner window above b0, and 25% of its height.
        no border or scroll bars.');

    "Press a key to continue...\n";
    inputKey();

    local b5 = bannerCreate(b0, BannerLast, nil, BannerTypeText, BannerAlignLeft,
                       50, BannerSizePercent,
                       0);
    bannerSay(b5, 'b5 (child of b0). vert banner left of b0, and 50% of its width.
        no border or scroll bars.');

    "Press a key to continue...\n";
    inputKey();

    local b6 = bannerCreate(b5, BannerLast, nil, BannerTypeText, BannerAlignBottom,
                       50, BannerSizePercent,
                       0);
    bannerSay(b6, 'b6 (child of b5). horiz banner below b5, and 50% of its height.
        no border or scroll bars.');

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
