#charset "us-ascii"

/* 
 *  Copyright (c) 2008 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Rulebooks library extension
 *
 *  relation.t
 */

#include "rulebooks.h"

/*--------------------------------------------------------------------
 *
 *  A Relation is an Association for which ALL associations
 *  are evaluated and then its exec() method is invoked.
 *
 *  By default this class returns TRUE.
 */
class Relation: Association
{
    evalCtl     = EvalCtlDoAll
    execCtl     = ExecCtlRetTrue
}

/*--------------------------------------------------------------------
 *
 *  A RelationDoAllRetVal is a Relation for which ALL 
 *  associations are evaluated and then its exec() method
 *  is invoked.
 *
 *  By default this class returns its exec() method VALUE.
 */
class RelationDoAllRetVal: Relation
{
    execCtl     = ExecCtlRetVal
}

/*--------------------------------------------------------------------
 *
 *  A RelationDoAllRetNil is a Relation for which ALL 
 *  associations are evaluated and then its exec() method
 *  is invoked.
 *
 *  By default this class returns NIL.
 */
class RelationDoAllRetNil: Relation
{
    execCtl     = ExecCtlRetNil
}

/*--------------------------------------------------------------------
 *
 *  A RelationDoAllRetTrue is a Relation for which ALL
 *  associations are evaluated and then its exec() method 
 *  is invoked.
 *
 *  By default this class returns TRUE.
 */
class RelationDoAllRetTrue: Relation
;