#charset "us-ascii"

/*
 *   MegaTADS. English-specific header file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#pragma once

/* ---------------------------------------------------------------------- */
/*
 *   A macro for creating a new interjection. This is the interjection
 *   equivalent of VerbRule().
 */
#define Interjection(name) grammar interjection(name):

/*
 *   A macro for matching an interjection in a grammar rule. This is the
 *   interjection equivalent of singleDobj, singleDir, etc.
 */
#define singleInterjection (interjection->itrjc_)

/*
 *   A macro for removing a verb rule by replacing its alternative list with
 *   a single unmatchable string token. We use this internally to remove the
 *   old conversational intransitive actions that have been replaced with
 *   interjections, but it might be useful to others as well.
 */
#define removeVerb(verb) modify VerbRule(verb) ' ' :

/*
 *   Redefine singleDir. We have changed the grammar for directions
 *   slightly, but this redefinition should make sure that the singleDir
 *   production has the same effect as before. 
 */
#undef singleDir
#define singleDir (plainDirectionName->dirMatch)

/*
 *   A new macro, similar to singleDir, but which also allows TO THE NORTH
 *   and NORTHWARDS.
 */
#define toSingleDir (toDirectionName->dirMatch)

/*
 *   Define macros for our special locative pronouns when used as direct or
 *   indirect objects.
 */
#define thereInDobj (thereInPhrase->dobjMatch)
#define thereInIobj (thereInPhrase->iobjMatch)
#define thereOnDobj (thereOnPhrase->dobjMatch)
#define thereOnIobj (thereOnPhrase->iobjMatch)
#define thereUnderDobj (thereUnderPhrase->dobjMatch)
#define thereUnderIobj (thereUnderPhrase->iobjMatch)

/*
 *   Unactor template.
 */
Unactor template 'vocabWords' @targetObj;

/*
 *   DefaultSayTopic template.
 */
DefaultSayTopic template "topicResponse" | [eventList];
DefaultSayTopic template [firstEvents] [eventList];

/*
 *   ContainmentType template.
 */
ContainmentType template 'objInPrep';
