//
//  XTFormattedOutputElement.m
//  TadsTerp
//
//  Created by Rune Berg on 10/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTFormattedOutputElement.h"
#import "XTAllocDeallocCounter.h"


@implementation XTFormattedOutputElement

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

+ (instancetype) regularOutputElement:(NSMutableAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementRegularOutput;
	elt.attributedString = attributedString;
	return elt;
}

+ (instancetype)tabElement:(XTHtmlTag *)htmlTag
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementTab;
	elt.htmlTag = htmlTag;
	return elt;
}


+ (instancetype)gameTitleElement:(NSMutableAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementGameTitle;
	elt.attributedString = attributedString;
	return elt;
}

+ (instancetype)bannerStartElement:(XTHtmlTag *)htmlTag;
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementBannerStart;
	elt.htmlTag = htmlTag;
	return elt;
}

+ (instancetype)bannerEndElement
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementBannerEnd;
	return elt;
}

+ (instancetype)specialActionElement:(XTSpecialAction *)specialAction
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementSpecialAction;
	return elt;
}

+ (instancetype)statusLineModeStart
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementStatusLineModeStart;
	return elt;
}

+ (instancetype)statusLineModeEnd
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementStatusLineModeEnd;
	return elt;
}

+ (instancetype)statusLineModeSuppress
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementStatusLineModeSuppress;
	return elt;
}

- (BOOL)isRegularOutputElement
{
	return (self.elementType == XTFormattedOutputElementRegularOutput);
}

- (BOOL)isRegularOutputElementWithString:(NSString *)str
{
	return [self isRegularOutputElement] && [str isEqualToString:self.attributedString.string];
}

- (BOOL)isTabElement
{
	return (self.elementType == XTFormattedOutputElementTab);
}

- (BOOL)isGameTitleElement
{
	return (self.elementType == XTFormattedOutputElementGameTitle);
}

- (BOOL)isBannerStartElement
{
	return (self.elementType == XTFormattedOutputElementBannerStart);
}

- (BOOL)isBannerEndElement
{
	return (self.elementType == XTFormattedOutputElementBannerEnd);
}

- (BOOL)isSpecialActionElement
{
	return (self.elementType == XTFormattedOutputElementSpecialAction);
}

- (BOOL)isStatusLineModeStart
{
	return (self.elementType == XTFormattedOutputElementStatusLineModeStart);
}

- (BOOL)isStatusLineModeEnd
{
	return (self.elementType == XTFormattedOutputElementStatusLineModeEnd);
}

- (BOOL)isStatusLineModeSuppress
{
	return (self.elementType == XTFormattedOutputElementStatusLineModeSuppress);
}

@end
