//
//  XTMainTextHandler.h
//  TadsTerp
//
//  Created by Rune Berg on 28/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTBaseTextHandler.h"
#import "XTCommandHistory.h"
#import "XTGameWindowController.h"


@interface XTMainTextHandler : XTBaseTextHandler

//TODO rename
@property (weak) NSView *rootBannerContainerView; // for main area's banner handler only

@property NSMutableString *gameTitle;

@property XTCommandHistory *commandHistory;
@property NSUInteger commandPromptPosition;
@property void *activeTagBannerHandle;
@property BOOL statusLineMode;

+ (instancetype)handler;

- (void)removeHandler;

- (void)setIsForT3:(BOOL)isForT3;

- (void)resetToDefaults;

- (void)setNonstopMode:(BOOL)nonstopMode;

- (void)resetForGameHasEndedMsg;

- (BOOL)appendOutput:(NSString *)string;

- (BOOL)needsFlushing;

- (void)flushOutput;

- (void)hardFlushOutput;

- (void)appendInput:(NSString *)string;

- (void)handleCommandLinkClicked:(NSString *)linkString atIndex:(NSUInteger)charIndex;

- (void)ensureInputFontIsInEffect;

- (void)clearText;

- (void)mainThread_getCommand:(NSMutableArray *)returnValue;

- (void)mainThread_createTextViewForMainOutputArea;

- (void)mainThread_noteStartOfLayoutOfViews;

- (void)mainThread_noteEndOfLayoutOfViews;

- (void)mainThread_configureViews;

// the index where new input text is appended
- (NSInteger)insertionPoint;

- (NSInteger)minInsertionPoint;

- (void)replaceCommandText:(NSString *)newCommandText;

- (BOOL)allowTextInsertion:(NSRange)affectedCharRange;

- (void)goToPreviousCommand;

- (void)goToNextCommand;

@end
