//
//  XTTabStopModelEntry.m
//  XTads
//
//  Created by Rune Berg on 06/02/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import "XTTabStopModelEntry.h"
#import "XTAllocDeallocCounter.h"


@implementation XTTabStopModelEntry

static NSDictionary<NSString *,id> *optionsNone;
static NSDictionary<NSString *,id> *optionsDefault;

+ (void)initialize
{
	optionsNone = [NSDictionary dictionaryWithObjectsAndKeys:
				   XT_TAB_TYPE_TO_ID, XT_TAB_TYPE_KEY,
				   nil];
	
	NSCharacterSet *columnTerminatorCharSet = [NSCharacterSet characterSetWithCharactersInString:XT_TABSTOP_DEFAULT_DEC_CHAR];
	optionsDefault = [NSDictionary dictionaryWithObjectsAndKeys:
					  XT_TAB_TYPE_TO_ID, XT_TAB_TYPE_KEY,
					  columnTerminatorCharSet, NSTabColumnTerminatorsAttributeName,
					  nil];
}

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

- (id)init
{
	self = [super init];
	if (self) {
		_ident = nil;
		_position = nil;
		_positionAdjustmentForDecimalPoint = 0.0;
		_alignment = nil;
		_decimalChar = nil;
	}
	return self;
}

- (NSString *)effectiveDecimalChar
{
	NSString *res;
	switch (self.decimalChar.length) {
		case 1:
			res = self.decimalChar;
			break;
		case 0:
			res = XT_TABSTOP_DEFAULT_DEC_CHAR;
			break;
		default:
			res = [self.decimalChar substringToIndex:1];
			break;
	}
	return res;
}

- (id)copyWithZone:(NSZone *)zone
{
	XTTabStopModelEntry *copy = [XTTabStopModelEntry new];
	copy.ident = [self.ident copy];
	copy.position = [self.position copy];
	copy.positionAdjustmentForDecimalPoint = self.positionAdjustmentForDecimalPoint;
	copy.alignment = [self.alignment copy];
	copy.decimalChar = [self.decimalChar copy];
	return copy;
}

- (BOOL)decimalPointAligned
{
	BOOL res = (self.alignment.integerValue == XTTABSTOP_ALIGN_DEC_POINT);
	return res;
}

- (NSTextAlignment)nsTextAlignment
{
	NSTextAlignment res = NSLeftTextAlignment;
	if (self.alignment != nil) {
		switch (self.alignment.integerValue) {
			case XTTABSTOP_ALIGN_LEFT:
				res = NSLeftTextAlignment;
				break;
			case XTTABSTOP_ALIGN_CENTER:
				res = NSCenterTextAlignment;
				break;
			case XTTABSTOP_ALIGN_RIGHT:
				res = NSRightTextAlignment;
				break;
			case XTTABSTOP_ALIGN_DEC_POINT:
				res = NSRightTextAlignment;
				break;
		}
	}
	return res;
}

- (NSDictionary<NSString *,id> *)nsTextAlignmentOptions
{
	NSMutableDictionary<NSString *,id> *tempRes = [optionsNone mutableCopy];
	if (self.alignment != nil) {
		if (self.alignment.integerValue == XTTABSTOP_ALIGN_DEC_POINT) {
			if (self.decimalChar == nil || self.decimalChar.length == 0) {
				tempRes = [optionsDefault mutableCopy];
			} else {
				NSString *colTermChar = [self.decimalChar substringToIndex:1];
				NSCharacterSet *customColumnTerminatorCharSet = [NSCharacterSet characterSetWithCharactersInString:colTermChar];
				[tempRes setObject:customColumnTerminatorCharSet forKey:NSTabColumnTerminatorsAttributeName];
			}
		}
	}
	
	if (self.ident != nil && self.ident.length >= 1) {
		[tempRes setObject:self.ident forKey:XT_TAB_ID_KEY];
	}
	
	[tempRes setObject:self forKey:XT_TAB_MODEL_ENTRY_KEY];
	
	NSDictionary<NSString *,id> *res = [NSDictionary dictionaryWithDictionary:tempRes];
	return res;
}

@end
