//
//  XTHtmlTag.h
//  TadsTerp
//
//  Created by Rune Berg on 29/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTOutputFormatterProtocol.h"

@protocol XTOutputFormatterProtocol; // fwd decl.


@interface XTHtmlTag : NSObject

+ (NSString *)name; // for <BR> this would be "BR"
+ (NSArray *)allowedAttributes;
+ (BOOL)standalone;
+ (BOOL)blockLevel;
+ (BOOL)blockLevelSpacing;

@property BOOL closing;
@property NSMutableDictionary *attributes;

- (NSArray *)dispatchToFormatter:(NSObject<XTOutputFormatterProtocol> *)formatter;

- (BOOL)hasAttribute:(NSString *)attributeName;

- (BOOL)hasAttribute:(NSString *)attributeName withCaseInsensitiveValue:(NSString *)value;
	//TODO use whenever appr

- (NSString *)attributeAsString:(NSString *)attributeName;

- (BOOL)attribute:(NSString *)attributeName asOptionalSign:(NSInteger*)sign andUint:(NSUInteger*)uint;

- (NSUInteger)attributeAsUInt:(NSString *)attributeName;

//- (NSInteger)attributeAsInt:(NSString *)attributeName;

- (NSArray *)attributeAsCommaSeparatedStrings:(NSString *)attributeName;

- (BOOL)isStandalone;

- (BOOL)isBlockLevel;

- (BOOL)needsBlockLevelSpacing;
//TODO use for more tags? <p> ...

- (NSString *)debugString;

@end
